/*
 * Decompiled with CFR 0.152.
 */
package org.relique.jdbc.csv;

import org.relique.jdbc.csv.JoinType;
import org.relique.jdbc.csv.LogicalExpression;
import org.relique.jdbc.csv.ParsedStatement;

class ParsedTable {
    private JoinType joinType;
    private LogicalExpression joinClause;
    private String tableName;
    private String tableAlias;
    private ParsedStatement derivedTableStatement;

    public ParsedTable(String tableName, String tableAlias) {
        this.joinType = JoinType.NONE;
        this.joinClause = null;
        this.tableName = tableName;
        this.tableAlias = tableAlias;
    }

    public ParsedTable(JoinType joinType, LogicalExpression joinClause, String tableName, String tableAlias) {
        this.joinType = joinType;
        this.joinClause = joinClause;
        this.tableName = tableName;
        this.tableAlias = tableAlias;
    }

    public ParsedTable(ParsedStatement parsedStatement, String tableAlias) {
        this.derivedTableStatement = parsedStatement;
        this.tableAlias = tableAlias;
    }

    public ParsedTable(JoinType joinType, LogicalExpression joinClause, ParsedTable joinedTable) {
        this.joinType = joinType;
        this.joinClause = joinClause;
        if (joinedTable.isDerivedTable()) {
            this.derivedTableStatement = joinedTable.getDerivedTableStatement();
        } else {
            this.tableName = joinedTable.getTableName();
        }
        this.tableAlias = joinedTable.getTableAlias();
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public LogicalExpression getJoinClause() {
        return this.joinClause;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public boolean isDerivedTable() {
        return this.derivedTableStatement != null;
    }

    public ParsedStatement getDerivedTableStatement() {
        return this.derivedTableStatement;
    }
}

