/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.data.handlers;

import com.dbeaver.db.mongodb.data.handlers.MongoDocumentValueHandler;
import com.dbeaver.db.mongodb.data.handlers.MongoIdValueHandler;
import com.dbeaver.db.mongodb.data.handlers.MongoListValueHandler;
import com.dbeaver.db.mongodb.data.handlers.MongoTimestampValueHandler;
import com.dbeaver.model.document.handlers.DocumentValueHandlerProvider;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDFormatSettings;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class MongoValueHandlerProvider
extends DocumentValueHandlerProvider {
    @Nullable
    public DBDValueHandler getValueHandler(DBPDataSource dataSource, DBDFormatSettings preferences, DBSTypedObject typedObject) {
        switch (typedObject.getDataKind()) {
            case ROWID: {
                return MongoIdValueHandler.INSTANCE;
            }
            case DATETIME: {
                return new MongoTimestampValueHandler(preferences);
            }
            case ARRAY: {
                return MongoListValueHandler.INSTANCE;
            }
            case DOCUMENT: {
                return MongoDocumentValueHandler.INSTANCE;
            }
        }
        return super.getValueHandler(dataSource, preferences, typedObject);
    }
}

