/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.odbc.model;

import com.dbeaver.jdbc.odbc.JdbcOdbcBridgeDriver;
import java.sql.Driver;
import java.util.HashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.utils.CommonUtils;

public class OdbcDataSource
extends GenericDataSource {
    public OdbcDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container, @NotNull GenericMetaModel metaModel, @NotNull SQLDialect dialect) throws DBException {
        super(monitor, container, metaModel, dialect);
    }

    protected String getConnectionURL(DBPConnectionConfiguration configuration) {
        StringBuilder buffer = new StringBuilder("jdbc:dbodbc:");
        String mode = configuration.getProviderProperty("odbc-connection-mode");
        if (mode == null) {
            mode = "dsn";
        }
        switch (mode) {
            case "dsn": {
                buffer.append("DSN=").append(configuration.getDatabaseName()).append(';');
                break;
            }
            case "manual": {
                buffer.append("DRIVER=").append(configuration.getServerName()).append(';');
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported connection mode: " + mode);
            }
        }
        return buffer.toString();
    }

    protected boolean isPopulateClientAppName() {
        return false;
    }

    @Nullable
    protected Map<String, String> getInternalConnectionProperties(DBRProgressMonitor monitor, DBPDriver driver, JDBCExecutionContext context, String purpose, DBPConnectionConfiguration configuration) {
        String mode = configuration.getProviderProperty("odbc-connection-mode");
        HashMap<String, String> props = new HashMap<String, String>();
        if (CommonUtils.isNotEmpty((String)configuration.getUserName())) {
            props.put("UID", configuration.getUserName());
            props.put("PWD", configuration.getUserPassword());
        }
        if ("manual".equals(mode)) {
            props.put("Server", configuration.getHostName());
            props.put("Port", configuration.getHostPort());
            if (CommonUtils.isNotEmpty((String)configuration.getDatabaseName())) {
                props.put("Database", configuration.getDatabaseName());
            }
        }
        if (this.container.getNavigatorSettings().isShowSystemObjects()) {
            props.putIfAbsent("ShowSystemTables", "1");
        }
        if (this.container.isConnectionReadOnly()) {
            props.putIfAbsent("ReadOnly", "1");
        }
        return props;
    }

    @Nullable
    protected Driver getDriverInstance(@NotNull DBRProgressMonitor monitor) {
        return JdbcOdbcBridgeDriver.getInstance();
    }
}

