/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.auth.profile;

import com.dbeaver.ui.auth.profile.AuthModelProfileMessages;
import com.dbeaver.ui.auth.profile.AuthProfileManagerDialog;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBAAuthProfile;
import org.jkiss.dbeaver.model.connection.DBPAuthModelDescriptor;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class AuthModelProfileConfigurator
implements IObjectPropertyConfigurator<Object, DBPDataSourceContainer> {
    private static final Log log = Log.getLog(AuthModelProfileConfigurator.class);
    private DBPDataSourceContainer dataSource;
    private Combo profilesCombo;
    private DBAAuthProfile activeProfile;
    private List<DBAAuthProfile> authProfiles;

    public void createControl(@NotNull Composite parent, Object object, final @NotNull Runnable propertyChangeListener) {
        Composite profileGroup = parent;
        UIUtils.createControlLabel((Composite)profileGroup, (String)AuthModelProfileMessages.profile_name_label);
        Composite controlsGroup = UIUtils.createComposite((Composite)profileGroup, (int)2);
        controlsGroup.setLayoutData((Object)new GridData(768));
        this.profilesCombo = new Combo(controlsGroup, 12);
        this.profilesCombo.setLayoutData((Object)new GridData(768));
        this.profilesCombo.setToolTipText(AuthModelProfileMessages.profile_name_tip);
        this.profilesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuthModelProfileConfigurator.this.activeProfile = AuthModelProfileConfigurator.this.authProfiles.get(AuthModelProfileConfigurator.this.profilesCombo.getSelectionIndex());
                propertyChangeListener.run();
            }
        });
        UIUtils.createDialogButton((Composite)controlsGroup, (String)AuthModelProfileMessages.manage_profiles_label, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AuthModelProfileConfigurator.this.openProfileManager()) {
                    AuthModelProfileConfigurator.this.refreshAuthProfiles();
                }
            }
        });
    }

    public void loadSettings(@NotNull DBPDataSourceContainer dataSource) {
        this.dataSource = dataSource;
        String activeProfileID = dataSource.getConnectionConfiguration().getAuthProperty("profile-id");
        if (!CommonUtils.isEmpty((String)activeProfileID)) {
            this.activeProfile = dataSource.getProject().getDataSourceRegistry().getAuthProfile(activeProfileID);
        }
        this.refreshAuthProfiles();
    }

    private void refreshAuthProfiles() {
        String prevActiveProfile = this.activeProfile == null ? null : this.activeProfile.getProfileId();
        this.authProfiles = this.dataSource.getProject().getDataSourceRegistry().getApplicableAuthProfiles(this.dataSource.getDriver());
        this.activeProfile = prevActiveProfile == null ? null : this.dataSource.getProject().getDataSourceRegistry().getAuthProfile(prevActiveProfile);
        this.profilesCombo.removeAll();
        for (DBAAuthProfile profile : this.authProfiles) {
            DBPAuthModelDescriptor authModel = profile.getAuthModel();
            String profileName = profile.getProfileName();
            if (authModel != null) {
                profileName = String.valueOf(profileName) + " (" + authModel.getName() + ")";
            }
            this.profilesCombo.add(profileName);
            if (profile != this.activeProfile) continue;
            this.profilesCombo.select(this.profilesCombo.getItemCount() - 1);
        }
    }

    public void saveSettings(@NotNull DBPDataSourceContainer dataSource) {
        dataSource.getConnectionConfiguration().setAuthProperty("profile-id", this.activeProfile == null ? null : this.activeProfile.getProfileId());
    }

    public void resetSettings(@NotNull DBPDataSourceContainer dataSource) {
    }

    public boolean isComplete() {
        return this.profilesCombo.getSelectionIndex() >= 0;
    }

    private boolean openProfileManager() {
        AuthProfileManagerDialog dialog = new AuthProfileManagerDialog(this.profilesCombo.getShell(), this.dataSource.getProject(), this.dataSource.getDriver(), this.activeProfile);
        return dialog.open() == 0;
    }
}

