/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.handler;

import java.util.List;
import org.mockito.internal.InternalMockHandler;
import org.mockito.internal.stubbing.InvocationContainer;
import org.mockito.internal.util.Primitives;
import org.mockito.invocation.Invocation;
import org.mockito.mock.MockCreationSettings;
import org.mockito.stubbing.Answer;

class NullResultGuardian<T>
implements InternalMockHandler<T> {
    private final InternalMockHandler<T> delegate;

    public NullResultGuardian(InternalMockHandler<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public Object handle(Invocation invocation) throws Throwable {
        Object result = this.delegate.handle(invocation);
        Class<?> returnType = invocation.getMethod().getReturnType();
        if (result == null && returnType.isPrimitive()) {
            return Primitives.defaultValue(returnType);
        }
        return result;
    }

    @Override
    public MockCreationSettings<T> getMockSettings() {
        return this.delegate.getMockSettings();
    }

    @Override
    public void setAnswersForStubbing(List<Answer<?>> answers) {
        this.delegate.setAnswersForStubbing(answers);
    }

    @Override
    public InvocationContainer getInvocationContainer() {
        return this.delegate.getInvocationContainer();
    }
}

