/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql;

import java.util.List;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.sql.SQLParametersProvider;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryParameter;
import org.jkiss.dbeaver.model.sql.SQLScriptContext;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.sql.dialogs.SQLQueryParameterBindDialog;

public class SQLEditorParametersProvider
implements SQLParametersProvider {
    private IWorkbenchPartSite site;

    public SQLEditorParametersProvider(IWorkbenchPartSite site) {
        this.site = site;
    }

    public Boolean prepareStatementParameters(@NotNull SQLScriptContext scriptContext, @NotNull SQLQuery sqlStatement, @NotNull List<SQLQueryParameter> parameters, boolean useDefaults) {
        for (SQLQueryParameter param : parameters) {
            Object defValue;
            Object paramName = param.getName();
            Object object = defValue = useDefaults ? scriptContext.getParameterDefaultValue((String)paramName) : null;
            if (defValue != null || scriptContext.hasVariable((String)paramName)) {
                this.assignVariable(scriptContext, param, (String)paramName, defValue);
                continue;
            }
            paramName = param.getVarName();
            Object object2 = defValue = useDefaults ? scriptContext.getParameterDefaultValue((String)paramName) : null;
            if (defValue != null || scriptContext.hasVariable((String)paramName)) {
                this.assignVariable(scriptContext, param, (String)paramName, defValue);
                continue;
            }
            if (useDefaults) continue;
            param.setVariableSet(false);
        }
        boolean allSet = true;
        for (SQLQueryParameter param : parameters) {
            if (param.isVariableSet()) continue;
            allSet = false;
        }
        if (allSet) {
            return true;
        }
        int paramsResult = (Integer)UITask.run(() -> {
            SQLQueryParameterBindDialog dialog = new SQLQueryParameterBindDialog(this.site, sqlStatement, parameters);
            return dialog.open();
        });
        if (paramsResult == 0) {
            for (SQLQueryParameter param : parameters) {
                if (!param.isNamed()) continue;
                String strValue = param.getValue();
                if (scriptContext.hasVariable(param.getName())) {
                    scriptContext.setVariable(param.getName(), (Object)strValue);
                    continue;
                }
                if (scriptContext.hasVariable(param.getVarName())) {
                    scriptContext.setVariable(param.getVarName(), (Object)strValue);
                    continue;
                }
                scriptContext.setParameterDefaultValue(param.getName(), (Object)strValue);
            }
            return true;
        }
        if (paramsResult == 9) {
            scriptContext.setIgnoreParameters(true);
            return null;
        }
        return false;
    }

    private void assignVariable(@NotNull SQLScriptContext scriptContext, SQLQueryParameter param, String paramName, Object defValue) {
        Object varValue = defValue != null ? defValue : scriptContext.getVariable(paramName);
        String strValue = varValue == null ? null : varValue.toString();
        param.setValue(strValue);
        param.setVariableSet(true);
    }
}

