/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.cassandra.data;

import com.datastax.driver.core.DataType;
import com.dbeaver.db.cassandra.CasUtils;
import com.dbeaver.db.cassandra.data.CasCollectionValue;
import com.dbeaver.db.cassandra.model.CasDataSource;
import com.dbeaver.db.cassandra.model.CasDataType;
import com.dbeaver.db.cassandra.model.CasExecutionContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDCollection;
import org.jkiss.dbeaver.model.data.DBDComposite;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValueCloneable;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.struct.AbstractAttribute;
import org.jkiss.dbeaver.model.impl.struct.AbstractStructDataType;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class CasMapValue
extends CasCollectionValue
implements DBDCollection,
DBDValueCloneable {
    private final DataType mapType;
    private final EntryType entryType;
    private final EntryAttribute[] attributes;
    private List<EntryComposite> contents;
    private boolean modified;

    public CasMapValue(CasExecutionContext executionContext, String keyspace, Map<?, ?> contents, DataType mapType) throws DBCException {
        super(executionContext, keyspace);
        if (contents != null) {
            this.contents = new ArrayList<EntryComposite>();
            for (Map.Entry<?, ?> entry : contents.entrySet()) {
                this.contents.add(new EntryComposite(entry));
            }
        }
        this.mapType = mapType;
        this.entryType = new EntryType();
        this.attributes = new EntryAttribute[2];
        this.attributes[0] = new EntryAttribute("key", (DataType)mapType.getTypeArguments().get(0), 0);
        this.attributes[1] = new EntryAttribute("value", (DataType)mapType.getTypeArguments().get(1), 1);
    }

    public CasMapValue(CasMapValue copyFrom) {
        super(copyFrom);
        this.contents = new ArrayList<EntryComposite>(copyFrom.contents);
        this.mapType = copyFrom.mapType;
        this.entryType = copyFrom.entryType;
        this.attributes = copyFrom.attributes;
    }

    public CasDataSource getDataSource() {
        return (CasDataSource)this.executionContext.getDataSource();
    }

    @NotNull
    public DBSDataType getComponentType() {
        return this.entryType;
    }

    @NotNull
    public DBDValueHandler getComponentValueHandler() {
        return DBUtils.findValueHandler((DBPDataSource)this.executionContext.getDataSource(), (DBSTypedObject)this.entryType);
    }

    public DBDValueCloneable cloneValue(DBRProgressMonitor monitor) {
        return new CasMapValue(this);
    }

    public Object getRawValue() {
        return this.contents;
    }

    public boolean isNull() {
        return this.contents == null;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void release() {
        this.contents = null;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        CasDataSource dataSource = (CasDataSource)this.executionContext.getDataSource();
        CasDataType keyType = dataSource.getLocalDataType(this.attributes[0].type.getName().toString());
        if (keyType == null) {
            return String.valueOf(this.attributes[0].type.getName().toString()) + " " + " not found";
        }
        DBDValueHandler cvh = DBUtils.findValueHandler((DBPDataSource)dataSource, (DBSTypedObject)keyType);
        if (cvh == null) {
            return String.valueOf(keyType.getName()) + " " + " handler not found";
        }
        CasDataType valueType = dataSource.getLocalDataType(this.attributes[1].type.getName().toString());
        if (valueType == null) {
            return String.valueOf(this.attributes[1].type.getName().toString()) + " " + " not found";
        }
        DBDValueHandler vvh = DBUtils.findValueHandler((DBPDataSource)dataSource, (DBSTypedObject)valueType);
        if (vvh == null) {
            return String.valueOf(valueType.getName()) + " " + " handler not found";
        }
        StringBuilder str = new StringBuilder(this.contents.size() * 32);
        str.append("{");
        int i = 0;
        while (i < this.contents.size()) {
            EntryComposite item = this.contents.get(i);
            if (i > 0) {
                str.append(',');
            }
            SQLUtils.appendValue((StringBuilder)str, (DBSTypedObject)keyType, (Object)cvh.getValueDisplayString((DBSTypedObject)keyType, item.key, DBDDisplayFormat.NATIVE));
            str.append(" : ");
            SQLUtils.appendValue((StringBuilder)str, (DBSTypedObject)valueType, (Object)cvh.getValueDisplayString((DBSTypedObject)valueType, item.value, DBDDisplayFormat.NATIVE));
            ++i;
        }
        str.append("}");
        return str.toString();
    }

    public int getItemCount() {
        return this.contents == null ? 0 : this.contents.size();
    }

    public DBDComposite getItem(int index) {
        return this.contents.get(index);
    }

    public void setItem(int index, Object value) {
        this.contents.set(index, (EntryComposite)value);
        this.modified = true;
    }

    public void setContents(Object[] contents) {
        this.contents.clear();
        int i = 0;
        while (i < contents.length) {
            this.setItem(i, contents[i]);
            ++i;
        }
        this.modified = true;
    }

    public DataType getMapType() {
        return this.mapType;
    }

    public Map<Object, Object> makeMap() {
        if (this.contents == null) {
            return null;
        }
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>(this.contents.size());
        for (EntryComposite item : this.contents) {
            map.put(item.key, CasUtils.unwrapValue(item.value));
        }
        return map;
    }

    private class EntryAttribute
    extends AbstractAttribute
    implements DBSEntityAttribute {
        private DataType type;

        private EntryAttribute(String name, DataType type, int ordinalPosition) {
            super(name, type.getName().toString(), CasUtils.getTypeNameID(type), ordinalPosition, 0L, null, null, true, false);
            this.type = type;
        }

        @Nullable
        public String getDefaultValue() {
            return null;
        }

        @NotNull
        public DBSEntity getParentObject() {
            return CasMapValue.this.entryType;
        }

        @NotNull
        public DBPDataSource getDataSource() {
            return CasMapValue.this.executionContext.getDataSource();
        }

        public DBPDataKind getDataKind() {
            return CasUtils.getDataKind(this.type);
        }
    }

    private class EntryComposite
    implements DBDComposite {
        private Object key;
        private Object value;

        private EntryComposite(Map.Entry<?, ?> value) throws DBCException {
            this.key = value.getKey();
            this.value = CasUtils.wrapValue((DBCExecutionContext)CasMapValue.this.executionContext, CasMapValue.this.keyspace, value.getValue());
        }

        public DBSDataType getDataType() {
            return CasMapValue.this.entryType;
        }

        @NotNull
        public DBSAttributeBase[] getAttributes() {
            return CasMapValue.this.attributes;
        }

        @Nullable
        public Object getAttributeValue(@NotNull DBSAttributeBase attribute) throws DBCException {
            if (attribute.getOrdinalPosition() == 0) {
                return this.key;
            }
            return this.value;
        }

        public void setAttributeValue(@NotNull DBSAttributeBase attribute, @Nullable Object attrValue) throws DBCException {
            if (attribute.getOrdinalPosition() == 0) {
                throw new IllegalArgumentException("Key is read-only");
            }
            this.value = attrValue;
            CasMapValue.this.modified = true;
        }

        public Object getRawValue() {
            return this.value;
        }

        public boolean isNull() {
            return false;
        }

        public boolean isModified() {
            return CasMapValue.this.modified;
        }

        public void release() {
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private class EntryType
    extends AbstractStructDataType<CasDataSource>
    implements DBSEntity {
        public EntryType() {
            super((DBPDataSource)((CasDataSource)CasMapValue.this.executionContext.getDataSource()));
        }

        public String getTypeName() {
            return CasMapValue.this.mapType.getName().toString();
        }

        public int getTypeID() {
            return CasUtils.getTypeNameID(CasMapValue.this.mapType);
        }

        public DBPDataKind getDataKind() {
            return DBPDataKind.STRUCT;
        }

        @NotNull
        public DBSEntityType getEntityType() {
            return DBSEntityType.VIRTUAL_ENTITY;
        }

        @Nullable
        public List<? extends DBSEntityAttribute> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
            return Arrays.asList(CasMapValue.this.attributes);
        }
    }
}

