/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.lm.ui;

import com.dbeaver.lm.app.LMAppUtils;
import com.dbeaver.lm.embedded.LicenseServiceEmbedded;
import java.util.Date;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.lm.LMException;
import org.jkiss.lm.LMLicense;
import org.jkiss.lm.LMLicenseType;
import org.jkiss.lm.LMProduct;
import org.jkiss.lm.LMService;
import org.jkiss.lm.LMStatusDetails;
import org.jkiss.lm.LMUtils;
import org.jkiss.utils.CommonUtils;

public class LicenseMissingDialog
extends IconAndMessageDialog {
    public static final int IMPORT_BUTTON_ID = 1000;
    public static final int TRIAL_BUTTON_ID = 1001;
    public static final int LM_BUTTON_ID = 1002;
    private final Throwable validationError;

    public LicenseMissingDialog(Shell parentShell, Throwable validationError) {
        super(parentShell);
        this.validationError = validationError;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        try {
            String shortMessage;
            LMService licenseService = LMAppUtils.getLicenseService();
            LMProduct product = LMAppUtils.getActiveProduct();
            LMLicense[] productLicenses = licenseService.getAllProductLicenses();
            LMLicense lastLicense = null;
            Date mostRecentDate = null;
            LMLicense[] lMLicenseArray = productLicenses;
            int n = productLicenses.length;
            int n2 = 0;
            while (n2 < n) {
                LMLicense license = lMLicenseArray[n2];
                if (mostRecentDate == null || license.getLicenseType() != LMLicenseType.TRIAL || license.getLicenseStartTime().compareTo(mostRecentDate) > 0) {
                    lastLicense = license;
                    mostRecentDate = license.getLicenseStartTime();
                }
                ++n2;
            }
            if (lastLicense == null) {
                shortMessage = "No license found";
                this.message = "License for '" + product.getName() + "' not found" + ".\nYou need to import a valid license or obtain a new one.";
            } else if (this.validationError != null) {
                shortMessage = "License validation failed";
                this.message = CommonUtils.notEmpty((String)this.validationError.getMessage());
            } else {
                LMStatusDetails licenseStatus = lastLicense.getLicenseStatus(product);
                shortMessage = licenseStatus.getMessage();
                this.message = licenseStatus.getDetails();
            }
            this.getShell().setText(shortMessage);
            Composite composite = (Composite)super.createDialogArea(parent);
            Composite msgPlaceholder = UIUtils.createPlaceholder((Composite)composite, (int)2, (int)5);
            super.createMessageArea(msgPlaceholder);
            Group licenseGroup = UIUtils.createControlGroup((Composite)composite, (String)"License", (int)2, (int)1808, (int)0);
            Text productText = UIUtils.createLabelText((Composite)licenseGroup, (String)"Product", (String)(String.valueOf(product.getName()) + " " + product.getVersion()), (int)2056);
            productText.setLayoutData((Object)new GridData(768));
            if (lastLicense != null) {
                Text licenseText = UIUtils.createLabelText((Composite)licenseGroup, (String)"License", (String)(String.valueOf(lastLicense.getLicenseId()) + " - " + lastLicense.getLicenseType().getDisplayName() + ", starts at " + LMUtils.HR_DATE_FORMAT.format(lastLicense.getLicenseStartTime())), (int)2056);
                licenseText.setLayoutData((Object)new GridData(768));
            }
            Link label = new Link((Composite)licenseGroup, 0);
            if (lastLicense == null) {
                label.setText("If you have product license then you can import it by pressing the Import button.\nYou can buy a license on DBeaver <a href=\"https://dbeaver.com/buy/?utm_source=app&utm_medium=nolicense&utm_campaign=buy\">web site</a> or you can use trial license.");
            } else {
                String statusText = lastLicense.getLicenseType() == LMLicenseType.TRIAL ? "You can buy or renew license on the official <a href=\"https://dbeaver.com/buy/?utm_source=app&utm_medium=license-expired&utm_campaign=trial\">web site</a>.\n" : "You can buy or renew license on the official <a href=\"https://dbeaver.com/buy/?utm_source=app&utm_medium=license-expired&utm_campaign=paid\">web site</a>.\n";
                label.setText(statusText);
            }
            label.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    UIUtils.openWebBrowser((String)e.text);
                }
            });
            GridData gd = new GridData(1808);
            gd.horizontalSpan = 2;
            label.setLayoutData((Object)gd);
        }
        catch (LMException e) {
            DBWorkbench.getPlatformUI().showError("Error getting license info", "Error getting license info", (Throwable)e);
        }
        return parent;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button button = this.createButton(parent, 1002, "License Manager", true);
        button.setLayoutData((Object)new GridData(768));
        this.createButton(parent, 1000, "Import License", true);
        if (LMAppUtils.getLicenseService() instanceof LicenseServiceEmbedded) {
            this.createButton(parent, 1001, "Trial", false);
        }
        this.createButton(parent, 1, "Exit", false);
    }

    protected Image getImage() {
        return DBeaverIcons.getImage((DBPImage)DBIcon.STATUS_ERROR);
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1002: {
                this.setReturnCode(1002);
                this.close();
                return;
            }
            case 1000: {
                this.setReturnCode(1000);
                this.close();
                return;
            }
            case 1001: {
                try {
                    if (((LicenseServiceEmbedded)LMAppUtils.getLicenseService()).findTrialLicense() == null) {
                        this.setReturnCode(1001);
                        this.close();
                    } else {
                        MessageBox messageBox = new MessageBox(this.getShell(), 1);
                        messageBox.setText("Can't generate trial license");
                        messageBox.setMessage("You can't generate second trial license. Old one has expired");
                        messageBox.open();
                    }
                }
                catch (LMException e) {
                    DBWorkbench.getPlatformUI().showError("Error reading trial license", "Bad trial license", (Throwable)e);
                }
                return;
            }
        }
        super.buttonPressed(buttonId);
    }
}

