/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.facet;

import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.search.facet.NumericRange;
import com.couchbase.client.java.search.facet.SearchFacet;
import java.util.List;

public class NumericRangeFacet
extends SearchFacet {
    private final List<NumericRange> ranges;

    NumericRangeFacet(String field, int limit, List<NumericRange> ranges) {
        super(field, limit);
        this.ranges = ranges;
    }

    @Override
    public void injectParams(JsonObject queryJson) {
        super.injectParams(queryJson);
        JsonArray numericRange = JsonArray.create();
        for (NumericRange nr : this.ranges) {
            JsonObject nrJson = JsonObject.create();
            nrJson.put("name", nr.name());
            if (nr.min() != null) {
                nrJson.put("min", nr.min());
            }
            if (nr.max() != null) {
                nrJson.put("max", nr.max());
            }
            numericRange.add(nrJson);
        }
        queryJson.put("numeric_ranges", numericRange);
    }
}

