/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.keyspaces.ui.views;

import com.datastax.driver.core.ConsistencyLevel;
import com.dbeaver.db.cassandra.ui.views.CasConnectionPage;
import com.dbeaver.ui.auth.aws.AuthModelAWSConfigurator;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.regions.Region;

public class AWSKeyspacesConnectionPage
extends CasConnectionPage {
    private final Image logoImage = this.createImage("icons/keyspaces_logo.png");
    private Combo regionCombo;

    public Image getImage() {
        return this.logoImage;
    }

    public void dispose() {
        super.dispose();
        UIUtils.dispose((Resource)this.logoImage);
    }

    protected void createSettingsPanel(ModifyListener textListener, Composite settingsGroup) {
        this.regionCombo = UIUtils.createLabelCombo((Composite)settingsGroup, (String)"AWS Region", (int)2052);
        this.regionCombo.setLayoutData((Object)new GridData(32));
        this.regionCombo.addModifyListener(textListener);
        for (String region : AuthModelAWSConfigurator.getPublicRegions()) {
            this.regionCombo.add(region);
        }
        this.regionCombo.setText(Region.US_EAST_1.id());
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        this.regionCombo.setLayoutData((Object)gd);
        this.keyspaceText = UIUtils.createLabelText((Composite)settingsGroup, (String)"Default keyspace", (String)"", (int)2048);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        this.keyspaceText.setLayoutData((Object)gd);
        this.keyspaceText.addModifyListener(textListener);
    }

    public boolean isComplete() {
        return super.isComplete() && !this.regionCombo.getText().isEmpty();
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        super.saveSettings(dataSource);
        if (this.regionCombo != null) {
            String region = this.regionCombo.getText().trim();
            dataSource.getConnectionConfiguration().setHostName(region);
        }
    }

    public void loadSettings() {
        super.loadSettings();
        this.regionCombo.setText(CommonUtils.notEmpty((String)this.site.getActiveDataSource().getConnectionConfiguration().getHostName()));
    }

    @NotNull
    protected ConsistencyLevel getDefaultConsistencyLevel() {
        return ConsistencyLevel.LOCAL_QUORUM;
    }
}

