/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsAsyncClient;
import software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsRequest;
import software.amazon.awssdk.services.rds.model.DescribeOptionGroupOptionsResponse;
import software.amazon.awssdk.services.rds.model.OptionGroupOption;

public class DescribeOptionGroupOptionsPublisher
implements SdkPublisher<DescribeOptionGroupOptionsResponse> {
    private final RdsAsyncClient client;
    private final DescribeOptionGroupOptionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeOptionGroupOptionsPublisher(RdsAsyncClient client, DescribeOptionGroupOptionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeOptionGroupOptionsPublisher(RdsAsyncClient client, DescribeOptionGroupOptionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeOptionGroupOptionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeOptionGroupOptionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<OptionGroupOption> optionGroupOptions() {
        Function<DescribeOptionGroupOptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.optionGroupOptions() != null) {
                return response.optionGroupOptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeOptionGroupOptionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeOptionGroupOptionsResponseFetcher
    implements AsyncPageFetcher<DescribeOptionGroupOptionsResponse> {
        private DescribeOptionGroupOptionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeOptionGroupOptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeOptionGroupOptionsResponse> nextPage(DescribeOptionGroupOptionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeOptionGroupOptionsPublisher.this.client.describeOptionGroupOptions(DescribeOptionGroupOptionsPublisher.this.firstRequest);
            }
            return DescribeOptionGroupOptionsPublisher.this.client.describeOptionGroupOptions((DescribeOptionGroupOptionsRequest)((Object)DescribeOptionGroupOptionsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

