/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyDbSnapshotRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, ModifyDbSnapshotRequest> {
    private static final SdkField<String> DB_SNAPSHOT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBSnapshotIdentifier").getter(ModifyDbSnapshotRequest.getter(ModifyDbSnapshotRequest::dbSnapshotIdentifier)).setter(ModifyDbSnapshotRequest.setter(Builder::dbSnapshotIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSnapshotIdentifier").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(ModifyDbSnapshotRequest.getter(ModifyDbSnapshotRequest::engineVersion)).setter(ModifyDbSnapshotRequest.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptionGroupName").getter(ModifyDbSnapshotRequest.getter(ModifyDbSnapshotRequest::optionGroupName)).setter(ModifyDbSnapshotRequest.setter(Builder::optionGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_SNAPSHOT_IDENTIFIER_FIELD, ENGINE_VERSION_FIELD, OPTION_GROUP_NAME_FIELD));
    private final String dbSnapshotIdentifier;
    private final String engineVersion;
    private final String optionGroupName;

    private ModifyDbSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.dbSnapshotIdentifier = builder.dbSnapshotIdentifier;
        this.engineVersion = builder.engineVersion;
        this.optionGroupName = builder.optionGroupName;
    }

    public final String dbSnapshotIdentifier() {
        return this.dbSnapshotIdentifier;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final String optionGroupName() {
        return this.optionGroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSnapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionGroupName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDbSnapshotRequest)) {
            return false;
        }
        ModifyDbSnapshotRequest other = (ModifyDbSnapshotRequest)((Object)obj);
        return Objects.equals(this.dbSnapshotIdentifier(), other.dbSnapshotIdentifier()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.optionGroupName(), other.optionGroupName());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyDbSnapshotRequest").add("DBSnapshotIdentifier", (Object)this.dbSnapshotIdentifier()).add("EngineVersion", (Object)this.engineVersion()).add("OptionGroupName", (Object)this.optionGroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBSnapshotIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbSnapshotIdentifier()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "OptionGroupName": {
                return Optional.ofNullable(clazz.cast(this.optionGroupName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyDbSnapshotRequest, T> g) {
        return obj -> g.apply((ModifyDbSnapshotRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String dbSnapshotIdentifier;
        private String engineVersion;
        private String optionGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDbSnapshotRequest model) {
            super(model);
            this.dbSnapshotIdentifier(model.dbSnapshotIdentifier);
            this.engineVersion(model.engineVersion);
            this.optionGroupName(model.optionGroupName);
        }

        public final String getDbSnapshotIdentifier() {
            return this.dbSnapshotIdentifier;
        }

        public final void setDbSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
        }

        @Override
        @Transient
        public final Builder dbSnapshotIdentifier(String dbSnapshotIdentifier) {
            this.dbSnapshotIdentifier = dbSnapshotIdentifier;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        @Transient
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getOptionGroupName() {
            return this.optionGroupName;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        @Override
        @Transient
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyDbSnapshotRequest build() {
            return new ModifyDbSnapshotRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyDbSnapshotRequest> {
        public Builder dbSnapshotIdentifier(String var1);

        public Builder engineVersion(String var1);

        public Builder optionGroupName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

