/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IAMAuthMode {
    DISABLED("DISABLED"),
    REQUIRED("REQUIRED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IAMAuthMode> VALUE_MAP;
    private final String value;

    private IAMAuthMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IAMAuthMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IAMAuthMode> knownValues() {
        EnumSet<IAMAuthMode> knownValues = EnumSet.allOf(IAMAuthMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IAMAuthMode.class, IAMAuthMode::toString);
    }
}

