/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import oracle.jdbc.internal.NetStat;
import oracle.net.nt.Clock;

class NetStatImpl
implements NetStat {
    private long bytesSent;
    private long bytesReceived;
    private long lastNetworkAccessTimeInMillis;
    private long lastNetworkAccessTimeForReadInMillis;

    NetStatImpl() {
    }

    @Override
    public long getTotalBytesSent() {
        return this.bytesSent;
    }

    @Override
    public long getTotalBytesReceived() {
        return this.bytesReceived;
    }

    @Override
    public void reset() {
        this.bytesReceived = 0L;
        this.bytesSent = 0L;
    }

    void incrementBytesSent(int n2) {
        this.bytesSent += (long)n2;
        this.lastNetworkAccessTimeInMillis = Clock.currentTimeMillis();
    }

    void incrementBytesReceived(int n2) {
        this.bytesReceived += (long)n2;
        this.lastNetworkAccessTimeForReadInMillis = this.lastNetworkAccessTimeInMillis = Clock.currentTimeMillis();
    }

    @Override
    public long getLastNetworkAccessTime() {
        return this.lastNetworkAccessTimeInMillis;
    }

    @Override
    public long getLastNetworkAccessTimeForRead() {
        return this.lastNetworkAccessTimeForReadInMillis;
    }
}

