/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.common;

import com.vertica.dsi.core.impl.DSIDriverSingleton;
import com.vertica.dsi.core.interfaces.IConnection;
import com.vertica.dsi.core.interfaces.IDriver;
import com.vertica.dsi.core.interfaces.IEnvironment;
import com.vertica.dsi.core.interfaces.IStatement;
import com.vertica.dsi.core.utilities.PropertyUtilities;
import com.vertica.dsi.core.utilities.Variant;
import com.vertica.dsi.dataengine.interfaces.IDataEngine;
import com.vertica.dsi.dataengine.utilities.MetadataSourceID;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.common.SConnection;
import com.vertica.jdbc.common.SWarningListener;
import com.vertica.jdbc.common.utilities.WrapperUtilities;
import com.vertica.support.ILogger;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.ExceptionType;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public abstract class SDatabaseMetaData
implements DatabaseMetaData {
    private static final String FUNCTION_LIST_SEPARATOR = ",";
    static final Map<Long, String> m_systemFunctionNameMap = new LinkedHashMap<Long, String>(){
        private static final long serialVersionUID = -1124807681731600000L;
        {
            this.put(0L, null);
            this.put(2L, "DATABASE");
            this.put(4L, "IFNULL");
            this.put(1L, "USER");
        }
    };
    static final Map<Long, String> m_numericFunctionNameMap = new LinkedHashMap<Long, String>(){
        private static final long serialVersionUID = -3392302998382835758L;
        {
            this.put(0L, null);
            this.put(1L, "ABS");
            this.put(2L, "ACOS");
            this.put(4L, "ASIN");
            this.put(8L, "ATAN");
            this.put(16L, "ATAN2");
            this.put(32L, "CEILING");
            this.put(64L, "COS");
            this.put(128L, "COT");
            this.put(262144L, "DEGREES");
            this.put(256L, "EXP");
            this.put(512L, "FLOOR");
            this.put(1024L, "LOG");
            this.put(524288L, "LOG10");
            this.put(2048L, "MOD");
            this.put(65536L, "PI");
            this.put(0x100000L, "POWER");
            this.put(0x200000L, "RADIANS");
            this.put(131072L, "RAND");
            this.put(0x400000L, "ROUND");
            this.put(4096L, "SIGN");
            this.put(8192L, "SIN");
            this.put(16384L, "SQRT");
            this.put(32768L, "TAN");
            this.put(0x800000L, "TRUNCATE");
        }
    };
    private static final int SQL_ALL_TYPES = 0;
    private static final int SQL_NO_NULLS = 0;
    private static final int SQL_NULLABLE = 1;
    private static final int SQL_BEST_ROWID = 1;
    private static final int SQL_ROWVER = 2;
    private static final int SQL_INDEX_UNIQUE = 0;
    private static final int SQL_INDEX_ALL = 1;
    private static final int SQL_QUICK = 0;
    private static final int SQL_ENSURE = 1;
    protected static final String RETURN_YES = "Y";
    protected static final String RETURN_NO = "N";
    private static final String VERSION_SEPARATOR = ".";
    private static final int JDBC_MAJOR_VERSION = 4;
    protected ArrayList<ResultSet> m_resultSets = new ArrayList();
    protected IDataEngine m_dataEngine = null;
    protected IStatement m_parentStatement = null;
    protected SConnection m_parentConnection = null;
    protected SWarningListener m_warningListener = null;
    protected ILogger m_logger = null;

    protected SDatabaseMetaData(SConnection conn, ILogger logger) throws SQLException {
        try {
            this.m_logger = logger;
            LogUtilities.logFunctionEntrance(this.m_logger, conn, logger);
            this.m_parentConnection = conn;
            this.m_parentStatement = conn.getConnection().createStatement();
            this.m_warningListener = new SWarningListener(conn.getDSIConnection().getMessageSource(), null);
            this.m_parentStatement.registerWarningListener(this.m_warningListener);
            this.m_dataEngine = this.m_parentStatement.createDataEngine();
        }
        catch (Exception e) {
            if (null != this.m_parentStatement) {
                try {
                    this.m_parentStatement.close();
                }
                catch (Exception e2) {
                    LogUtilities.logError(e2, this.m_logger);
                }
            }
            IWarningListener warningListener = null == this.m_warningListener ? this.m_parentConnection.getWarningListener() : this.m_warningListener;
            throw ExceptionConverter.getInstance().toSQLException(e, warningListener, this.m_logger);
        }
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant var = this.getConnectionPropertyVariant(1);
            return var.getString().equals(RETURN_YES);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant var = this.getConnectionPropertyVariant(2);
            return var.getString().equals(RETURN_YES);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int txnLevel = this.getConnectionPropertyInt(136);
            return 3 == txnLevel;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int txnLevel = this.getConnectionPropertyInt(136);
            return 4 == txnLevel;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, type);
            this.checkParentConnection();
            long support = this.getConnectionPropertyLong(1002);
            switch (type) {
                case 1003: {
                    return 0L != (1L & support);
                }
                case 1004: {
                    return 0L != (8L & support);
                }
                case 1005: {
                    return 0L != (0x40L & support);
                }
            }
            return false;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant var = this.getConnectionPropertyVariant(80);
            return var.getString().equals(RETURN_YES);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, catalog, schemaPattern, typeNamePattern, attributeNamePattern);
            this.checkParentConnection();
            return this.createNullMetaDataResult(MetadataSourceID.ATTRIBUTES);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, catalog, schema, table, scope, nullable);
            this.checkParentConnection();
            ArrayList<String> filters = new ArrayList<String>();
            filters.add(String.valueOf(1));
            filters.add(catalog);
            filters.add(schema);
            filters.add(table);
            switch (scope) {
                case 0: 
                case 1: 
                case 2: {
                    filters.add(String.valueOf(scope));
                    break;
                }
                default: {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.UNKNOWN_SCOPE, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, String.valueOf(scope));
                }
            }
            if (nullable) {
                filters.add(String.valueOf(1));
            } else {
                filters.add(String.valueOf(0));
            }
            return this.createMetaDataResult(MetadataSourceID.SPECIAL_COLUMNS, filters);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            ArrayList<String> filters = new ArrayList<String>();
            filters.add(null);
            filters.add(null);
            filters.add(null);
            filters.add(null);
            return this.createMetaDataResult(MetadataSourceID.CATALOG_ONLY, filters);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant var = this.getConnectionPropertyVariant(10);
            return var.getString();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant var = this.getConnectionPropertyVariant(11);
            return var.getString();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, catalog, schema, table, columnNamePattern);
            this.checkParentConnection();
            ArrayList<String> filters = new ArrayList<String>();
            filters.add(catalog);
            filters.add(schema);
            filters.add(table);
            filters.add(columnNamePattern);
            return this.createMetaDataResult(MetadataSourceID.COLUMN_PRIVILEGES, filters);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, catalog, schemaPattern, tableNamePattern, columnNamePattern);
            this.checkParentConnection();
            ArrayList<String> filters = new ArrayList<String>();
            filters.add(catalog);
            filters.add(schemaPattern);
            filters.add(tableNamePattern);
            filters.add(columnNamePattern);
            return this.createMetaDataResult(MetadataSourceID.COLUMNS, filters);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.m_parentConnection;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, primaryCatalog, primarySchema, primaryTable, foreignCatalog, foreignSchema, foreignTable);
            this.checkParentConnection();
            ArrayList<String> filters = new ArrayList<String>();
            filters.add(primaryCatalog);
            filters.add(primarySchema);
            filters.add(primaryTable);
            filters.add(foreignCatalog);
            filters.add(foreignSchema);
            filters.add(foreignTable);
            return this.createMetaDataResult(MetadataSourceID.FOREIGN_KEYS, filters);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant var = this.getConnectionPropertyVariant(42);
            if (null == var.getString()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_VERSION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, var.getString());
            }
            StringTokenizer strTokenizer = new StringTokenizer(var.getString(), VERSION_SEPARATOR);
            String majorVersionString = strTokenizer.nextToken();
            return Integer.parseInt(majorVersionString);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant var = this.getConnectionPropertyVariant(42);
            if (null == var.getString()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_VERSION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, var.getString());
            }
            StringTokenizer strTokenizer = new StringTokenizer(var.getString(), VERSION_SEPARATOR);
            strTokenizer.nextToken();
            String minorVersionString = strTokenizer.nextToken();
            return Integer.parseInt(minorVersionString);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant var = this.getConnectionPropertyVariant(41);
            return var.getString();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant var = this.getConnectionPropertyVariant(42);
            return var.getString();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long transLevel = this.getConnectionPropertyLong(45);
            if (0L == transLevel) {
                return 0;
            }
            if (2L == transLevel) {
                return 2;
            }
            if (1L == transLevel) {
                return 1;
            }
            if (4L == transLevel) {
                return 4;
            }
            if (8L == transLevel) {
                return 8;
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.UNKNOWN_ISOLATION, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(transLevel));
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getDriverMajorVersion() {
        int majorVersion = 1;
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant var = this.getConnectionPropertyVariant(170);
            if (null == var.getString()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_VERSION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, var.getString());
            }
            StringTokenizer strTokenizer = new StringTokenizer(var.getString(), VERSION_SEPARATOR);
            String majorVersionString = strTokenizer.nextToken();
            majorVersion = Integer.parseInt(majorVersionString);
        }
        catch (Exception e) {
            ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
        return majorVersion;
    }

    @Override
    public int getDriverMinorVersion() {
        int minorVersion = 0;
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant var = this.getConnectionPropertyVariant(170);
            if (null == var.getString()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_VERSION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, var.getString());
            }
            StringTokenizer strTokenizer = new StringTokenizer(var.getString(), VERSION_SEPARATOR);
            strTokenizer.nextToken();
            String minorVersionString = strTokenizer.nextToken();
            minorVersion = Integer.parseInt(minorVersionString);
        }
        catch (Exception e) {
            ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
        return minorVersion;
    }

    @Override
    public String getDriverName() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant var = this.getConnectionPropertyVariant(169);
            return var.getString();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getDriverVersion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant var = this.getConnectionPropertyVariant(170);
            return var.getString();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, catalog, schema, table);
            this.checkParentConnection();
            ArrayList<String> filters = new ArrayList<String>();
            filters.add(catalog);
            filters.add(schema);
            filters.add(table);
            filters.add(null);
            filters.add(null);
            filters.add(null);
            return this.createMetaDataResult(MetadataSourceID.FOREIGN_KEYS, filters);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant var = this.getConnectionPropertyVariant(102);
            return var.getString();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant var = this.getConnectionPropertyVariant(58);
            return var.getString();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, catalog, schema, table);
            this.checkParentConnection();
            ArrayList<String> filters = new ArrayList<String>();
            filters.add(null);
            filters.add(null);
            filters.add(null);
            filters.add(catalog);
            filters.add(schema);
            filters.add(table);
            return this.createMetaDataResult(MetadataSourceID.FOREIGN_KEYS, filters);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, catalog, schema, table, unique, approximate);
            this.checkParentConnection();
            ArrayList<String> filters = new ArrayList<String>();
            filters.add(0, catalog);
            filters.add(1, schema);
            filters.add(2, table);
            if (unique) {
                filters.add(3, String.valueOf(0));
            } else {
                filters.add(3, String.valueOf(1));
            }
            if (approximate) {
                filters.add(4, String.valueOf(0));
            } else {
                filters.add(4, String.valueOf(1));
            }
            return this.createMetaDataResult(MetadataSourceID.STATISTICS, filters);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.getConnectionPropertyInt(65);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.getConnectionPropertyInt(66);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.getConnectionPropertyInt(67);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.getConnectionPropertyInt(68);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.getConnectionPropertyInt(69);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.getConnectionPropertyInt(70);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.getConnectionPropertyInt(71);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.getConnectionPropertyInt(72);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.getConnectionPropertyInt(73);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxConnections() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant var = this.getEnvironmentPropertyVariant(2);
            return var.getInt();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.getConnectionPropertyInt(75);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.getConnectionPropertyInt(77);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.getConnectionPropertyInt(78);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.getConnectionPropertyInt(79);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.getConnectionPropertyInt(81);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.getConnectionPropertyInt(82);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxStatements() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.getConnectionPropertyInt(74);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.getConnectionPropertyInt(83);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.getConnectionPropertyInt(84);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.getConnectionPropertyInt(85);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long numFuncBitmask = this.getConnectionPropertyLong(90);
            return this.createListFromMap(m_numericFunctionNameMap, numFuncBitmask);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, catalog, schema, table);
            this.checkParentConnection();
            ArrayList<String> filters = new ArrayList<String>();
            filters.add(catalog);
            filters.add(schema);
            filters.add(table);
            return this.createMetaDataResult(MetadataSourceID.PRIMARY_KEYS, filters);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, catalog, schemaPattern, procedureNamePattern, columnNamePattern);
            this.checkParentConnection();
            ArrayList<String> filters = new ArrayList<String>();
            filters.add(catalog);
            filters.add(schemaPattern);
            filters.add(procedureNamePattern);
            filters.add(columnNamePattern);
            return this.createMetaDataResult(MetadataSourceID.PROCEDURE_COLUMNS, filters);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, catalog, schemaPattern, procedureNamePattern);
            this.checkParentConnection();
            ArrayList<String> filters = new ArrayList<String>();
            filters.add(catalog);
            filters.add(schemaPattern);
            filters.add(procedureNamePattern);
            return this.createMetaDataResult(MetadataSourceID.PROCEDURES, filters);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant var = this.getConnectionPropertyVariant(96);
            return var.getString();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long holdability = this.getConnectionPropertyLong(37);
            if (1L == holdability || 0L == holdability) {
                return 2;
            }
            if (2L == holdability) {
                return 1;
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.UNKNOWN_HOLDABILITY, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(holdability));
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            ArrayList<String> filters = new ArrayList<String>();
            long prop = this.m_parentStatement.getParentConnection().getProperty(1011).getLong();
            if (prop == 1L) {
                filters.add(this.m_parentConnection.getCatalog());
            } else {
                filters.add(null);
            }
            filters.add(null);
            filters.add(null);
            filters.add(null);
            if (this.supportsCatalogs()) {
                return this.createMetaDataResult(MetadataSourceID.CATALOG_SCHEMA_ONLY, filters);
            }
            return this.createMetaDataResult(MetadataSourceID.SCHEMA_ONLY, filters);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, catalog, schemaPattern);
            this.checkParentConnection();
            ArrayList<String> filters = new ArrayList<String>();
            filters.add(catalog);
            filters.add(schemaPattern);
            filters.add(null);
            filters.add(null);
            if (this.supportsCatalogs()) {
                return this.createMetaDataResult(MetadataSourceID.CATALOG_SCHEMA_ONLY, filters);
            }
            return this.createMetaDataResult(MetadataSourceID.SCHEMA_ONLY, filters);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant var = this.getConnectionPropertyVariant(99);
            return var.getString();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant var = this.getConnectionPropertyVariant(151);
            return var.getString();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant var = this.getConnectionPropertyVariant(62);
            return var.getString();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getSQLStateType() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant var = this.getDriverPropertyVariant(13);
            long stateType = var.getLong();
            if (2L == stateType) {
                return 2;
            }
            if (1L == stateType) {
                return 1;
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.UNKNOWN_SQLSTATE_TYPE, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, String.valueOf(stateType));
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public abstract String getStringFunctions() throws SQLException;

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, catalog, schemaPattern, tableNamePattern);
            this.checkParentConnection();
            return this.createNullMetaDataResult(MetadataSourceID.SUPERTABLES);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, catalog, schemaPattern, typeNamePattern);
            this.checkParentConnection();
            return this.createNullMetaDataResult(MetadataSourceID.SUPERTYPES);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long sysFuncBitmask = this.getConnectionPropertyLong(131);
            return this.createListFromMap(m_systemFunctionNameMap, sysFuncBitmask);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, catalog, schemaPattern, tableNamePattern);
            this.checkParentConnection();
            ArrayList<String> filters = new ArrayList<String>();
            filters.add(catalog);
            filters.add(schemaPattern);
            filters.add(tableNamePattern);
            return this.createMetaDataResult(MetadataSourceID.TABLE_PRIVILEGES, filters);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, catalog, schemaPattern, tableNamePattern, types);
            this.checkParentConnection();
            ArrayList<String> filters = new ArrayList<String>();
            filters.add(catalog);
            filters.add(schemaPattern);
            filters.add(tableNamePattern);
            if (null != types) {
                if (types.length > 0) {
                    StringBuffer typeBuffer = new StringBuffer();
                    for (int i = 0; i < types.length; ++i) {
                        typeBuffer.append(FUNCTION_LIST_SEPARATOR);
                        typeBuffer.append(types[i]);
                    }
                    filters.add(typeBuffer.substring(1));
                } else {
                    filters.add("");
                }
            } else {
                filters.add(null);
            }
            return this.createMetaDataResult(MetadataSourceID.TABLES, filters);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            ArrayList<String> filters = new ArrayList<String>();
            filters.add(null);
            filters.add(null);
            filters.add(null);
            filters.add(null);
            return this.createMetaDataResult(MetadataSourceID.TABLETYPE_ONLY, filters);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public abstract String getTimeDateFunctions() throws SQLException;

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            ArrayList<String> filters = new ArrayList<String>();
            filters.add(String.valueOf(0));
            return this.createMetaDataResult(MetadataSourceID.TYPE_INFO, filters);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String tableNamePattern, int[] types) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, catalog, schemaPattern, tableNamePattern, types);
            this.checkParentConnection();
            return this.createNullMetaDataResult(MetadataSourceID.UDT);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getURL() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.m_parentConnection.getURL();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getUserName() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant var = this.getConnectionPropertyVariant(139);
            return var.getString();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schemaNamePattern, String tableNamePattern) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, catalog, schemaNamePattern, tableNamePattern);
            this.checkParentConnection();
            ArrayList<String> filters = new ArrayList<String>();
            filters.add(String.valueOf(2));
            filters.add(catalog);
            filters.add(schemaNamePattern);
            filters.add(tableNamePattern);
            filters.add(String.valueOf(0));
            filters.add(String.valueOf(1));
            return this.createUnorderedMetaDataResult(MetadataSourceID.SPECIAL_COLUMNS, filters);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, type);
            this.checkParentConnection();
            long support = this.getConnectionPropertyLong(1002);
            switch (type) {
                case 1003: {
                    return 0L != (2L & support);
                }
                case 1004: {
                    return 0L != (0x10L & support);
                }
                case 1005: {
                    return 0L != (0x80L & support);
                }
            }
            return false;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int catalogPosition = this.getConnectionPropertyInt(8);
            return 1L == (long)catalogPosition;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant var = this.getConnectionPropertyVariant(40);
            return var.getString().equals(RETURN_YES);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return false;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int concatNullBehaviour = this.getConnectionPropertyInt(15);
            return 0L == (long)concatNullBehaviour;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int nullCollation = this.getConnectionPropertyInt(89);
            return 4L == (long)nullCollation;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int nullCollation = this.getConnectionPropertyInt(89);
            return 2L == (long)nullCollation;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int nullCollation = this.getConnectionPropertyInt(89);
            return 0L == (long)nullCollation;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int nullCollation = this.getConnectionPropertyInt(89);
            return 1L == (long)nullCollation;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, type);
            this.checkParentConnection();
            return false;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, type);
            this.checkParentConnection();
            return false;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, type);
            this.checkParentConnection();
            return false;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, type);
            this.checkParentConnection();
            return false;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, type);
            this.checkParentConnection();
            return false;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, type);
            this.checkParentConnection();
            return false;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int identifierCase = this.getConnectionPropertyInt(57);
            return 2 == identifierCase;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int quotedIdentifierCase = this.getConnectionPropertyInt(98);
            return 2 == quotedIdentifierCase;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int identifierCase = this.getConnectionPropertyInt(57);
            return 4 == identifierCase;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int quotedIdentifierCase = this.getConnectionPropertyInt(98);
            return 4 == quotedIdentifierCase;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int identifierCase = this.getConnectionPropertyInt(57);
            return 1 == identifierCase;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int quotedIdentifierCase = this.getConnectionPropertyInt(98);
            return 1 == quotedIdentifierCase;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long atBitmask = this.getConnectionPropertyLong(6);
            return (0x40L & atBitmask) != 0L;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long atBitmask = this.getConnectionPropertyLong(6);
            return (0x200L & atBitmask) != 0L;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int sqlConformanceLevel = this.getConnectionPropertyInt(103);
            return 1L <= (long)sqlConformanceLevel;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int sqlConformanceLevel = this.getConnectionPropertyInt(103);
            return 8L <= (long)sqlConformanceLevel;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int sqlConformanceLevel = this.getConnectionPropertyInt(103);
            return 4L <= (long)sqlConformanceLevel;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant var = this.getConnectionPropertyVariant(1012);
            return 1 == var.getInt();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long catUsageBitmask = this.getConnectionPropertyLong(12);
            return (1L & catUsageBitmask) != 0L;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long catUsageBitmask = this.getConnectionPropertyLong(12);
            return (8L & catUsageBitmask) != 0L;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long catUsageBitmask = this.getConnectionPropertyLong(12);
            return (0x10L & catUsageBitmask) != 0L;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long catUsageBitmask = this.getConnectionPropertyLong(12);
            return (2L & catUsageBitmask) != 0L;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long catUsageBitmask = this.getConnectionPropertyLong(12);
            return (4L & catUsageBitmask) != 0L;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant var = this.getConnectionPropertyVariant(14);
            return var.getString().equals(RETURN_YES);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long convertBitmask = this.getConnectionPropertyLong(27);
            return (1L & convertBitmask) != 0L;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, fromType, toType);
            this.checkParentConnection();
            int fromConversionKey = 0;
            long toConversionType = 0L;
            switch (fromType) {
                case -5: {
                    fromConversionKey = 106;
                    break;
                }
                case -2: {
                    fromConversionKey = 107;
                    break;
                }
                case -7: 
                case 16: {
                    fromConversionKey = 108;
                    break;
                }
                case 1: {
                    fromConversionKey = 109;
                    break;
                }
                case 91: {
                    fromConversionKey = 111;
                    break;
                }
                case 3: {
                    fromConversionKey = 112;
                    break;
                }
                case 8: {
                    fromConversionKey = 113;
                    break;
                }
                case 6: {
                    fromConversionKey = 114;
                    break;
                }
                case 4: {
                    fromConversionKey = 115;
                    break;
                }
                case -4: {
                    fromConversionKey = 118;
                    break;
                }
                case -1: {
                    fromConversionKey = 119;
                    break;
                }
                case 2: {
                    fromConversionKey = 120;
                    break;
                }
                case 7: {
                    fromConversionKey = 121;
                    break;
                }
                case 5: {
                    fromConversionKey = 122;
                    break;
                }
                case 92: {
                    fromConversionKey = 123;
                    break;
                }
                case 93: {
                    fromConversionKey = 124;
                    break;
                }
                case -6: {
                    fromConversionKey = 125;
                    break;
                }
                case -3: {
                    fromConversionKey = 126;
                    break;
                }
                case 12: {
                    fromConversionKey = 127;
                    break;
                }
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: {
                    fromConversionKey = 117;
                    break;
                }
                case 101: 
                case 102: 
                case 107: {
                    fromConversionKey = 116;
                    break;
                }
                case -8: {
                    fromConversionKey = 128;
                    break;
                }
                case -10: {
                    fromConversionKey = 129;
                    break;
                }
                case -9: {
                    fromConversionKey = 130;
                    break;
                }
                case -11: {
                    fromConversionKey = 110;
                    break;
                }
                default: {
                    return false;
                }
            }
            switch (toType) {
                case -5: {
                    toConversionType = 16384L;
                    break;
                }
                case -2: {
                    toConversionType = 1024L;
                    break;
                }
                case -7: {
                    toConversionType = 4096L;
                    break;
                }
                case 1: {
                    toConversionType = 1L;
                    break;
                }
                case 91: {
                    toConversionType = 32768L;
                    break;
                }
                case 3: {
                    toConversionType = 4L;
                    break;
                }
                case 8: {
                    toConversionType = 128L;
                    break;
                }
                case 6: {
                    toConversionType = 32L;
                    break;
                }
                case 4: {
                    toConversionType = 8L;
                    break;
                }
                case -4: {
                    toConversionType = 262144L;
                    break;
                }
                case -1: {
                    toConversionType = 512L;
                    break;
                }
                case 2: {
                    toConversionType = 2L;
                    break;
                }
                case 7: {
                    toConversionType = 64L;
                    break;
                }
                case 5: {
                    toConversionType = 16L;
                    break;
                }
                case 92: {
                    toConversionType = 65536L;
                    break;
                }
                case 93: {
                    toConversionType = 131072L;
                    break;
                }
                case -6: {
                    toConversionType = 8192L;
                    break;
                }
                case -3: {
                    toConversionType = 2048L;
                    break;
                }
                case 12: {
                    toConversionType = 256L;
                    break;
                }
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: {
                    toConversionType = 0x100000L;
                    break;
                }
                case 101: 
                case 102: 
                case 107: {
                    toConversionType = 524288L;
                    break;
                }
                case -8: {
                    toConversionType = 0x200000L;
                    break;
                }
                case -10: {
                    toConversionType = 0x400000L;
                    break;
                }
                case -9: {
                    toConversionType = 0x800000L;
                    break;
                }
                case -11: {
                    toConversionType = 0x1000000L;
                    break;
                }
                default: {
                    return false;
                }
            }
            long fromConversionBitmask = this.getConnectionPropertyLong(fromConversionKey);
            return (toConversionType & fromConversionBitmask) != 0L;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int odbcSQLConformance = this.getConnectionPropertyInt(91);
            return 1 <= odbcSQLConformance;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long subBitmask = this.getConnectionPropertyLong(105);
            return (0x10L & subBitmask) != 0L;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int txnCapable = this.getConnectionPropertyInt(136);
            return 2 == txnCapable;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int txnCapable = this.getConnectionPropertyInt(136);
            return 1 == txnCapable;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int correlationNameSupport = this.getConnectionPropertyInt(28);
            return 1L == (long)correlationNameSupport;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant var = this.getConnectionPropertyVariant(55);
            return var.getString().equals(RETURN_YES);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int odbcSQLConformance = this.getConnectionPropertyInt(91);
            return 2 <= odbcSQLConformance;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long ojBitmask = this.getConnectionPropertyLong(92);
            boolean supportsFullJoins = (4L & ojBitmask) != 0L;
            boolean supportsOuterJoins = (8L & ojBitmask) != 0L;
            return supportsFullJoins && supportsOuterJoins;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant var = this.getConnectionPropertyVariant(1010);
            return var.getString().equals(RETURN_YES);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int groupBySupport = this.getConnectionPropertyInt(56);
            return 0L != (long)groupBySupport;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int groupBySupport = this.getConnectionPropertyInt(56);
            return 2L == (long)groupBySupport;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int groupBySupport = this.getConnectionPropertyInt(56);
            return 3L == (long)groupBySupport;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant var = this.getConnectionPropertyVariant(61);
            return var.getString().equals(RETURN_YES);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant var = this.getConnectionPropertyVariant(63);
            return var.getString().equals(RETURN_YES);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant var = this.getConnectionPropertyVariant(94);
            return var.getString().equals(RETURN_YES);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int odbcSQLConformance = this.getConnectionPropertyInt(91);
            return 0 <= odbcSQLConformance;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int identifierCaseSensitivity = this.getConnectionPropertyInt(57);
            return 3 == identifierCaseSensitivity;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int quotedIdentifierCaseSensitivity = this.getConnectionPropertyInt(98);
            return 3 == quotedIdentifierCaseSensitivity;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return false;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant var = this.getConnectionPropertyVariant(86);
            return var.getString().equals(RETURN_YES);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant var = this.getConnectionPropertyVariant(87);
            return var.getString().equals(RETURN_YES);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant var = this.getDriverPropertyVariant(1003);
            return 1 == var.getInt();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int nullableColumnsSupport = this.getConnectionPropertyInt(88);
            return 1L == (long)nullableColumnsSupport;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int cursorCommitBehavior = this.getConnectionPropertyInt(37);
            return 2L == (long)cursorCommitBehavior;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int cursorRollbackBehavior = this.getConnectionPropertyInt(38);
            return 2L == (long)cursorRollbackBehavior;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int cursorCommitBehavior = this.getConnectionPropertyInt(37);
            return 0L != (long)cursorCommitBehavior;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int cursorRollbackBehavior = this.getConnectionPropertyInt(38);
            return 0L != (long)cursorRollbackBehavior;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant var = this.getConnectionPropertyVariant(93);
            return var.getString().equals(RETURN_YES);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return this.supportsLimitedOuterJoins();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return false;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return false;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, type, concurrency);
            this.checkParentConnection();
            if (1003 != type) {
                return false;
            }
            if (1007 == concurrency) {
                return true;
            }
            long supportsUrs = this.getConnectionPropertyLong(1001);
            return 0L != supportsUrs;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, holdability);
            this.checkParentConnection();
            int cursorCommitBehavior = this.getConnectionPropertyInt(37);
            boolean supportsHoldability = false;
            switch (holdability) {
                case 1: {
                    supportsHoldability = 2L == (long)cursorCommitBehavior;
                    break;
                }
                case 2: {
                    supportsHoldability = 1L == (long)cursorCommitBehavior || 0L == (long)cursorCommitBehavior;
                }
            }
            return supportsHoldability;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, type);
            this.checkParentConnection();
            return 1003 == type;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return PropertyUtilities.hasSavepointSupport(this.m_parentConnection.getConnection());
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long schemaBitmask = this.getConnectionPropertyLong(100);
            return (1L & schemaBitmask) != 0L;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long schemaBitmask = this.getConnectionPropertyLong(100);
            return (8L & schemaBitmask) != 0L;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long schemaBitmask = this.getConnectionPropertyLong(100);
            return (0x10L & schemaBitmask) != 0L;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long schemaBitmask = this.getConnectionPropertyLong(100);
            return (2L & schemaBitmask) != 0L;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long schemaBitmask = this.getConnectionPropertyLong(100);
            return (4L & schemaBitmask) != 0L;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant var = this.getDriverPropertyVariant(1004);
            return 1 == var.getInt();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return false;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return PropertyUtilities.hasStoredProcedureSupport(this.m_parentConnection.getConnection());
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long subBitmask = this.getConnectionPropertyLong(105);
            return (1L & subBitmask) != 0L;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long subBitmask = this.getConnectionPropertyLong(105);
            return (2L & subBitmask) != 0L;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long subBitmask = this.getConnectionPropertyLong(105);
            return (4L & subBitmask) != 0L;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long subBitmask = this.getConnectionPropertyLong(105);
            return (8L & subBitmask) != 0L;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int correlationNameSupport = this.getConnectionPropertyInt(28);
            return 0L != (long)correlationNameSupport;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, level);
            this.checkParentConnection();
            long txnSupport = this.getConnectionPropertyLong(137);
            switch (level) {
                case 0: {
                    return 0L == txnSupport;
                }
                case 2: {
                    return (2L & txnSupport) != 0L;
                }
                case 1: {
                    return (1L & txnSupport) != 0L;
                }
                case 4: {
                    return (4L & txnSupport) != 0L;
                }
                case 8: {
                    return (8L & txnSupport) != 0L;
                }
            }
            return false;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int txnCapable = this.getConnectionPropertyInt(136);
            return 0 != txnCapable;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long unionBitmask = this.getConnectionPropertyLong(138);
            return (1L & unionBitmask) != 0L;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            long unionBitmask = this.getConnectionPropertyLong(138);
            return (2L & unionBitmask) != 0L;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, type);
            this.checkParentConnection();
            long support = this.getConnectionPropertyLong(1002);
            switch (type) {
                case 1003: {
                    return 0L != (4L & support);
                }
                case 1004: {
                    return 0L != (0x20L & support);
                }
                case 1005: {
                    return 0L != (0x100L & support);
                }
            }
            return false;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant var = this.getDriverPropertyVariant(6);
            int fileUsageLevel = var.getInt();
            return 1 == fileUsageLevel;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            Variant var = this.getDriverPropertyVariant(6);
            int fileUsageLevel = var.getInt();
            return 0 != fileUsageLevel;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            int cursorCommitBehavior = this.getConnectionPropertyInt(37);
            return 1L == (long)cursorCommitBehavior || 0L == (long)cursorCommitBehavior;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, catalog, schemaPattern, functionNamePattern, columnNamePattern);
            this.checkParentConnection();
            ArrayList<String> filters = new ArrayList<String>();
            filters.add(catalog);
            filters.add(schemaPattern);
            filters.add(functionNamePattern);
            filters.add(columnNamePattern);
            return this.createMetaDataResult(MetadataSourceID.FUNCTION_COLUMNS_JDBC4, filters);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, catalog, schemaPattern, functionNamePattern);
            this.checkParentConnection();
            ArrayList<String> filters = new ArrayList<String>();
            filters.add(catalog);
            filters.add(schemaPattern);
            filters.add(functionNamePattern);
            return this.createMetaDataResult(MetadataSourceID.FUNCTIONS_JDBC4, filters);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return 4;
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return WrapperUtilities.isWrapperFor(iface, this);
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkParentConnection();
            return PropertyUtilities.hasStoredFunctionsCallsSupport(this.m_parentConnection.getConnection());
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return WrapperUtilities.unwrap(iface, this);
    }

    public static String getReturnNo() {
        return RETURN_NO;
    }

    protected synchronized void closeMetaData() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (null != this.m_dataEngine) {
            this.m_dataEngine.close();
            try {
                this.m_parentStatement.close();
            }
            catch (ErrorException e) {
                LogUtilities.logError(e, this.m_logger);
            }
            this.m_dataEngine = null;
            this.m_parentStatement = null;
        }
        this.m_parentConnection = null;
        if (null != this.m_resultSets) {
            for (int i = this.m_resultSets.size() - 1; i >= 0; --i) {
                try {
                    this.m_resultSets.get(i).close();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.m_resultSets.clear();
        }
    }

    protected void finalize() throws Throwable {
        this.closeMetaData();
    }

    protected IConnection getDSIConnection() {
        return this.m_parentConnection.getConnection();
    }

    protected IStatement getDSIStatement() {
        return this.m_parentStatement;
    }

    protected synchronized void removeResultSet(ResultSet resultSet) {
        this.m_resultSets.remove(resultSet);
    }

    protected synchronized void checkParentConnection() throws SQLException {
        if (null == this.m_parentConnection) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DBMETA_CLOSED, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT_CONNECTION, new Object[0]);
        }
        if (this.m_parentConnection.isClosed()) {
            this.closeMetaData();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.PARENT_CLOSED, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT_CONNECTION, new Object[0]);
        }
    }

    protected String createListFromMap(Map<Long, String> map, long bitmask) throws SQLException {
        StringBuffer functionList = new StringBuffer();
        for (long bitValue : map.keySet()) {
            String functionName = map.get(bitValue & bitmask);
            if (null == functionName) continue;
            functionList.append(FUNCTION_LIST_SEPARATOR).append(functionName);
        }
        if (functionList.length() > 0) {
            return functionList.toString().substring(1);
        }
        return "";
    }

    protected abstract ResultSet createMetaDataResult(MetadataSourceID var1, List<String> var2) throws SQLException;

    protected abstract ResultSet createNullMetaDataResult(MetadataSourceID var1) throws SQLException;

    protected abstract ResultSet createUnorderedMetaDataResult(MetadataSourceID var1, List<String> var2) throws SQLException;

    protected int getConnectionPropertyInt(int key) throws SQLException {
        Variant var = this.getConnectionPropertyVariant(key);
        try {
            return var.getInt();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_parentStatement.getWarningListener());
        }
    }

    protected long getConnectionPropertyLong(int key) throws SQLException {
        Variant var = this.getConnectionPropertyVariant(key);
        try {
            return var.getLong();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_parentStatement.getWarningListener());
        }
    }

    private Variant getConnectionPropertyVariant(int key) throws SQLException {
        try {
            IConnection iConn = this.m_parentConnection.getConnection();
            return iConn.getProperty(key);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_parentStatement.getWarningListener());
        }
    }

    private Variant getDriverPropertyVariant(int key) throws SQLException {
        try {
            IDriver driver = DSIDriverSingleton.getInstance();
            return driver.getProperty(key);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_parentStatement.getWarningListener());
        }
    }

    private Variant getEnvironmentPropertyVariant(int key) throws SQLException {
        try {
            IEnvironment environ = this.m_parentConnection.getConnection().getParentEnvironment();
            return environ.getProperty(key);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_parentStatement.getWarningListener());
        }
    }

    private boolean supportsCatalogs() throws SQLException {
        if (RETURN_NO.equals(this.getConnectionPropertyVariant(9).getString())) {
            return false;
        }
        if ("".equals(this.getConnectionPropertyVariant(11).getString())) {
            return false;
        }
        return 0L != this.getConnectionPropertyLong(12);
    }
}

