/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.dataengine.utilities;

import com.vertica.dsi.dataengine.impl.DSIEmptyResultSet;
import com.vertica.dsi.dataengine.interfaces.IErrorResult;
import com.vertica.dsi.dataengine.interfaces.IResultSet;
import com.vertica.dsi.dataengine.interfaces.IRowCountResult;
import com.vertica.dsi.dataengine.utilities.ExecutionResultType;
import com.vertica.support.exceptions.ErrorException;

public final class ExecutionResult {
    private ExecutionResultType m_type;
    private Object m_result;
    private IResultSet m_generatedResult = new DSIEmptyResultSet();

    public ExecutionResult(IErrorResult errorResult, boolean isResultSet) {
        this.m_type = isResultSet ? ExecutionResultType.ERROR_RESULT_SET : ExecutionResultType.ERROR_ROW_COUNT;
        this.m_result = errorResult;
    }

    public ExecutionResult(IResultSet resultSet) {
        this.m_type = ExecutionResultType.RESULT_SET;
        this.m_result = resultSet;
    }

    public ExecutionResult(IRowCountResult rowCountResult) {
        this.m_type = ExecutionResultType.ROW_COUNT;
        this.m_result = rowCountResult;
    }

    public Object getResult() {
        return this.m_result;
    }

    public ExecutionResultType getType() {
        return this.m_type;
    }

    public long getRowCount() throws ErrorException {
        switch (this.m_type) {
            case RESULT_SET: 
            case ERROR_RESULT_SET: {
                return ((IResultSet)this.m_result).getRowCount();
            }
            case ROW_COUNT: 
            case ERROR_ROW_COUNT: {
                return ((IRowCountResult)this.m_result).getRowCount();
            }
        }
        return -1L;
    }

    public IResultSet getGeneratedResult() {
        return this.m_generatedResult;
    }

    public void setGeneratedResult(IResultSet generatedResult) {
        this.m_generatedResult = generatedResult;
    }
}

