/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.dataengine.filters;

import com.vertica.dsi.core.impl.DSIDriver;
import com.vertica.dsi.core.interfaces.IEnvironment;
import com.vertica.dsi.core.utilities.Variant;
import com.vertica.dsi.dataengine.filters.IFilter;
import com.vertica.dsi.dataengine.filters.IdentifierFilter;
import com.vertica.dsi.dataengine.filters.SmallIntFilter;
import com.vertica.dsi.dataengine.filters.StringFilter;
import com.vertica.dsi.dataengine.filters.StringListFilter;
import com.vertica.dsi.dataengine.filters.StringPatternFilter;
import com.vertica.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.vertica.dsi.dataengine.utilities.MetadataSourceID;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.dsi.exceptions.NumericOverflowException;
import com.vertica.dsi.utilities.DSIMessageKey;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.ExceptionType;
import java.util.List;
import java.util.Map;

public class DSIMetadataFilterFactory {
    private final boolean m_caseInsensitiveSearch;
    private boolean m_performFiltering;

    public DSIMetadataFilterFactory(boolean performFiltering, boolean makeCaseInsensitive) {
        this.m_performFiltering = performFiltering;
        this.m_caseInsensitiveSearch = makeCaseInsensitive;
    }

    public DSIMetadataFilterFactory(boolean performFiltering) {
        this(performFiltering, false);
    }

    public void createFilters(MetadataSourceID metadataSourceId, List<String> filterValues, String escapeChar, String identifierQuoteChar, boolean filterAsIdentifier, IEnvironment in_environment, List<IFilter> out_filters, Map<MetadataSourceColumnTag, String> out_restrictions) throws ErrorException {
        int envKeyAPI = this.getAPIType(in_environment);
        int apiVersionKey = 1 == envKeyAPI ? 7 : 3;
        int apiVersion = this.getEnvIntAttr(in_environment, apiVersionKey);
        this.doCreateFilters(metadataSourceId, filterValues, escapeChar, identifierQuoteChar, filterAsIdentifier, envKeyAPI, apiVersion, out_filters, out_restrictions);
    }

    @Deprecated
    public void createFilters(MetadataSourceID metadataSourceId, List<String> filterValues, String escapeChar, String identifierQuoteChar, boolean filterAsIdentifier, List<IFilter> out_filters, Map<MetadataSourceColumnTag, String> out_restrictions) throws ErrorException {
        int APIType = 1;
        int APIVersion = 4;
        this.doCreateFilters(metadataSourceId, filterValues, escapeChar, identifierQuoteChar, filterAsIdentifier, APIType, APIVersion, out_filters, out_restrictions);
    }

    private void doCreateFilters(MetadataSourceID metadataSourceId, List<String> filterValues, String escapeChar, String identifierQuoteChar, boolean filterAsIdentifier, int APIType, int APIVersion, List<IFilter> out_filters, Map<MetadataSourceColumnTag, String> out_restrictions) throws ErrorException {
        switch (metadataSourceId) {
            case CATALOG_SCHEMA_ONLY: {
                this.createCatalogSchemaOnlyFilters(filterValues, escapeChar, identifierQuoteChar, filterAsIdentifier, out_filters, out_restrictions);
                break;
            }
            case COLUMN_PRIVILEGES: {
                this.createColumnPrivilegesFilters(filterValues, escapeChar, identifierQuoteChar, filterAsIdentifier, out_filters, out_restrictions);
                break;
            }
            case COLUMNS: 
            case PSEUDO_COLUMNS_JDBC41: {
                this.createColumnsFilters(filterValues, escapeChar, identifierQuoteChar, filterAsIdentifier, out_filters, out_restrictions);
                break;
            }
            case FOREIGN_KEYS: {
                this.createForeignKeysFilters(filterValues, escapeChar, identifierQuoteChar, filterAsIdentifier, out_filters, out_restrictions);
                break;
            }
            case PRIMARY_KEYS: {
                this.createPrimaryKeysFilters(filterValues, escapeChar, identifierQuoteChar, filterAsIdentifier, out_filters, out_restrictions);
                break;
            }
            case PROCEDURE_COLUMNS: 
            case FUNCTION_COLUMNS_JDBC4: {
                this.createProcedureColumnsFilters(filterValues, escapeChar, identifierQuoteChar, filterAsIdentifier, out_filters, out_restrictions);
                break;
            }
            case PROCEDURES: 
            case FUNCTIONS_JDBC4: {
                this.createProceduresFilters(filterValues, escapeChar, identifierQuoteChar, filterAsIdentifier, out_filters, out_restrictions);
                break;
            }
            case SPECIAL_COLUMNS: {
                this.createSpecialColumnsFilters(filterValues, escapeChar, identifierQuoteChar, filterAsIdentifier, out_filters, out_restrictions);
                break;
            }
            case STATISTICS: {
                this.createStatisticsFilters(filterValues, escapeChar, identifierQuoteChar, filterAsIdentifier, out_filters, out_restrictions);
                break;
            }
            case TABLE_PRIVILEGES: {
                this.createTablePrivilegesFilters(filterValues, escapeChar, identifierQuoteChar, filterAsIdentifier, out_filters, out_restrictions);
                break;
            }
            case CATALOG_ONLY: 
            case SCHEMA_ONLY: 
            case TABLETYPE_ONLY: {
                break;
            }
            case TABLES: {
                this.createTablesFilters(filterValues, escapeChar, identifierQuoteChar, filterAsIdentifier, out_filters, APIType, APIVersion, out_restrictions);
                break;
            }
            case TYPE_INFO: {
                this.createTypeInfoFilters(filterValues, out_filters, out_restrictions);
                break;
            }
            default: {
                throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.INVALID_METADATA_ID.name(), metadataSourceId.toString(), ExceptionType.DEFAULT);
            }
        }
    }

    private int getAPIType(IEnvironment in_environment) throws ErrorException {
        return this.getEnvIntAttr(in_environment, 4);
    }

    private int getEnvIntAttr(IEnvironment in_environment, int in_envKey) throws ErrorException {
        try {
            Variant envValue = in_environment.getProperty(in_envKey);
            int envValueInt = envValue.getInt();
            return envValueInt;
        }
        catch (NumericOverflowException e) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_NUMERIC_OVERFLOW.name());
        }
        catch (IncorrectTypeException e) {
            throw DSIDriver.s_DSIMessages.createGeneralException(DSIMessageKey.PROP_VALTYPE_MISMATCH.name());
        }
    }

    private void addRestriction(String value, MetadataSourceColumnTag columnTag, Map<MetadataSourceColumnTag, String> out_restrictions) {
        if (null != value) {
            out_restrictions.put(columnTag, value);
        }
    }

    private void addRestriction(StringPatternFilter filter, String value, MetadataSourceColumnTag columnTag, Map<MetadataSourceColumnTag, String> out_restrictions) {
        if (!(null == value || this.m_performFiltering && filter.hasPatternFilter())) {
            out_restrictions.put(columnTag, value);
        }
    }

    private void createCatalogSchemaOnlyFilters(List<String> filterValues, String escapeChar, String identifierQuoteChar, boolean filterAsIdentifier, List<IFilter> out_filters, Map<MetadataSourceColumnTag, String> out_restrictions) {
        assert (2 <= filterValues.size());
        if (filterAsIdentifier) {
            this.createIdentifierFilter(MetadataSourceColumnTag.CATALOG_NAME, filterValues.get(0), identifierQuoteChar, out_filters, out_restrictions);
            this.createIdentifierFilter(MetadataSourceColumnTag.SCHEMA_NAME, filterValues.get(1), identifierQuoteChar, out_filters, out_restrictions);
        } else {
            this.createStringFilter(MetadataSourceColumnTag.CATALOG_NAME, filterValues.get(0), out_filters, out_restrictions);
            this.createPatternFilter(MetadataSourceColumnTag.SCHEMA_NAME, filterValues.get(1), escapeChar, out_filters, out_restrictions);
        }
    }

    private void createColumnPrivilegesFilters(List<String> filterValues, String escapeChar, String identifierQuoteChar, boolean filterAsIdentifier, List<IFilter> out_filters, Map<MetadataSourceColumnTag, String> out_restrictions) {
        assert (4 == filterValues.size());
        if (filterAsIdentifier) {
            this.createIdentifierFilter(MetadataSourceColumnTag.CATALOG_NAME, filterValues.get(0), identifierQuoteChar, out_filters, out_restrictions);
            this.createIdentifierFilter(MetadataSourceColumnTag.SCHEMA_NAME, filterValues.get(1), identifierQuoteChar, out_filters, out_restrictions);
            this.createIdentifierFilter(MetadataSourceColumnTag.TABLE_NAME, filterValues.get(2), identifierQuoteChar, out_filters, out_restrictions);
            this.createIdentifierFilter(MetadataSourceColumnTag.COLUMN_NAME, filterValues.get(3), identifierQuoteChar, out_filters, out_restrictions);
        } else {
            this.createStringFilter(MetadataSourceColumnTag.CATALOG_NAME, filterValues.get(0), out_filters, out_restrictions);
            this.createStringFilter(MetadataSourceColumnTag.SCHEMA_NAME, filterValues.get(1), out_filters, out_restrictions);
            this.createStringFilter(MetadataSourceColumnTag.TABLE_NAME, filterValues.get(2), out_filters, out_restrictions);
            this.createPatternFilter(MetadataSourceColumnTag.COLUMN_NAME, filterValues.get(3), escapeChar, out_filters, out_restrictions);
        }
    }

    private void createColumnsFilters(List<String> filterValues, String escapeChar, String identifierQuoteChar, boolean filterAsIdentifier, List<IFilter> out_filters, Map<MetadataSourceColumnTag, String> out_restrictions) {
        assert (4 == filterValues.size());
        if (filterAsIdentifier) {
            this.createIdentifierFilter(MetadataSourceColumnTag.CATALOG_NAME, filterValues.get(0), identifierQuoteChar, out_filters, out_restrictions);
            this.createIdentifierFilter(MetadataSourceColumnTag.SCHEMA_NAME, filterValues.get(1), identifierQuoteChar, out_filters, out_restrictions);
            this.createIdentifierFilter(MetadataSourceColumnTag.TABLE_NAME, filterValues.get(2), identifierQuoteChar, out_filters, out_restrictions);
            this.createIdentifierFilter(MetadataSourceColumnTag.COLUMN_NAME, filterValues.get(3), identifierQuoteChar, out_filters, out_restrictions);
        } else {
            this.createStringFilter(MetadataSourceColumnTag.CATALOG_NAME, filterValues.get(0), out_filters, out_restrictions);
            this.createPatternFilter(MetadataSourceColumnTag.SCHEMA_NAME, filterValues.get(1), escapeChar, out_filters, out_restrictions);
            this.createPatternFilter(MetadataSourceColumnTag.TABLE_NAME, filterValues.get(2), escapeChar, out_filters, out_restrictions);
            this.createPatternFilter(MetadataSourceColumnTag.COLUMN_NAME, filterValues.get(3), escapeChar, out_filters, out_restrictions);
        }
    }

    private void createForeignKeysFilters(List<String> filterValues, String escapeChar, String identifierQuoteChar, boolean filterAsIdentifier, List<IFilter> out_filters, Map<MetadataSourceColumnTag, String> out_restrictions) {
        assert (6 == filterValues.size());
        if (filterAsIdentifier) {
            this.createIdentifierFilter(MetadataSourceColumnTag.PRIMARY_KEY_CATALOG_NAME, filterValues.get(0), identifierQuoteChar, out_filters, out_restrictions);
            this.createIdentifierFilter(MetadataSourceColumnTag.PRIMARY_KEY_SCHEMA_NAME, filterValues.get(1), identifierQuoteChar, out_filters, out_restrictions);
            this.createIdentifierFilter(MetadataSourceColumnTag.PRIMARY_KEY_TABLE_NAME, filterValues.get(2), identifierQuoteChar, out_filters, out_restrictions);
            this.createIdentifierFilter(MetadataSourceColumnTag.FOREIGN_KEY_CATALOG_NAME, filterValues.get(3), identifierQuoteChar, out_filters, out_restrictions);
            this.createIdentifierFilter(MetadataSourceColumnTag.FOREIGN_KEY_SCHEMA_NAME, filterValues.get(4), identifierQuoteChar, out_filters, out_restrictions);
            this.createIdentifierFilter(MetadataSourceColumnTag.FOREIGN_KEY_TABLE_NAME, filterValues.get(5), identifierQuoteChar, out_filters, out_restrictions);
        } else {
            this.createStringFilter(MetadataSourceColumnTag.PRIMARY_KEY_CATALOG_NAME, filterValues.get(0), out_filters, out_restrictions);
            this.createStringFilter(MetadataSourceColumnTag.PRIMARY_KEY_SCHEMA_NAME, filterValues.get(1), out_filters, out_restrictions);
            this.createStringFilter(MetadataSourceColumnTag.PRIMARY_KEY_TABLE_NAME, filterValues.get(2), out_filters, out_restrictions);
            this.createStringFilter(MetadataSourceColumnTag.FOREIGN_KEY_CATALOG_NAME, filterValues.get(3), out_filters, out_restrictions);
            this.createStringFilter(MetadataSourceColumnTag.FOREIGN_KEY_SCHEMA_NAME, filterValues.get(4), out_filters, out_restrictions);
            this.createStringFilter(MetadataSourceColumnTag.FOREIGN_KEY_TABLE_NAME, filterValues.get(5), out_filters, out_restrictions);
        }
    }

    private void createIdentifierFilter(MetadataSourceColumnTag column, String value, String identifierQuoteChar, List<IFilter> out_filters, Map<MetadataSourceColumnTag, String> out_restrictions) {
        out_filters.add(new IdentifierFilter(column, value, identifierQuoteChar));
        this.addRestriction(value, column, out_restrictions);
    }

    private void createPatternFilter(MetadataSourceColumnTag column, String value, String escapeChar, List<IFilter> out_filters, Map<MetadataSourceColumnTag, String> out_restrictions) {
        StringPatternFilter filter = new StringPatternFilter(column, value, escapeChar, this.m_caseInsensitiveSearch);
        out_filters.add(filter);
        this.addRestriction(filter, value, column, out_restrictions);
    }

    private void createPrimaryKeysFilters(List<String> filterValues, String escapeChar, String identifierQuoteChar, boolean filterAsIdentifier, List<IFilter> out_filters, Map<MetadataSourceColumnTag, String> out_restrictions) {
        assert (3 == filterValues.size());
        if (filterAsIdentifier) {
            this.createIdentifierFilter(MetadataSourceColumnTag.PRIMARY_KEY_CATALOG_NAME, filterValues.get(0), identifierQuoteChar, out_filters, out_restrictions);
            this.createIdentifierFilter(MetadataSourceColumnTag.PRIMARY_KEY_SCHEMA_NAME, filterValues.get(1), identifierQuoteChar, out_filters, out_restrictions);
            this.createIdentifierFilter(MetadataSourceColumnTag.PRIMARY_KEY_TABLE_NAME, filterValues.get(2), identifierQuoteChar, out_filters, out_restrictions);
        } else {
            this.createStringFilter(MetadataSourceColumnTag.PRIMARY_KEY_CATALOG_NAME, filterValues.get(0), out_filters, out_restrictions);
            this.createStringFilter(MetadataSourceColumnTag.PRIMARY_KEY_SCHEMA_NAME, filterValues.get(1), out_filters, out_restrictions);
            this.createStringFilter(MetadataSourceColumnTag.PRIMARY_KEY_TABLE_NAME, filterValues.get(2), out_filters, out_restrictions);
        }
    }

    private void createProcedureColumnsFilters(List<String> filterValues, String escapeChar, String identifierQuoteChar, boolean filterAsIdentifier, List<IFilter> out_filters, Map<MetadataSourceColumnTag, String> out_restrictions) {
        assert (4 == filterValues.size());
        if (filterAsIdentifier) {
            this.createIdentifierFilter(MetadataSourceColumnTag.CATALOG_NAME, filterValues.get(0), identifierQuoteChar, out_filters, out_restrictions);
            this.createIdentifierFilter(MetadataSourceColumnTag.SCHEMA_NAME, filterValues.get(1), identifierQuoteChar, out_filters, out_restrictions);
            this.createIdentifierFilter(MetadataSourceColumnTag.PROCEDURE_NAME, filterValues.get(2), identifierQuoteChar, out_filters, out_restrictions);
            this.createIdentifierFilter(MetadataSourceColumnTag.COLUMN_NAME, filterValues.get(3), identifierQuoteChar, out_filters, out_restrictions);
        } else {
            this.createStringFilter(MetadataSourceColumnTag.CATALOG_NAME, filterValues.get(0), out_filters, out_restrictions);
            this.createPatternFilter(MetadataSourceColumnTag.SCHEMA_NAME, filterValues.get(1), escapeChar, out_filters, out_restrictions);
            this.createPatternFilter(MetadataSourceColumnTag.PROCEDURE_NAME, filterValues.get(2), escapeChar, out_filters, out_restrictions);
            this.createPatternFilter(MetadataSourceColumnTag.COLUMN_NAME, filterValues.get(3), escapeChar, out_filters, out_restrictions);
        }
    }

    private void createProceduresFilters(List<String> filterValues, String escapeChar, String identifierQuoteChar, boolean filterAsIdentifier, List<IFilter> out_filters, Map<MetadataSourceColumnTag, String> out_restrictions) {
        assert (3 == filterValues.size());
        if (filterAsIdentifier) {
            this.createIdentifierFilter(MetadataSourceColumnTag.CATALOG_NAME, filterValues.get(0), identifierQuoteChar, out_filters, out_restrictions);
            this.createIdentifierFilter(MetadataSourceColumnTag.SCHEMA_NAME, filterValues.get(1), identifierQuoteChar, out_filters, out_restrictions);
            this.createIdentifierFilter(MetadataSourceColumnTag.PROCEDURE_NAME, filterValues.get(2), identifierQuoteChar, out_filters, out_restrictions);
        } else {
            this.createStringFilter(MetadataSourceColumnTag.CATALOG_NAME, filterValues.get(0), out_filters, out_restrictions);
            this.createPatternFilter(MetadataSourceColumnTag.SCHEMA_NAME, filterValues.get(1), escapeChar, out_filters, out_restrictions);
            this.createPatternFilter(MetadataSourceColumnTag.PROCEDURE_NAME, filterValues.get(2), escapeChar, out_filters, out_restrictions);
        }
    }

    private void createSpecialColumnsFilters(List<String> filterValues, String escapeChar, String identifierQuoteChar, boolean filterAsIdentifier, List<IFilter> out_filters, Map<MetadataSourceColumnTag, String> out_restrictions) {
        assert (4 <= filterValues.size());
        if (filterAsIdentifier) {
            this.createIdentifierFilter(MetadataSourceColumnTag.CATALOG_NAME, filterValues.get(1), identifierQuoteChar, out_filters, out_restrictions);
            this.createIdentifierFilter(MetadataSourceColumnTag.SCHEMA_NAME, filterValues.get(2), identifierQuoteChar, out_filters, out_restrictions);
            this.createIdentifierFilter(MetadataSourceColumnTag.TABLE_NAME, filterValues.get(3), identifierQuoteChar, out_filters, out_restrictions);
        } else {
            this.createStringFilter(MetadataSourceColumnTag.CATALOG_NAME, filterValues.get(1), out_filters, out_restrictions);
            this.createStringFilter(MetadataSourceColumnTag.SCHEMA_NAME, filterValues.get(2), out_filters, out_restrictions);
            this.createStringFilter(MetadataSourceColumnTag.TABLE_NAME, filterValues.get(3), out_filters, out_restrictions);
        }
        out_filters.add(new SmallIntFilter(MetadataSourceColumnTag.SCOPE, filterValues.get(4)));
        this.addRestriction(filterValues.get(4), MetadataSourceColumnTag.SCOPE, out_restrictions);
        this.addRestriction(filterValues.get(0), MetadataSourceColumnTag.IDENTIFIER_TYPE_TAG, out_restrictions);
        this.addRestriction(filterValues.get(5), MetadataSourceColumnTag.NULLABLE_TAG, out_restrictions);
    }

    private void createStatisticsFilters(List<String> filterValues, String escapeChar, String identifierQuoteChar, boolean filterAsIdentifier, List<IFilter> out_filters, Map<MetadataSourceColumnTag, String> out_restrictions) {
        assert (3 <= filterValues.size());
        if (filterAsIdentifier) {
            this.createIdentifierFilter(MetadataSourceColumnTag.CATALOG_NAME, filterValues.get(0), identifierQuoteChar, out_filters, out_restrictions);
            this.createIdentifierFilter(MetadataSourceColumnTag.SCHEMA_NAME, filterValues.get(1), identifierQuoteChar, out_filters, out_restrictions);
            this.createIdentifierFilter(MetadataSourceColumnTag.TABLE_NAME, filterValues.get(2), identifierQuoteChar, out_filters, out_restrictions);
        } else {
            this.createStringFilter(MetadataSourceColumnTag.CATALOG_NAME, filterValues.get(0), out_filters, out_restrictions);
            this.createStringFilter(MetadataSourceColumnTag.SCHEMA_NAME, filterValues.get(1), out_filters, out_restrictions);
            this.createStringFilter(MetadataSourceColumnTag.TABLE_NAME, filterValues.get(2), out_filters, out_restrictions);
        }
        this.addRestriction(filterValues.get(3), MetadataSourceColumnTag.UNIQUE_TAG, out_restrictions);
        this.addRestriction(filterValues.get(4), MetadataSourceColumnTag.RESERVED_TAG, out_restrictions);
    }

    private void createStringFilter(MetadataSourceColumnTag column, String value, List<IFilter> out_filters, Map<MetadataSourceColumnTag, String> out_restrictions) {
        out_filters.add(new StringFilter(column, value, this.m_caseInsensitiveSearch));
        this.addRestriction(value, column, out_restrictions);
    }

    private void createTablePrivilegesFilters(List<String> filterValues, String escapeChar, String identifierQuoteChar, boolean filterAsIdentifier, List<IFilter> out_filters, Map<MetadataSourceColumnTag, String> out_restrictions) {
        assert (3 == filterValues.size());
        if (filterAsIdentifier) {
            this.createIdentifierFilter(MetadataSourceColumnTag.CATALOG_NAME, filterValues.get(0), identifierQuoteChar, out_filters, out_restrictions);
            this.createIdentifierFilter(MetadataSourceColumnTag.SCHEMA_NAME, filterValues.get(1), identifierQuoteChar, out_filters, out_restrictions);
            this.createIdentifierFilter(MetadataSourceColumnTag.TABLE_NAME, filterValues.get(2), identifierQuoteChar, out_filters, out_restrictions);
        } else {
            this.createStringFilter(MetadataSourceColumnTag.CATALOG_NAME, filterValues.get(0), out_filters, out_restrictions);
            this.createPatternFilter(MetadataSourceColumnTag.SCHEMA_NAME, filterValues.get(1), escapeChar, out_filters, out_restrictions);
            this.createPatternFilter(MetadataSourceColumnTag.TABLE_NAME, filterValues.get(2), escapeChar, out_filters, out_restrictions);
        }
    }

    private void createTablesFilters(List<String> filterValues, String escapeChar, String identifierQuoteChar, boolean filterAsIdentifier, List<IFilter> out_filters, int in_apitype, int in_apiversion, Map<MetadataSourceColumnTag, String> out_restrictions) throws ErrorException {
        assert (4 == filterValues.size());
        if (filterAsIdentifier) {
            this.createIdentifierFilter(MetadataSourceColumnTag.CATALOG_NAME, filterValues.get(0), identifierQuoteChar, out_filters, out_restrictions);
            this.createIdentifierFilter(MetadataSourceColumnTag.SCHEMA_NAME, filterValues.get(1), identifierQuoteChar, out_filters, out_restrictions);
            this.createIdentifierFilter(MetadataSourceColumnTag.TABLE_NAME, filterValues.get(2), identifierQuoteChar, out_filters, out_restrictions);
        } else {
            if (in_apitype == 1 || in_apitype == 0 && in_apiversion == 2) {
                this.createStringFilter(MetadataSourceColumnTag.CATALOG_NAME, filterValues.get(0), out_filters, out_restrictions);
            } else {
                this.createPatternFilter(MetadataSourceColumnTag.CATALOG_NAME, filterValues.get(0), escapeChar, out_filters, out_restrictions);
            }
            this.createPatternFilter(MetadataSourceColumnTag.SCHEMA_NAME, filterValues.get(1), escapeChar, out_filters, out_restrictions);
            this.createPatternFilter(MetadataSourceColumnTag.TABLE_NAME, filterValues.get(2), escapeChar, out_filters, out_restrictions);
        }
        if (this.m_performFiltering) {
            out_filters.add(new StringListFilter(MetadataSourceColumnTag.TABLE_TYPE, filterValues.get(3)));
        } else {
            this.createStringFilter(MetadataSourceColumnTag.TABLE_TYPE, filterValues.get(3), out_filters, out_restrictions);
        }
    }

    private void createTypeInfoFilters(List<String> filterValues, List<IFilter> out_filters, Map<MetadataSourceColumnTag, String> out_restrictions) {
        assert (1 == filterValues.size());
        String value = filterValues.get(0);
        if (null == value) {
            return;
        }
        if (!value.equals("0")) {
            out_filters.add(new SmallIntFilter(MetadataSourceColumnTag.DATA_TYPE, value));
            this.addRestriction(filterValues.get(0), MetadataSourceColumnTag.DATA_TYPE, out_restrictions);
        }
    }
}

