/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.util.gef3;

import org.eclipse.draw2dl.ConnectionLayer;
import org.eclipse.draw2dl.FreeformLayer;
import org.eclipse.draw2dl.FreeformLayeredPane;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.LayeredPane;
import org.eclipse.draw2dl.ScalableFigure;
import org.eclipse.draw2dl.ScalableFreeformLayeredPane;
import org.eclipse.draw2dl.Viewport;
import org.eclipse.draw2dl.geometry.Point;
import org.eclipse.gef3.DragTracker;
import org.eclipse.gef3.EditPart;
import org.eclipse.gef3.Request;
import org.eclipse.gef3.commands.Command;
import org.eclipse.gef3.commands.CommandStack;
import org.eclipse.gef3.editparts.ZoomManager;
import org.eclipse.gef3.requests.LocationRequest;
import org.eclipse.gef3.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IDoubleClickContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.internal.command.GenericFeatureCommandWithContext;
import org.eclipse.graphiti.internal.command.ICommand;
import org.eclipse.graphiti.internal.features.context.impl.base.DoubleClickContext;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.internal.command.GefCommandWrapper;
import org.eclipse.graphiti.ui.internal.editor.GFMarqueeDragTracker;
import org.eclipse.graphiti.ui.internal.fixed.FixedScalableFreeformRootEditPart;
import org.eclipse.graphiti.ui.internal.util.gef3.ZoomManagerWithAnimation;
import org.eclipse.graphiti.ui.platform.IConfigurationProvider;
import org.eclipse.graphiti.util.ILocationInfo;

public class ScalableRootEditPartAnimated
extends FixedScalableFreeformRootEditPart {
    private ZoomManagerWithAnimation zoomManagerWithAnimation;
    private IConfigurationProvider configurationProvider;
    private static boolean connectionLayerOnTop = true;

    public ScalableRootEditPartAnimated(ScrollingGraphicalViewer viewer, IConfigurationProvider configurationProvider) {
        this.zoomManagerWithAnimation = new ZoomManagerWithAnimation((ScalableFigure)((ScalableFreeformLayeredPane)this.getScaledLayers()), (Viewport)this.getFigure(), viewer);
        this.configurationProvider = configurationProvider;
    }

    protected void createLayers(LayeredPane layeredPane) {
        super.createLayers(layeredPane);
        layeredPane.remove(this.getLayer("Handle Layer"));
        layeredPane.add((IFigure)new FreeformLayer(){

            public void validate() {
                this.setValid(false);
                super.validate();
            }
        }, (Object)"Handle Layer");
    }

    public ZoomManager getZoomManager() {
        return this.zoomManagerWithAnimation;
    }

    protected LayeredPane createPrintableLayers() {
        if (connectionLayerOnTop) {
            return super.createPrintableLayers();
        }
        FreeformLayeredPane layeredPane = new FreeformLayeredPane();
        layeredPane.add((IFigure)new ConnectionLayer(), (Object)"Connection Layer");
        layeredPane.add((IFigure)new FreeformLayer(), (Object)"Primary Layer");
        return layeredPane;
    }

    public DragTracker getDragTracker(Request req) {
        return new GFMarqueeDragTracker((EditPart)this);
    }

    public void performRequest(Request request) {
        DiagramBehavior behavior = this.configurationProvider.getDiagramBehavior();
        Point point = behavior.calculateRealMouseLocation(behavior.getMouseLocation());
        Diagram shape = this.configurationProvider.getDiagram();
        ILocationInfo locationInfo = Graphiti.getLayoutService().getLocationInfo((Shape)shape, point.x, point.y);
        if (request.getType().equals("open") && locationInfo != null) {
            IToolBehaviorProvider currentToolBehaviorProvider;
            ICustomFeature doubleClickFeature;
            DoubleClickContext dcc = new DoubleClickContext((PictogramElement)shape, (PictogramElement)locationInfo.getShape(), locationInfo.getGraphicsAlgorithm());
            if (request instanceof LocationRequest) {
                Point location = ((LocationRequest)request).getLocation();
                location = behavior.calculateRealMouseLocation(location);
                dcc.setLocation(location.x, location.y);
            }
            if ((doubleClickFeature = (currentToolBehaviorProvider = this.configurationProvider.getDiagramTypeProvider().getCurrentToolBehaviorProvider()).getDoubleClickFeature((IDoubleClickContext)dcc)) != null && doubleClickFeature.canExecute((IContext)dcc)) {
                GenericFeatureCommandWithContext commandWithContext = new GenericFeatureCommandWithContext((IFeature)doubleClickFeature, (IContext)dcc);
                CommandStack commandStack = behavior.getEditDomain().getCommandStack();
                commandStack.execute((Command)new GefCommandWrapper((ICommand)commandWithContext, behavior.getEditingDomain()));
            }
        }
        super.performRequest(request);
    }
}

