/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.util.draw2dl;

import org.eclipse.draw2dl.ChopboxAnchor;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.geometry.Point;
import org.eclipse.draw2dl.geometry.Rectangle;
import org.eclipse.draw2dl.geometry.Translatable;
import org.eclipse.graphiti.mm.pictograms.AdvancedAnchor;

public class ChopboxAnchorFixed
extends ChopboxAnchor {
    private AdvancedAnchor advancedAnchor = null;

    public ChopboxAnchorFixed(IFigure figure, AdvancedAnchor advancedAnchor) {
        super(figure);
        this.advancedAnchor = advancedAnchor;
    }

    public Point getLocation(Point reference) {
        if (this.getAdvancedAnchor() != null && this.getAdvancedAnchor().isUseAnchorLocationAsConnectionEndpoint()) {
            Rectangle box = this.getBox();
            Rectangle r = Rectangle.SINGLETON;
            r.setBounds(box);
            this.getOwner().translateToAbsolute((Translatable)r);
            Point point = new Point(r.x(), r.y());
            return point;
        }
        Rectangle r = Rectangle.SINGLETON;
        r.setBounds(this.getBox());
        r.translate(-1, -1);
        r.resize(1, 1);
        this.getOwner().translateToAbsolute((Translatable)r);
        float centerX = (float)r.x + 0.5f * (float)r.width;
        float centerY = (float)r.y + 0.5f * (float)r.height;
        float dx = (float)reference.x - centerX;
        float dy = (float)reference.y - centerY;
        float max = Math.max(Math.abs(dx) / (float)r.width, Math.abs(dy) / (float)r.height);
        if (max <= 0.001f) {
            return new Point((int)centerX, r.y);
        }
        float scale = 0.5f / max;
        return new Point(Math.round(centerX += (dx *= scale)), Math.round(centerY += (dy *= scale)));
    }

    protected AdvancedAnchor getAdvancedAnchor() {
        return this.advancedAnchor;
    }
}

