/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.micro;

import com.ibm.as400.micro.JdbcMeService;
import com.ibm.as400.micro.MicroDataInputStream;
import com.ibm.as400.micro.MicroDataOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

class ResultSetHandler {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    JdbcMeService service_;
    MicroDataInputStream in_;
    MicroDataOutputStream out_;

    public ResultSetHandler(JdbcMeService jdbcMeService, MicroDataInputStream microDataInputStream, MicroDataOutputStream microDataOutputStream) {
        this.service_ = jdbcMeService;
        this.in_ = microDataInputStream;
        this.out_ = microDataOutputStream;
    }

    public void process(ResultSet resultSet, int n) throws IOException {
        switch (n) {
            case 4737: {
                this.close(resultSet);
                break;
            }
            case 4738: {
                this.deleteRow(resultSet);
                break;
            }
            case 4739: {
                this.insertRow(resultSet);
                break;
            }
            case 4740: {
                this.next(resultSet);
                break;
            }
            case 4741: {
                this.previous(resultSet);
                break;
            }
            case 4742: {
                this.updateRow(resultSet);
                break;
            }
            case 4743: {
                this.absolute(resultSet);
                break;
            }
            case 4744: {
                this.afterLast(resultSet);
                break;
            }
            case 4745: {
                this.beforeFirst(resultSet);
                break;
            }
            case 4752: {
                this.first(resultSet);
                break;
            }
            case 4753: {
                this.isAfterLast(resultSet);
                break;
            }
            case 4754: {
                this.isBeforeFirst(resultSet);
                break;
            }
            case 4755: {
                this.isFirst(resultSet);
                break;
            }
            case 4756: {
                this.isLast(resultSet);
                break;
            }
            case 4757: {
                this.last(resultSet);
                break;
            }
            case 4758: {
                this.relative(resultSet);
                break;
            }
            default: {
                System.out.println("Error - ResultSet Function ID not recognized - function code: " + n);
            }
        }
    }

    public void close(ResultSet resultSet) throws IOException {
        try {
            resultSet.close();
        }
        catch (SQLException sQLException) {
            System.out.println("Exception caught trying to close ResultSet object " + resultSet);
            sQLException.printStackTrace();
        }
        try {
            this.service_.removeResultSet(resultSet);
        }
        catch (SQLException sQLException) {
            System.out.println("Exception caught trying to remove ResultSet object from tracking");
            sQLException.printStackTrace();
        }
    }

    public void deleteRow(ResultSet resultSet) throws IOException {
        try {
            resultSet.deleteRow();
            this.out_.writeInt(1);
            this.out_.flush();
        }
        catch (SQLException sQLException) {
            this.service_.handleException(sQLException);
        }
    }

    public void insertRow(ResultSet resultSet) throws IOException {
        ResultSetMetaData resultSetMetaData = null;
        try {
            resultSet.moveToInsertRow();
            resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            for (int i = 0; i < n; ++i) {
                if (resultSetMetaData.getColumnType(i + 1) == 4) {
                    resultSet.updateInt(i + 1, this.in_.readInt());
                    continue;
                }
                resultSet.updateString(i + 1, this.in_.readUTF());
            }
            resultSet.insertRow();
            this.out_.writeInt(1);
            this.out_.flush();
        }
        catch (SQLException sQLException) {
            this.service_.handleException(sQLException);
        }
    }

    public void next(ResultSet resultSet) throws IOException {
        try {
            if (resultSet.next()) {
                this.out_.writeInt(1);
                this.writeRow(resultSet);
            } else {
                this.out_.writeInt(0);
            }
            this.out_.flush();
        }
        catch (SQLException sQLException) {
            this.service_.handleException(sQLException);
        }
    }

    public void previous(ResultSet resultSet) throws IOException {
        try {
            if (resultSet.previous()) {
                this.out_.writeInt(1);
                this.writeRow(resultSet);
            } else {
                this.out_.writeInt(0);
            }
            this.out_.flush();
        }
        catch (SQLException sQLException) {
            this.service_.handleException(sQLException);
        }
    }

    public void first(ResultSet resultSet) throws IOException {
        try {
            if (resultSet.first()) {
                this.out_.writeInt(1);
                this.writeRow(resultSet);
            } else {
                this.out_.writeInt(0);
            }
            this.out_.flush();
        }
        catch (SQLException sQLException) {
            this.service_.handleException(sQLException);
        }
    }

    public void last(ResultSet resultSet) throws IOException {
        try {
            if (resultSet.last()) {
                this.out_.writeInt(1);
                this.writeRow(resultSet);
            } else {
                this.out_.writeInt(0);
            }
            this.out_.flush();
        }
        catch (SQLException sQLException) {
            this.service_.handleException(sQLException);
        }
    }

    public void relative(ResultSet resultSet) throws IOException {
        try {
            int n = this.in_.readInt();
            if (resultSet.relative(n)) {
                this.out_.writeInt(1);
                this.writeRow(resultSet);
            } else {
                this.out_.writeInt(0);
            }
            this.out_.flush();
        }
        catch (SQLException sQLException) {
            this.service_.handleException(sQLException);
        }
    }

    public void absolute(ResultSet resultSet) throws IOException {
        try {
            int n = this.in_.readInt();
            if (resultSet.absolute(n)) {
                this.out_.writeInt(1);
                this.writeRow(resultSet);
            } else {
                this.out_.writeInt(0);
            }
            this.out_.flush();
        }
        catch (SQLException sQLException) {
            this.service_.handleException(sQLException);
        }
    }

    public void beforeFirst(ResultSet resultSet) throws IOException {
        try {
            resultSet.beforeFirst();
            this.out_.writeInt(1);
            this.out_.flush();
        }
        catch (SQLException sQLException) {
            this.service_.handleException(sQLException);
        }
    }

    public void afterLast(ResultSet resultSet) throws IOException {
        try {
            resultSet.afterLast();
            this.out_.writeInt(1);
            this.out_.flush();
        }
        catch (SQLException sQLException) {
            this.service_.handleException(sQLException);
        }
    }

    public void isAfterLast(ResultSet resultSet) throws IOException {
        try {
            if (resultSet.isAfterLast()) {
                this.out_.writeInt(1);
            } else {
                this.out_.writeInt(0);
            }
            this.out_.flush();
        }
        catch (SQLException sQLException) {
            this.service_.handleException(sQLException);
        }
    }

    public void isBeforeFirst(ResultSet resultSet) throws IOException {
        try {
            if (resultSet.isBeforeFirst()) {
                this.out_.writeInt(1);
            } else {
                this.out_.writeInt(0);
            }
            this.out_.flush();
        }
        catch (SQLException sQLException) {
            this.service_.handleException(sQLException);
        }
    }

    public void isFirst(ResultSet resultSet) throws IOException {
        try {
            if (resultSet.isFirst()) {
                this.out_.writeInt(1);
            } else {
                this.out_.writeInt(0);
            }
            this.out_.flush();
        }
        catch (SQLException sQLException) {
            this.service_.handleException(sQLException);
        }
    }

    public void isLast(ResultSet resultSet) throws IOException {
        try {
            if (resultSet.isLast()) {
                this.out_.writeInt(1);
            } else {
                this.out_.writeInt(0);
            }
            this.out_.flush();
        }
        catch (SQLException sQLException) {
            this.service_.handleException(sQLException);
        }
    }

    public void updateRow(ResultSet resultSet) throws IOException {
        ResultSetMetaData resultSetMetaData = null;
        try {
            resultSet.moveToCurrentRow();
            resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            for (int i = 0; i < n; ++i) {
                if (resultSetMetaData.getColumnType(i + 1) == 4) {
                    resultSet.updateInt(i + 1, this.in_.readInt());
                    continue;
                }
                resultSet.updateString(i + 1, this.in_.readUTF());
            }
            resultSet.updateRow();
            this.out_.writeInt(1);
            this.out_.flush();
        }
        catch (SQLException sQLException) {
            this.service_.handleException(sQLException);
        }
    }

    protected void writeRow(ResultSet resultSet) throws IOException {
        ResultSetMetaData resultSetMetaData = null;
        try {
            resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            switch (this.service_.getDataFlowType()) {
                case 2: {
                    for (int i = 0; i < n; ++i) {
                        if (resultSetMetaData.getColumnType(i + 1) == 4) {
                            this.out_.writeInt(resultSet.getInt(i + 1));
                            continue;
                        }
                        this.out_.writeUTF(resultSet.getString(i + 1));
                    }
                    break;
                }
                case 3: {
                    System.out.println("DATA_FLOW_STRINGS_ONLY: This isn't implemented yet.");
                    break;
                }
                case 1: {
                    System.out.println("DATA_FLOW_ALL: This isn't implemented yet.");
                    break;
                }
                default: {
                    System.out.println("getDataFlowType(): Unknown data flow type - " + this.service_.getDataFlowType());
                }
            }
            this.out_.flush();
        }
        catch (SQLException sQLException) {
            System.out.println("Everything is lost... there was an SQLException after the primary function was executed.... stream probably corrupted.");
        }
    }
}

