/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import java.sql.Timestamp;
import java.util.Date;

public class AS400JDBCTimestamp
extends Timestamp {
    static final String copyright = "Copyright (C) 2012-2013 International Business Machines Corporation and others.";
    private static final long serialVersionUID = 1L;
    long picos_ = (long)super.getNanos() * 1000L;
    int length_;

    public AS400JDBCTimestamp(long l, int n) {
        super(l);
        this.length_ = n;
    }

    public AS400JDBCTimestamp(long l) {
        super(l);
        this.length_ = 32;
    }

    public long getPicos() {
        return this.picos_;
    }

    public void setPicos(long l) {
        this.picos_ = l;
        super.setNanos((int)(this.picos_ / 1000L));
    }

    public int getNanos() {
        return (int)(this.getPicos() / 1000L);
    }

    public void setNanos(int n) {
        this.setPicos((long)n * 1000L);
    }

    public String toString() {
        String string = super.toString();
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.indexOf(46);
        if (n > 0) {
            string = string.substring(0, n);
        }
        stringBuffer.append(string);
        if (this.length_ >= 20 && this.picos_ != 0L) {
            stringBuffer.append(".");
            int n2 = 20;
            for (long i = 100000000000L; n2 < this.length_ && i > 0L; ++n2, i /= 10L) {
                char c = (char)(48L + this.picos_ / i % 10L);
                stringBuffer.append(c);
            }
            while (stringBuffer.charAt(stringBuffer.length() - 1) == '0') {
                stringBuffer.setLength(stringBuffer.length() - 1);
            }
        }
        return stringBuffer.toString();
    }

    public void setTime(long l) {
        super.setTime(l);
        this.picos_ = (long)super.getNanos() * 1000L;
    }

    public boolean equals(Timestamp timestamp) {
        return this.compareTo(timestamp) == 0;
    }

    public boolean equals(Object object) {
        if (object instanceof Timestamp) {
            return this.equals((Timestamp)object);
        }
        return false;
    }

    public boolean before(Timestamp timestamp) {
        return this.compareTo(timestamp) < 0;
    }

    public boolean after(Timestamp timestamp) {
        return this.compareTo(timestamp) > 0;
    }

    public int compareTo(Timestamp timestamp) {
        long l;
        long l2 = this.getTime();
        if (l2 != (l = timestamp.getTime())) {
            if (l2 < l) {
                return -1;
            }
            return 1;
        }
        long l3 = timestamp instanceof AS400JDBCTimestamp ? ((AS400JDBCTimestamp)timestamp).getPicos() : (long)(timestamp.getNanos() * 1000);
        if (this.picos_ == l3) {
            return 0;
        }
        if (this.picos_ < l3) {
            return -1;
        }
        return 1;
    }

    public int compareTo(Date date) {
        return this.compareTo((Timestamp)date);
    }

    public static Timestamp valueOf(String string) {
        AS400JDBCTimestamp aS400JDBCTimestamp = null;
        if (string != null) {
            string = string.trim();
        }
        if (string == null || string.length() <= 29) {
            return Timestamp.valueOf(string);
        }
        Timestamp timestamp = Timestamp.valueOf(string.substring(0, 29));
        String string2 = string.substring(29);
        int n = string2.length();
        if (n == 1) {
            string2 = string2 + "00";
        } else if (n == 2) {
            string2 = string2 + "0";
        } else if (n > 3) {
            string2 = string2.substring(0, 3);
        }
        long l = Integer.parseInt(string2);
        if (l == 0L) {
            return timestamp;
        }
        aS400JDBCTimestamp = new AS400JDBCTimestamp(timestamp.getTime());
        aS400JDBCTimestamp.setPicos(l += 1000L * (long)timestamp.getNanos());
        return aS400JDBCTimestamp;
    }
}

