/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.ui.views;

import com.dbeaver.db.ui.internal.OdbcUIMessages;
import com.dbeaver.jdbc.odbc.JdbcOdbcBridgeDriver;
import java.sql.SQLException;
import java.util.Locale;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.ShellUtils;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageWithAuth;
import org.jkiss.dbeaver.ui.dialogs.connection.DriverPropertiesDialogPage;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class OdbcConnectionPage
extends ConnectionPageWithAuth
implements IDialogPageProvider {
    private Button modeDsnButton;
    private Button modeManualButton;
    private Composite dsnGroup;
    private Composite manualGroup;
    private Combo dsnCombo;
    private Combo driverCombo;
    private Text hostNameText;
    private Text hostPortText;
    private Text databaseNameText;

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        Group group = UIUtils.createControlGroup((Composite)composite, (String)OdbcUIMessages.page_connection_title, (int)1, (int)768, (int)0);
        ModifyListener modifyListener = e -> UIUtils.asyncExec(() -> this.getSite().updateButtons());
        SelectionListener visibilityListener = SelectionListener.widgetSelectedAdapter(e -> this.updateGroupVisibility((String)e.widget.getData()));
        Composite selectorGroup = new Composite((Composite)group, 0);
        selectorGroup.setLayoutData((Object)new GridData(1808));
        selectorGroup.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).create());
        UIUtils.createControlLabel((Composite)selectorGroup, (String)OdbcUIMessages.page_connection_mode);
        this.modeDsnButton = UIUtils.createRadioButton((Composite)selectorGroup, (String)OdbcUIMessages.page_connection_datasource, (Object)"dsn", (SelectionListener)visibilityListener);
        this.modeManualButton = UIUtils.createRadioButton((Composite)selectorGroup, (String)OdbcUIMessages.page_connection_manual, (Object)"manual", (SelectionListener)visibilityListener);
        this.dsnGroup = new Composite((Composite)group, 0);
        this.dsnGroup.setLayoutData((Object)new GridData(1808));
        this.dsnGroup.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).create());
        this.dsnCombo = UIUtils.createLabelCombo((Composite)this.dsnGroup, (String)OdbcUIMessages.page_connection_datasource_datasource, (int)4);
        this.dsnCombo.addModifyListener(modifyListener);
        UIUtils.createToolItem((ToolBar)new ToolBar(this.dsnGroup, 256), (String)OdbcUIMessages.page_connection_datasource_refresh, (DBPImage)UIIcon.REFRESH, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> this.refreshDataSources()));
        if (RuntimeUtils.isWindows()) {
            UIUtils.createPlaceholder((Composite)this.dsnGroup, (int)1);
            CLabel label = UIUtils.createInfoLabel((Composite)this.dsnGroup, (String)OdbcUIMessages.page_connection_datasource_hint, (int)768, (int)2);
            label.setCursor(Display.getCurrent().getSystemCursor(21));
            label.addMouseListener(MouseListener.mouseDownAdapter(e -> {
                boolean bl = ShellUtils.launchProgram((String)"odbcad32");
            }));
        }
        this.manualGroup = new Composite((Composite)group, 0);
        this.manualGroup.setLayoutData((Object)new GridData(1808));
        this.manualGroup.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(4).create());
        UIUtils.createControlLabel((Composite)this.manualGroup, (String)OdbcUIMessages.page_connection_manual_driver);
        Composite driverComposite = new Composite(this.manualGroup, 0);
        driverComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        driverComposite.setLayoutData((Object)new GridData(4, 1, true, false, 3, 1));
        this.driverCombo = new Combo(driverComposite, 12);
        this.driverCombo.addModifyListener(modifyListener);
        this.driverCombo.setLayoutData((Object)new GridData(768));
        UIUtils.createToolItem((ToolBar)new ToolBar(driverComposite, 256), (String)OdbcUIMessages.page_connection_manual_driver_refresh, (DBPImage)UIIcon.REFRESH, (SelectionListener)SelectionListener.widgetSelectedAdapter(e -> this.refreshDrivers()));
        this.hostNameText = UIUtils.createLabelText((Composite)this.manualGroup, (String)OdbcUIMessages.page_connection_manual_host_name, (String)"");
        this.hostNameText.addModifyListener(modifyListener);
        this.hostNameText.setLayoutData((Object)new GridData(768));
        this.hostPortText = UIUtils.createLabelText((Composite)this.manualGroup, (String)OdbcUIMessages.page_connection_manual_host_port, (String)"");
        this.hostPortText.addModifyListener(modifyListener);
        this.hostPortText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.hostPortText.setLayoutData((Object)new GridData(32));
        ((GridData)this.hostPortText.getLayoutData()).widthHint = UIUtils.getFontHeight((Font)this.hostPortText.getFont()) * 10;
        this.databaseNameText = UIUtils.createLabelText((Composite)this.manualGroup, (String)OdbcUIMessages.page_connection_manual_database_name, (String)"");
        ((GridData)this.databaseNameText.getLayoutData()).horizontalSpan = 3;
        this.createAuthPanel(composite, 1);
        this.createDriverPanel(composite);
        this.setControl((Control)composite);
    }

    public void loadSettings() {
        DBPConnectionConfiguration configuration = this.site.getActiveDataSource().getConnectionConfiguration();
        String mode = configuration.getProviderProperty("odbc-connection-mode");
        this.updateGroupVisibility(mode);
        if ("manual".equals(mode)) {
            this.modeManualButton.setSelection(true);
            this.hostNameText.setText(CommonUtils.notEmpty((String)configuration.getHostName()));
            this.hostPortText.setText(CommonUtils.notEmpty((String)configuration.getHostPort()));
            this.databaseNameText.setText(CommonUtils.notEmpty((String)configuration.getDatabaseName()));
            this.driverCombo.setText(CommonUtils.notEmpty((String)configuration.getServerName()));
            this.driverCombo.notifyListeners(13, new Event());
        } else {
            this.modeDsnButton.setSelection(true);
            this.dsnCombo.setText(CommonUtils.notEmpty((String)configuration.getDatabaseName()));
            this.dsnCombo.notifyListeners(13, new Event());
        }
        super.loadSettings();
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        super.saveSettings(dataSource);
        DBPConnectionConfiguration configuration = dataSource.getConnectionConfiguration();
        if (this.modeDsnButton.getSelection()) {
            configuration.setProviderProperty("odbc-connection-mode", "dsn");
            configuration.setDatabaseName(this.dsnCombo.getText());
        } else {
            configuration.setProviderProperty("odbc-connection-mode", "manual");
            configuration.setServerName(this.driverCombo.getText());
            configuration.setHostName(this.hostNameText.getText());
            configuration.setHostPort(this.hostPortText.getText());
            configuration.setDatabaseName(this.databaseNameText.getText());
        }
    }

    public boolean isComplete() {
        if (this.modeDsnButton.getSelection()) {
            return super.isComplete() && ArrayUtils.contains((Object[])this.dsnCombo.getItems(), (Object)this.dsnCombo.getText());
        }
        return super.isComplete() && ArrayUtils.contains((Object[])this.driverCombo.getItems(), (Object)this.driverCombo.getText()) && CommonUtils.isNotEmpty((String)this.hostNameText.getText()) && CommonUtils.isNotEmpty((String)this.hostPortText.getText());
    }

    public Image getImage() {
        return DBeaverIcons.getImage((DBPImage)this.getSite().getDriver().getIconBig());
    }

    @NotNull
    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        return new IDialogPage[]{new DriverPropertiesDialogPage((ConnectionPageAbstract)this)};
    }

    private void updateGroupVisibility(@NotNull String mode) {
        if ("manual".equals(mode)) {
            UIUtils.setControlVisible((Control)this.dsnGroup, (boolean)false);
            UIUtils.setControlVisible((Control)this.manualGroup, (boolean)true);
            this.refreshDrivers();
        } else {
            UIUtils.setControlVisible((Control)this.dsnGroup, (boolean)true);
            UIUtils.setControlVisible((Control)this.manualGroup, (boolean)false);
            this.refreshDataSources();
        }
        this.getShell().layout(true, true);
        UIUtils.resizeShell((Shell)this.getShell());
        this.site.updateButtons();
    }

    private void refreshDataSources() {
        JdbcOdbcBridgeDriver.DataSourceInfo[] dataSources;
        String selection = this.dsnCombo.getText();
        JdbcOdbcBridgeDriver driver = JdbcOdbcBridgeDriver.getInstance();
        this.dsnCombo.removeAll();
        try {
            dataSources = driver.listDataSources(JdbcOdbcBridgeDriver.DataSourceType.ALL);
        }
        catch (SQLException e) {
            DBWorkbench.getPlatformUI().showError(OdbcUIMessages.page_connection_datasource_refresh_error_title, OdbcUIMessages.page_connection_datasource_refresh_error_message, (Throwable)e);
            return;
        }
        JdbcOdbcBridgeDriver.DataSourceInfo[] dataSourceInfoArray = dataSources;
        int n = dataSources.length;
        int n2 = 0;
        while (n2 < n) {
            JdbcOdbcBridgeDriver.DataSourceInfo info = dataSourceInfoArray[n2];
            this.dsnCombo.add(info.getName());
            ++n2;
        }
        this.dsnCombo.setText(selection);
        this.dsnCombo.notifyListeners(13, new Event());
    }

    private void refreshDrivers() {
        JdbcOdbcBridgeDriver.DriverInfo[] drivers;
        String selection = this.driverCombo.getText();
        JdbcOdbcBridgeDriver driver = JdbcOdbcBridgeDriver.getInstance();
        this.driverCombo.removeAll();
        try {
            drivers = driver.listDrivers();
        }
        catch (SQLException e) {
            DBWorkbench.getPlatformUI().showError(OdbcUIMessages.page_connection_manual_driver_refresh_error_title, OdbcUIMessages.page_connection_manual_driver_refresh_error_message, (Throwable)e);
            return;
        }
        JdbcOdbcBridgeDriver.DriverInfo[] driverInfoArray = drivers;
        int n = drivers.length;
        int n2 = 0;
        while (n2 < n) {
            JdbcOdbcBridgeDriver.DriverInfo info = driverInfoArray[n2];
            this.driverCombo.add(info.getDescription());
            ++n2;
        }
        this.driverCombo.setText(selection);
        this.driverCombo.notifyListeners(13, new Event());
    }
}

