/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlExFactory;
import java.math.BigDecimal;
import java.sql.SQLException;

public class SqlDouble
extends SqlData {
    private double value = 0.0;

    public SqlDouble() {
        super(true);
    }

    public SqlDouble(double d) {
        super(false);
        this.value = d;
    }

    public void set(double d) {
        this.setNotNull();
        this.value = d;
    }

    public void set(SqlDouble sqlDouble) {
        if (sqlDouble == null || sqlDouble.isNull()) {
            this.setNull();
        } else {
            this.setNotNull();
            this.value = sqlDouble.value;
        }
    }

    public double get() {
        return this.value;
    }

    @Override
    public void setBoolean(boolean bl) throws SQLException {
        this.setNotNull();
        this.value = bl ? 1.0 : 0.0;
    }

    @Override
    public void setByte(byte by) throws SQLException {
        this.setNotNull();
        this.value = by;
    }

    @Override
    public void setShort(short s) throws SQLException {
        this.setNotNull();
        this.value = s;
    }

    @Override
    public void setInt(int n) throws SQLException {
        this.setNotNull();
        this.value = n;
    }

    @Override
    public void setLong(long l) throws SQLException {
        this.setNotNull();
        this.value = l;
    }

    @Override
    public void setFloat(float f) throws SQLException {
        this.setNotNull();
        this.value = f;
    }

    @Override
    public void setDouble(double d) throws SQLException {
        this.setNotNull();
        this.value = d;
    }

    @Override
    public void setBigDecimal(BigDecimal bigDecimal) throws SQLException {
        if (bigDecimal == null) {
            this.setNull();
        } else {
            this.setNotNull();
            this.value = bigDecimal.doubleValue();
        }
    }

    @Override
    public void setString(String string) throws SQLException {
        if (string == null) {
            this.setNull();
        } else {
            this.setNotNull();
            try {
                this.value = Double.parseDouble(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw SqlExFactory.get(ERR_GC401A_CONVERSION_ERR);
            }
        }
    }

    @Override
    public boolean getBoolean() throws SQLException {
        return this.value != 0.0;
    }

    @Override
    public byte getByte() throws SQLException {
        return (byte)this.value;
    }

    @Override
    public short getShort() throws SQLException {
        return (short)this.value;
    }

    @Override
    public int getInt() throws SQLException {
        return (int)this.value;
    }

    @Override
    public long getLong() throws SQLException {
        return (long)this.value;
    }

    @Override
    public float getFloat() throws SQLException {
        return (float)this.value;
    }

    @Override
    public double getDouble() throws SQLException {
        return this.value;
    }

    @Override
    public BigDecimal getBigDecimal() throws SQLException {
        return new BigDecimal(this.value);
    }

    @Override
    public String getString() throws SQLException {
        return Double.toString(this.value);
    }

    @Override
    public Object getObject() throws SQLException {
        return new Double(this.value);
    }
}

