/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc.preparser2;

import com.intersys.jdbc.preparser2.Token;

public class StaticStringBuffer {
    private static int BUF_LEN = 32768;
    private static char[] buffer = new char[BUF_LEN];
    private static int curPos = 0;

    public static void append(String str) {
        int len = str.length();
        int oldPos = curPos;
        StaticStringBuffer.inc(len);
        str.getChars(0, len, buffer, oldPos);
    }

    public static void append(char c) {
        int oldPos = curPos;
        StaticStringBuffer.inc(1);
        StaticStringBuffer.buffer[oldPos] = c;
    }

    public static void append(Token t) {
        int len = t.endColumn - t.beginColumn + 1;
        int oldPos = curPos;
        StaticStringBuffer.inc(len);
        t.buffer.getChars(t.beginColumn, t.endColumn + 1, buffer, oldPos);
    }

    public static String getString() {
        return new String(buffer, 0, curPos);
    }

    public static void clear() {
        curPos = 0;
    }

    public static boolean isEmpty() {
        return curPos == 0;
    }

    private static void inc(int len) {
        if (curPos + len >= BUF_LEN) {
            int NEW_BUF_LEN = curPos + len >= BUF_LEN * 2 ? curPos + len : BUF_LEN * 2;
            char[] buf2 = new char[NEW_BUF_LEN];
            System.arraycopy(buffer, 0, buf2, 0, curPos);
            buffer = buf2;
            BUF_LEN = NEW_BUF_LEN;
        }
        curPos += len;
    }
}

