/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc.preparser;

import com.intersys.jdbc.preparser.ITokenEnumerator;
import com.intersys.jdbc.preparser.Token;
import com.intersys.jdbc.preparser.TokenList;
import com.intersys.jdbc.preparser.TokenListNode;

class LinkedListEnumerator
implements ITokenEnumerator {
    private TokenList m_List;
    private TokenListNode m_Current;
    private boolean m_bEOF;

    @Override
    public ITokenEnumerator Clone() {
        return new LinkedListEnumerator(this);
    }

    LinkedListEnumerator(TokenList List2) {
        this.m_List = List2;
        this.m_Current = null;
        this.m_bEOF = false;
    }

    LinkedListEnumerator(LinkedListEnumerator p_Enum) {
        this.m_List = p_Enum.m_List;
        this.m_Current = p_Enum.m_Current;
        this.m_bEOF = p_Enum.m_bEOF;
    }

    @Override
    public int Count() {
        return this.m_List.Count();
    }

    @Override
    public Token Current() {
        return this.m_Current.GetValue();
    }

    @Override
    public boolean MoveNext() {
        if (this.m_bEOF) {
            return false;
        }
        this.m_Current = this.m_Current == null ? this.m_List.First() : this.m_Current.Next();
        this.m_bEOF = this.m_Current == null;
        return !this.m_bEOF;
    }

    @Override
    public boolean MovePrevious() {
        if (this.m_bEOF) {
            return false;
        }
        this.m_Current = this.m_Current == null ? this.m_List.Last() : this.m_Current.Previous();
        this.m_bEOF = this.m_Current == null;
        return !this.m_bEOF;
    }

    @Override
    public void Reset() {
        this.m_Current = null;
        this.m_bEOF = false;
    }
}

