/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.CacheConnectionListener;
import com.intersys.jdbc.ObjectFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class RegisteredDatabases {
    Set<CacheConnectionListener> databases;

    public synchronized void onClose() {
        if (this.databases == null) {
            return;
        }
        Iterator<CacheConnectionListener> it = this.databases.iterator();
        while (it.hasNext()) {
            CacheConnectionListener obj = it.next();
            it.remove();
            obj.onConnectionClosed();
        }
        this.databases = null;
    }

    public boolean register(CacheConnectionListener db) {
        if (this.databases == null) {
            this.databases = new HashSet<CacheConnectionListener>();
        }
        return this.databases.add(db);
    }

    public boolean unregister(CacheConnectionListener db) {
        if (this.databases == null) {
            return false;
        }
        return this.databases.remove(db);
    }

    ObjectFactory getObjectFactory(CacheConnection connection) throws SQLException {
        if (this.databases != null) {
            for (CacheConnectionListener next : this.databases) {
                if (!(next instanceof ObjectFactory)) continue;
                return (ObjectFactory)((Object)next);
            }
        }
        return this.constructNewObjectFactory(connection);
    }

    private ObjectFactory constructNewObjectFactory(CacheConnection connection) throws SQLException {
        try {
            Class<?> cacheDatabase = Class.forName("com.intersys.objects.CacheDatabase");
            Method m = cacheDatabase.getMethod("getLightDatabase", Connection.class);
            return (ObjectFactory)m.invoke(null, connection);
        }
        catch (ClassNotFoundException x) {
            throw new SQLException("No Object Factory class is available in your classpath");
        }
        catch (NoSuchMethodException x) {
            throw new SQLException(x.getMessage());
        }
        catch (IllegalAccessException x) {
            throw new SQLException(x.getMessage());
        }
        catch (InvocationTargetException x) {
            throw new SQLException(x.getMessage());
        }
    }
}

