/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheBufferUtils;
import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.InStream;
import com.intersys.jdbc.OutStream;
import com.intersys.jdbc.Stream;
import com.intersys.util.ListUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.sql.SQLException;

class RealStream
extends Stream {
    CacheConnection connection;
    String streamOID;
    Object streamHandle;
    int cursorNumber = 0;
    InStream input;
    OutStream output;

    RealStream(CacheConnection conn, String oid, Object h, int scn, int st, int qt, int mx) throws SQLException {
        super(st, qt, mx);
        this.connection = conn;
        try {
            this.output = new OutStream(this.connection);
            this.output.wire.setConnectionInfo(this.connection.connectionInfo);
            this.input = new InStream(this.connection);
            this.input.setLocale(this.connection);
        }
        catch (IOException e) {
            throw new SQLException("[Cache JDBC] Communication link failure: " + e.getMessage(), "08S01", 461);
        }
        this.streamOID = oid;
        this.streamHandle = h;
        this.cursorNumber = scn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void getSize() throws SQLException {
        try {
            CacheConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                this.output.wire.writeHeader(this.cursorNumber, CacheConnection.OPEN_STREAM);
                this.output.wire.set(this.streamOID);
                this.output.send(this.connection.messageCount.getCount());
                if (this.input.readMessage(this.cursorNumber, 0, 403) == 403) {
                    this.size = -1;
                    return;
                }
                this.streamHandle = this.input.wire.getByteArray();
                this.available = this.size = this.input.wire.getInt();
            }
        }
        catch (Exception e) {
            throw new SQLException("Error reading stream data: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void getStreamSize() throws SQLException {
        if (this.streamHandle == null) {
            throw new SQLException("Null stream handle");
        }
        try {
            CacheConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                this.output.wire.writeHeader(this.cursorNumber, CacheConnection.GET_STREAM_SIZE);
                this.output.wire.setParameter(this.streamHandle);
                this.output.send(this.connection.messageCount.getCount());
                if (this.input.readMessage(this.cursorNumber, 0, 403) == 403) {
                    this.size = -1;
                    return;
                }
                this.available = this.size = this.input.wire.getInt();
            }
        }
        catch (Exception e) {
            throw new SQLException("Error reading stream data: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized byte[] getByteStream(long pos, int len) throws SQLException {
        if (this.closed) {
            throw new SQLException("This stream object is closed.", "08003");
        }
        if (this.size == 0) {
            return new byte[0];
        }
        if (pos > (long)this.size) {
            return null;
        }
        if (len < 0 || pos <= 0L) {
            throw new SQLException("Invalid parameters: pos = " + pos + " len = " + len);
        }
        if ((long)this.size - pos < (long)len) {
            len = (int)((long)this.size - pos + 1L);
        }
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.output.wire.writeHeader(this.cursorNumber, CacheConnection.STREAM_GET_BYTES);
            this.output.wire.setParameter(this.streamHandle);
            this.output.wire.set(pos);
            this.output.wire.set(len);
            this.output.send(this.connection.messageCount.getCount());
            int rc = this.input.readMessage(this, this.cursorNumber, 1, 403, false);
            if (this.RawBytes.length == this.RawBytesPtr) {
                return this.RawBytes;
            }
            return CacheBufferUtils.copyByteArray(this.RawBytes, 0, this.RawBytesPtr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getPosition(byte[] pattern, long start) throws SQLException {
        if (this.closed) {
            throw new SQLException("This stream object is closed.", "08003");
        }
        if (this.size <= 0) {
            return -1L;
        }
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.output.wire.writeHeader(this.cursorNumber, CacheConnection.STREAM_GET_POSITION);
            this.output.wire.setParameter(this.streamHandle);
            this.output.wire.set(start);
            this.output.wire.set(pattern);
            this.output.send(this.connection.messageCount.getCount());
            this.input.readMessage(this.cursorNumber, 0, 0);
            return this.input.wire.getLong();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized int fetchStream(Object b, int streamType, int off, int len) throws SQLException {
        if (this.closed) {
            throw new SQLException("This stream object is closed.", "08003");
        }
        if (this.available <= 0 || this.maxStreamSize == 0) {
            return -1;
        }
        if (len > this.available) {
            len = this.available;
        }
        if (this.maxStreamSize > 0 && len > this.maxStreamSize) {
            len = this.maxStreamSize;
        }
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.output.wire.writeHeader(this.cursorNumber, CacheConnection.READ_STREAM);
            this.output.wire.setParameter(this.streamHandle);
            this.output.wire.set(len);
            this.output.send(this.connection.messageCount.getCount());
            this.requestedStreamLength = len;
            int rc = this.input.readMessage(this, this.cursorNumber, 1, 403, false);
            if (rc == 403) {
                b = null;
                return -1;
            }
            this.consumed = RealStream.readStream(this.RawBytes, b, off, len, streamType, this.sqlType);
            this.available -= this.consumed;
            if (this.maxStreamSize > 0) {
                this.maxStreamSize -= this.consumed;
            }
        }
        return this.consumed;
    }

    @Override
    boolean isNull() {
        if (this.size == -1) {
            return true;
        }
        return this.input.wire.isNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.size = 0;
        this.streamOID = null;
        try {
            CacheConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                this.output.wire.writeHeader(this.cursorNumber, CacheConnection.CLOSE_STREAM);
                this.output.wire.setParameter(this.streamHandle);
                this.output.send(this.connection.messageCount.getCount());
            }
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        this.streamHandle = null;
        this.connection = null;
        this.available = 0;
        this.closed = true;
    }

    static Object sendStream(CacheConnection connection, Object s, int length, int streamType, int sqlType, int serverCursorNumber) throws SQLException {
        if (connection.protocolVersion > 49 && (streamType == 0 && connection.isServerUnicode() || streamType == 1) && length > 0 && length <= connection.getSendStreamImmeadiateSize()) {
            Object tmpByteArray = RealStream.sendStreamImmediate((InputStream)s, length, streamType);
            if (length == 1 && ((byte[])tmpByteArray)[0] == 0) {
                return RealStream.sendStream(connection, new ByteArrayInputStream((byte[])tmpByteArray), length, streamType, sqlType, serverCursorNumber, null);
            }
            return tmpByteArray;
        }
        return RealStream.sendStream(connection, s, length, streamType, sqlType, serverCursorNumber, null);
    }

    static Object sendStreamImmediate(InputStream stream, int length, int streamType) throws SQLException {
        int bytesRead;
        byte[] byteArray = new byte[length];
        for (int bytesToRead = length; bytesToRead > 0; bytesToRead -= bytesRead) {
            try {
                bytesRead = stream.read(byteArray, 0, bytesToRead);
                if (bytesRead == -1) break;
                continue;
            }
            catch (IOException ex) {
                throw new SQLException("Error sending stream: " + ex.getMessage());
            }
        }
        if (stream.markSupported() && !(stream instanceof BufferedInputStream)) {
            try {
                stream.reset();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return byteArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object sendStream(CacheConnection connection, Object s, int length, int streamType, int sqlType, int serverCursorNumber, Object streamHandle) throws SQLException {
        if (streamHandle == null) {
            streamHandle = new Integer(0);
        }
        int maxSendBuffSize = connection.getMaxSendBuffSize();
        try {
            while (true) {
                int bytesToSend = length < 0 || length > maxSendBuffSize ? maxSendBuffSize : length;
                CacheConnection.MessageCount messageCount = connection.messageCount;
                synchronized (messageCount) {
                    if (streamType == 4) {
                        connection.outMessage.wire.writeHeader(serverCursorNumber, CacheConnection.STORE_CHARACTER_STREAM);
                        connection.outMessage.wire.setParameter(streamHandle);
                        connection.outMessage.wire.writeReader((Reader)s, bytesToSend);
                    } else if (streamType == 1) {
                        connection.outMessage.wire.writeHeader(serverCursorNumber, CacheConnection.STORE_BINARY_STREAM);
                        connection.outMessage.wire.setParameter(streamHandle);
                        connection.outMessage.wire.writeInputStream((InputStream)s, bytesToSend, streamType, sqlType);
                    } else {
                        connection.outMessage.wire.writeHeader(serverCursorNumber, CacheConnection.STORE_CHARACTER_STREAM);
                        connection.outMessage.wire.setParameter(streamHandle);
                        connection.outMessage.wire.writeInputStream((InputStream)s, bytesToSend, streamType, sqlType);
                    }
                    connection.outMessage.send(connection.messageCount.getCount());
                    connection.inMessage.readMessage(serverCursorNumber, 0, 0);
                    connection.outMessage.wire.reset();
                    streamHandle = connection.inMessage.wire.getByteArray();
                }
                if (length >= 0) {
                    if ((length -= bytesToSend) != 0) continue;
                    break;
                }
                if (streamType != 4) {
                    throw new SQLException("Negative length supported only with Reader.", "S1000");
                }
                Reader r = (Reader)s;
                int c = r.read();
                if (c < 0) break;
                PushbackReader pb = r instanceof PushbackReader ? (PushbackReader)r : new PushbackReader(r);
                pb.unread(c);
                s = pb;
            }
            if (streamType != 4 && ((InputStream)s).markSupported() && !(s instanceof BufferedInputStream)) {
                try {
                    ((InputStream)s).reset();
                }
                catch (Exception e) {}
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SQLException("Error writing stream: " + e.getMessage());
        }
        return streamHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int sendBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        if (this.closed) {
            throw new SQLException("This stream object is closed.", "08003");
        }
        if (pos < 1L) {
            throw new SQLException("pos cannot be less than 1: " + pos);
        }
        if (offset > bytes.length) {
            throw new SQLException("Offset value greater then the length of the byte array: " + offset);
        }
        if (offset + len > bytes.length) {
            len = bytes.length - offset;
        }
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.output.wire.writeHeader(this.cursorNumber, CacheConnection.STREAM_SET_BYTES);
            this.output.wire.setParameter(this.streamHandle);
            this.output.wire.set(pos - 1L);
            this.output.wire.set(len);
            this.output.wire.append(bytes);
            this.output.send(this.connection.messageCount.getCount());
            this.input.readMessage(this.cursorNumber, 0, 0);
            return this.input.wire.getInt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void truncateStream(long len) throws SQLException {
        if (this.size <= 0) {
            return;
        }
        if (this.closed) {
            throw new SQLException("This stream object is closed.", "08003");
        }
        if (len < 0L) {
            throw new SQLException("value for len cannot be negative: " + len);
        }
        CacheConnection.MessageCount messageCount = this.connection.messageCount;
        synchronized (messageCount) {
            this.output.wire.writeHeader(this.cursorNumber, CacheConnection.STREAM_TRUNCATE);
            this.output.wire.setParameter(this.streamHandle);
            this.output.wire.set(len);
            this.output.send(this.connection.messageCount.getCount());
            this.input.readMessage(this.cursorNumber, 0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseReadLock() throws IOException {
        if (this.connection.protocolVersion < 49) {
            return;
        }
        try {
            CacheConnection.MessageCount messageCount = this.connection.messageCount;
            synchronized (messageCount) {
                this.output.wire.writeHeader(this.cursorNumber, CacheConnection.STREAM_RELEASE_READ_LOCK);
                this.output.wire.setParameter(this.streamHandle);
                this.output.send(this.connection.messageCount.getCount());
                this.input.readMessage(this.cursorNumber, 0, 0);
            }
        }
        catch (Exception e) {
            if (e.getMessage().contains("[%msg: <Unknown xDBC function: SR>]")) {
                return;
            }
            throw new IOException(e.getMessage());
        }
    }

    static int readStream(byte[] ucs2, Object stream, int offset, int length, int streamType, int sqlType) throws SQLException {
        if (streamType == 0) {
            return ListUtil.readAsciiStream(ucs2, (byte[])stream, offset, length, sqlType);
        }
        if (streamType == 1) {
            if (ucs2.hashCode() != stream.hashCode()) {
                System.arraycopy(ucs2, 0, (byte[])stream, offset, length);
            }
            return length;
        }
        if (streamType == 4) {
            return ListUtil.readCharacterStream(ucs2, (char[])stream, offset, length, sqlType);
        }
        throw new SQLException("Unknown stream type: " + streamType);
    }
}

