/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheBufferWrite;
import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.LogFileStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

public final class OutStream {
    LogFileStream logFile;
    public CacheBufferWrite wire;
    private int protocolVersion = 53;
    OutputStream outputStream;
    private CacheConnection connection;

    public OutStream(OutputStream output, LogFileStream LF) {
        this.outputStream = output;
        this.logFile = LF;
        this.wire = new CacheBufferWrite(null);
    }

    OutStream(CacheConnection conn) throws IOException {
        this.outputStream = conn.outputStream;
        this.wire = new CacheBufferWrite(null);
        this.connection = conn;
        this.protocolVersion = this.connection.protocolVersion;
        this.logFile = this.connection.logFile;
    }

    public void setConnection(CacheConnection conn) {
        this.connection = conn;
        this.wire.setConnectionInfo(conn.connectionInfo);
        this.protocolVersion = this.connection.protocolVersion;
    }

    public final synchronized void send(int count) throws SQLException {
        try {
            this.wire.dumpData(this.outputStream, count, this.logFile);
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw new SQLException("Communication link failure: " + e.getMessage(), "08S01", 461);
        }
    }

    final synchronized CacheBufferWrite setWire(CacheBufferWrite w) {
        CacheBufferWrite old = this.wire;
        this.wire = w;
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeHeaderAndSend(byte[] header, byte[] buffer, int bufferLength) throws IOException {
        OutputStream outputStream = this.outputStream;
        synchronized (outputStream) {
            this.outputStream.write(header, 0, 14);
            this.outputStream.write(buffer, 0, bufferLength);
            this.outputStream.flush();
        }
        if (this.logFile != null) {
            this.logFile.dump(buffer, 0, bufferLength, 1, header);
        }
    }
}

