/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheStatement;
import com.intersys.jdbc.CacheWrapper;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class CacheParameterMetaData
extends CacheWrapper
implements ParameterMetaData {
    List<CacheStatement.Parameter> parameters = new ArrayList<CacheStatement.Parameter>();

    CacheParameterMetaData(List<CacheStatement.Parameter> p) {
        for (int i = 0; i < p.size(); ++i) {
            if (p.get((int)i).mode == 5) continue;
            this.parameters.add(p.get(i));
        }
    }

    @Override
    public int getParameterCount() throws SQLException {
        return this.parameters.size();
    }

    @Override
    public int isNullable(int param) throws SQLException {
        if (param <= 0 || param > this.parameters.size()) {
            throw new SQLException("Invalid parameter number", "S1002", 463);
        }
        return this.parameters.get((int)(param - 1)).nullable;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        if (param <= 0 || param > this.parameters.size()) {
            throw new SQLException("Invalid parameter number", "S1002", 463);
        }
        switch (this.parameters.get((int)(param - 1)).type) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        if (param <= 0 || param > this.parameters.size()) {
            throw new SQLException("Invalid parameter number", "S1002", 463);
        }
        return this.parameters.get((int)(param - 1)).precision;
    }

    @Override
    public int getScale(int param) throws SQLException {
        if (param <= 0 || param > this.parameters.size()) {
            throw new SQLException("Invalid parameter number", "S1002", 463);
        }
        return this.parameters.get((int)(param - 1)).scale;
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        if (param <= 0 || param > this.parameters.size()) {
            throw new SQLException("Invalid parameter number", "S1002", 463);
        }
        int parType = this.parameters.get((int)(param - 1)).type;
        if (parType > 1000) {
            parType -= 1000;
        }
        return parType;
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        if (param <= 0 || param > this.parameters.size()) {
            throw new SQLException("Invalid parameter number", "S1002", 463);
        }
        int parType = this.parameters.get((int)(param - 1)).type;
        if (parType > 1000) {
            parType -= 1000;
        }
        switch (parType) {
            case -5: {
                return "BIGINT";
            }
            case -7: {
                return "BIT";
            }
            case -2: {
                return "BINARY";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 2: {
                return "NUMERIC";
            }
            case 7: {
                return "REAL";
            }
            case 5: {
                return "SMALLINT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
            case 2002: {
                return "STRUCT";
            }
            case -51: {
                return "RESULTSET";
            }
        }
        return "UNKNOWN TYPE";
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        if (param <= 0 || param > this.parameters.size()) {
            throw new SQLException("Invalid parameter number", "S1002", 463);
        }
        int parType = this.parameters.get((int)(param - 1)).type;
        if (parType > 1000) {
            parType -= 1000;
        }
        switch (parType) {
            case -1: 
            case 1: 
            case 12: {
                return "java.lang.String";
            }
            case 2: 
            case 3: {
                return "java.math.BigDecimal";
            }
            case -7: {
                return "java.lang.Boolean";
            }
            case -6: 
            case 4: 
            case 5: {
                return "java.lang.Integer";
            }
            case -5: {
                return "java.lang.Long";
            }
            case 7: {
                return "java.lang.Float";
            }
            case 6: 
            case 8: {
                return "java.lang.Double";
            }
            case -4: 
            case -3: 
            case -2: {
                return "byte[]";
            }
            case 91: {
                return "java.sql.Date";
            }
            case 92: {
                return "java.sql.Time";
            }
            case 93: {
                return "java.sql.Timestamp";
            }
            case -51: {
                return "java.sql.ResultSet";
            }
        }
        return "java.lang.String";
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        if (param <= 0 || param > this.parameters.size()) {
            throw new SQLException("Invalid parameter number", "S1002", 463);
        }
        return this.parameters.get((int)(param - 1)).mode;
    }
}

