/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.CacheConnectionPoolDataSource;
import com.intersys.jdbc.CacheDriver;
import com.intersys.jdbc.CacheWrapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class CacheDataSource
extends CacheWrapper
implements DataSource {
    static CacheDriver driver;
    private String password = "";
    private String user = "";
    private String database = null;
    private String server = null;
    private String IPv6address = null;
    private String url = null;
    private int port = 1972;
    private PrintWriter logStream = null;
    private String dataSource = null;
    private String description = null;
    private String eventClass = "";
    private int loginTimeout = 0;
    private boolean nodelay = true;
    private int securityLevel = 0;
    private String principalName = null;
    private String sSLConfigName = null;
    private String keyRecoveryPassword = null;
    private int isolationLevel = 1;

    @Override
    public synchronized Connection getConnection() throws SQLException {
        return this.getConnection(this.user, this.password);
    }

    @Override
    public synchronized Connection getConnection(String usr, String pwd) throws SQLException {
        this.getURL();
        if (this instanceof CacheConnectionPoolDataSource) {
            return CacheDriver.CPManager.lookup((CacheConnectionPoolDataSource)this, usr, pwd).getConnection();
        }
        return new CacheConnection(this, usr, pwd, null);
    }

    @Override
    public synchronized PrintWriter getLogWriter() {
        return this.logStream;
    }

    @Override
    public synchronized void setLogWriter(PrintWriter out) {
        this.logStream = out;
    }

    @Override
    public synchronized void setLoginTimeout(int seconds) {
        this.loginTimeout = seconds;
    }

    @Override
    public synchronized int getLoginTimeout() {
        return this.loginTimeout;
    }

    public synchronized void setDatabaseName(String databaseName) {
        this.database = databaseName;
    }

    public synchronized String getDatabaseName() {
        return this.database;
    }

    public synchronized void setDataSourceName(String dataSourceName) {
        this.dataSource = dataSourceName;
    }

    public synchronized String getDataSourceName() {
        return this.dataSource;
    }

    public synchronized void setDescription(String desc) {
        this.description = desc;
    }

    public synchronized String getDescription() {
        return this.description;
    }

    public synchronized void setPassword(String pwd) {
        this.password = pwd;
    }

    public synchronized String getPassword() {
        return this.password;
    }

    public synchronized void setPortNumber(int portNumber) {
        this.port = portNumber;
    }

    public synchronized int getPortNumber() {
        return this.port;
    }

    public synchronized void setServerName(String serverName) {
        this.server = serverName;
    }

    public synchronized String getServerName() {
        return this.server;
    }

    public synchronized void setIPv6ServerAddress(String address) {
        this.IPv6address = address;
    }

    public synchronized String getIPv6ServerAddress() {
        return this.IPv6address;
    }

    public synchronized void setUser(String username) {
        this.user = username;
    }

    public synchronized String getUser() {
        return this.user;
    }

    public synchronized void setEventClass(String eventClassName) {
        this.eventClass = eventClassName;
        if (this.eventClass == null) {
            this.eventClass = "";
        }
    }

    public synchronized String getEventClass() {
        return this.eventClass;
    }

    public synchronized void setURL(String u) throws SQLException {
        int pos;
        if (!u.startsWith("jdbc:Cache://")) {
            throw new SQLException("Invalid URL: " + u, "S1000");
        }
        this.url = u;
        String temp = this.url.substring(13);
        if ((temp = this.parseCredentials(temp)).startsWith("[")) {
            pos = temp.indexOf("]");
            if (pos == -1) {
                throw new SQLException("Invalid URL: " + u, "S1000");
            }
            this.server = this.IPv6address = temp.substring(1, pos);
            if (!(temp = temp.substring(pos + 1)).startsWith(":")) {
                throw new SQLException("Invalid URL: " + u, "S1000");
            }
            pos = (temp = temp.substring(1)).indexOf("/");
            if (pos == -1) {
                throw new SQLException("Invalid URL: " + u, "S1000");
            }
        } else {
            pos = temp.indexOf(":");
            if (pos == -1) {
                throw new SQLException("Invalid URL: " + u, "S1000");
            }
            this.server = temp.substring(0, pos);
            if ((pos = (temp = temp.substring(pos + 1)).indexOf("/")) == -1) {
                return;
            }
        }
        this.port = Integer.parseInt(temp.substring(0, pos));
        if ((pos = (temp = temp.substring(pos + 1)).indexOf("/")) == -1) {
            this.database = temp;
            this.logStream = null;
            return;
        }
        this.database = temp.substring(0, pos);
        if ((pos = (temp = temp.substring(pos + 1)).indexOf(":")) == -1) {
            this.setLogStream(temp);
            return;
        }
        this.setLogStream(temp.substring(0, pos));
        temp = temp.substring(pos + 1);
        this.parseExtension(temp);
    }

    public synchronized String getURL() {
        if (this.url == null) {
            this.url = this.server != null ? "jdbc:Cache://" + this.server + ":" + this.port + "/" + this.database : "jdbc:Cache://[" + this.IPv6address + "]:" + this.port + "/" + this.database;
        }
        return this.url;
    }

    public synchronized void setNodelay(boolean noDelay) {
        this.nodelay = noDelay;
    }

    public synchronized boolean getNodelay() {
        return this.nodelay;
    }

    public synchronized void setServicePrincipalName(String name) {
        this.principalName = name;
    }

    public synchronized String getServicePrincipalName() {
        return this.principalName;
    }

    public synchronized void setConnectionSecurityLevel(int level) {
        this.securityLevel = level;
    }

    public synchronized int getConnectionSecurityLevel() {
        return this.securityLevel;
    }

    public synchronized void setSSLConfigurationName(String name) {
        this.sSLConfigName = name;
    }

    public synchronized String getSSLConfigurationName() {
        return this.sSLConfigName;
    }

    public synchronized void setKeyRecoveryPassword(String password) {
        this.keyRecoveryPassword = password;
    }

    public synchronized String getKeyRecoveryPassword() {
        return this.keyRecoveryPassword;
    }

    public synchronized void setLogFile(String logFile) throws SQLException {
        this.setLogStream(logFile);
    }

    private synchronized void setLogStream(String logFile) throws SQLException {
        if (logFile == null || logFile.equals("")) {
            this.logStream = null;
        } else {
            try {
                File lf = new File(logFile);
                lf.delete();
                this.logStream = new PrintWriter(new FileOutputStream(lf, true), true);
            }
            catch (Exception e) {
                throw new SQLException("Invalid log file name: " + logFile, "S1000");
            }
        }
    }

    public synchronized int getDefaultTransactionIsolation() {
        return this.isolationLevel;
    }

    public synchronized void setDefaultTransactionIsolation(int level) {
        this.isolationLevel = level;
    }

    private void parseExtension(String ext) {
        int pos = ext.indexOf(":");
        if (pos == -1) {
            this.eventClass = ext;
        } else {
            this.eventClass = ext.substring(0, pos);
            if ((pos = (ext = ext.substring(pos + 1)).indexOf(":")) == -1) {
                if (ext.equalsIgnoreCase("false")) {
                    this.nodelay = false;
                }
            } else {
                if (ext.substring(0, pos).equalsIgnoreCase("false")) {
                    this.nodelay = false;
                }
                if ((ext = ext.substring(pos + 1)).equalsIgnoreCase("true")) {
                    this.securityLevel = 10;
                }
            }
        }
    }

    private String parseCredentials(String str) {
        int pos1 = str.indexOf("?");
        if (pos1 == -1) {
            return str;
        }
        String cred = str.substring(pos1 + 1);
        int pos = cred.indexOf("username=");
        if (pos != -1) {
            if ((pos = (cred = cred.substring(pos + 9)).indexOf("&password=")) != -1) {
                this.user = cred.substring(0, pos);
                this.password = cred.substring(pos + 10);
            } else {
                this.user = cred;
            }
        }
        return str.substring(0, pos1);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Not supported.");
    }

    static {
        if (driver == null) {
            try {
                driver = (CacheDriver)Class.forName("com.intersys.jdbc.CacheDriver").newInstance();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

