/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheBufferUtils;
import com.intersys.jdbc.CacheList;
import com.intersys.jdbc.CacheListReader;
import com.intersys.jdbc.CacheMsgHeader;
import com.intersys.jdbc.ConnectionInfo;
import com.intersys.jdbc.ListItem;
import com.intersys.jdbc.SysList;
import java.sql.SQLException;

public class CacheBufferRO
extends CacheListReader {
    CacheMsgHeader Header;
    int maxFieldSize;
    boolean NewRow;

    CacheBufferRO(CacheBufferRO list, CacheMsgHeader inHeader, String inLocale, boolean fd) {
        super(inLocale);
        this.Header = inHeader;
        if (fd && list != null && !list.NewRow) {
            int carryOver = list.m_item.listBufferEnd - list.m_item.nextOffset;
            this.m_item = new ListItem(new byte[inHeader.getMessageLength() + carryOver]);
            CacheBufferUtils.copyByteArray(list.m_item.buffer, list.m_item.nextOffset, this.m_item.buffer, 0, carryOver);
            this.m_item.listBufferEnd = carryOver;
            this.setOffset(this.m_item.listBufferEnd);
            return;
        }
        this.m_item = new ListItem(new byte[inHeader.getMessageLength()]);
        this.m_item.listBufferEnd = 0;
        this.setOffset(0);
    }

    CacheBufferRO(CacheBufferRO list, CacheBufferRO newList) {
        super(newList.m_locale);
        this.Header = newList.Header;
        int carryOver = list.m_item.listBufferEnd - list.m_item.nextOffset;
        int newSize = newList.Header.getMessageLength() + carryOver;
        this.m_item = new ListItem(new byte[newSize]);
        CacheBufferUtils.copyByteArray(list.m_item.buffer, list.m_item.nextOffset, this.m_item.buffer, 0, carryOver);
        CacheBufferUtils.copyByteArray(newList.m_item.buffer, newList.m_item.nextOffset, this.m_item.buffer, carryOver, newSize - carryOver);
        this.setOffset(carryOver);
        this.m_item.listBufferEnd = newSize;
    }

    CacheBufferRO(CacheBufferRO list, int numItems) {
        super(list.m_locale);
        this.Header = list.Header;
        ListItem li = list.m_item.clone();
        int startingOffset = list.getOffset();
        for (int i = 0; i < numItems; ++i) {
            li.nextOffset = CacheList.getListElement(li.nextOffset, li);
        }
        int newSize = li.nextOffset - startingOffset;
        this.m_item = new ListItem(new byte[newSize]);
        CacheBufferUtils.copyByteArray(list.m_item.buffer, list.m_item.nextOffset, this.m_item.buffer, 0, newSize);
        this.m_item.listBufferEnd = newSize;
    }

    void setBuffer(CacheMsgHeader inHeader) {
        this.m_item.buffer = new byte[inHeader.getMessageLength()];
        this.Header = inHeader;
        this.clearList();
    }

    void growBuffer(CacheMsgHeader inHeader) {
        this.m_item.buffer = CacheBufferUtils.growByteArray(this.m_item.buffer, 0, inHeader.getMessageLength());
        this.Header = inHeader;
    }

    void ensureBuffer(int needed) {
        needed = needed + (needed >> 4) + this.BUCKET_SIZE - 1 & ~(this.BUCKET_SIZE - 1);
        this.BUCKET_SIZE *= 2;
        byte[] a = new byte[needed];
        CacheBufferUtils.copyByteArray(this.m_item.buffer, 0, a, 0, this.m_item.listBufferEnd);
        this.m_item.buffer = a;
    }

    public SysList getSysList(ConnectionInfo ci) {
        SysList sl = new SysList(this.m_item.buffer);
        sl.setConnectionInfo(ci);
        return sl;
    }

    public int getID() {
        return this.Header.getStatementID();
    }

    byte[] getRawByteArray(int len) {
        byte[] ba = CacheBufferUtils.copyByteArray(this.m_item.buffer, this.m_item.nextOffset, len);
        this.m_item.nextOffset += len;
        return ba;
    }

    int getRaw2ByteInt(int offset) {
        int temp = CacheBufferUtils.get2ByteIntRaw(this.m_item.buffer, offset);
        this.m_item.nextOffset = offset + 2;
        return temp;
    }

    int getRaw2ByteInt() {
        int temp = CacheBufferUtils.get2ByteIntRaw(this.m_item.buffer, this.m_item.nextOffset);
        this.m_item.nextOffset += 2;
        return temp;
    }

    int getRaw4ByteInt(int offset) {
        int temp = CacheBufferUtils.get4ByteIntRaw(this.m_item.buffer, offset);
        this.m_item.nextOffset = offset + 4;
        return temp;
    }

    int getRaw4ByteInt() {
        int temp = CacheBufferUtils.get4ByteIntRaw(this.m_item.buffer, this.m_item.nextOffset);
        this.m_item.nextOffset += 4;
        return temp;
    }

    boolean isUndefined() {
        return this.m_item.type == -1;
    }

    void nextUnlessUndefined() throws SQLException {
        this.next();
        if (this.isPastLastItem()) {
            throw new NoMoreDataException();
        }
        if (this.isUndefined()) {
            throw new SQLException("Output/Default parameter not assigned a value.", "S1000");
        }
    }

    public String readServerEncoding() throws SQLException {
        String encoding = this.getString();
        if (encoding.equalsIgnoreCase("UNICODE") || encoding.equalsIgnoreCase("LATIN1")) {
            return "ISO8859_1";
        }
        if (encoding.equalsIgnoreCase("LATIN7")) {
            return "ISO8859_13";
        }
        if (encoding.equalsIgnoreCase("LATIN9")) {
            return "Latin9";
        }
        if (encoding.equalsIgnoreCase("LATINA")) {
            return "ISO8859_6";
        }
        if (encoding.equalsIgnoreCase("LATINT")) {
            return "ISO8859_11";
        }
        if (encoding.equalsIgnoreCase("LATIN2")) {
            return "ISO8859_2";
        }
        if (encoding.equalsIgnoreCase("LATIN3")) {
            return "ISO8859_3";
        }
        if (encoding.equalsIgnoreCase("LATINC")) {
            return "ISO8859_5";
        }
        if (encoding.equalsIgnoreCase("LATING")) {
            return "ISO8859_7";
        }
        if (encoding.equalsIgnoreCase("LATINH")) {
            return "ISO8859_8";
        }
        if (encoding.equalsIgnoreCase("CP866")) {
            return "Cp866";
        }
        if (encoding.equalsIgnoreCase("CP874")) {
            return "Cp874";
        }
        if (encoding.equalsIgnoreCase("CP1250")) {
            return "Cp1250";
        }
        if (encoding.equalsIgnoreCase("CP1251")) {
            return "Cp1251";
        }
        if (encoding.equalsIgnoreCase("CP1252")) {
            return "Cp1252";
        }
        if (encoding.equalsIgnoreCase("CP1253")) {
            return "Cp1253";
        }
        if (encoding.equalsIgnoreCase("CP1255")) {
            return "Cp1255";
        }
        if (encoding.equalsIgnoreCase("CP1256")) {
            return "Cp1256";
        }
        if (encoding.equalsIgnoreCase("CP1257")) {
            return "Cp1257";
        }
        return encoding;
    }

    CacheListReader getOutputParameterList(int begin, boolean addNull) {
        int len = this.m_item.nextOffset - begin;
        int offset = addNull ? 3 : 0;
        byte[] ba = new byte[len + offset];
        if (addNull) {
            byte[] quoteQuote = new byte[]{3, 1, 0};
            CacheBufferUtils.copyByteArray(quoteQuote, 0, ba, 0, 3);
        }
        CacheBufferUtils.copyByteArray(this.m_item.buffer, begin, ba, offset, len);
        return new CacheListReader(new ListItem(ba, len + offset), this.m_locale);
    }

    int ByteArrayItemLength(int offset) {
        ListItem li = this.m_item.clone();
        li.nextOffset = CacheList.getListElement(offset, li);
        if (li.dataLength == 1 & li.buffer[li.dataOffset] == 0) {
            return 0;
        }
        return li.dataLength;
    }

    public Object GetParameter(String type) throws SQLException {
        Object temp = null;
        switch (type) {
            case "String": {
                temp = this.getString();
                break;
            }
            case "Int": {
                temp = this.getInt();
                break;
            }
            case "Long": {
                temp = this.getLong();
                break;
            }
            case "Short": {
                temp = this.getShort();
                break;
            }
            case "Double": {
                temp = this.getDouble();
                break;
            }
            case "Float": {
                temp = Float.valueOf(this.getFloat());
                break;
            }
            case "Boolean": {
                temp = this.getBoolean();
                break;
            }
            default: {
                return null;
            }
        }
        if (this.isNull()) {
            return null;
        }
        return temp;
    }

    static class NoMoreDataException
    extends SQLException {
        NoMoreDataException() {
            super("Invalid column number", "S1002");
        }
    }
}

