/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.views;

import com.dbeaver.db.mongodb.MGUtils;
import com.dbeaver.db.mongodb.MongoDBMessages;
import com.mongodb.MongoCredential;
import java.util.Objects;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.DatabaseNativeAuthModelConfigurator;
import org.jkiss.utils.CommonUtils;

public class AuthModelMongoDBConfigurator
extends DatabaseNativeAuthModelConfigurator {
    private Combo mechanismCombo;
    private Text userSourceText;

    public void createControl(@NotNull Composite parent, DBAAuthModel<?> object, @NotNull Runnable propertyChangeListener) {
        this.mechanismCombo = UIUtils.createLabelCombo((Composite)parent, (String)MongoDBMessages.connection_page_label_combo_mechanism, (int)12);
        this.mechanismCombo.add("NONE");
        this.mechanismCombo.add(MongoCredential.SCRAM_SHA_1_MECHANISM);
        this.mechanismCombo.add(MongoCredential.SCRAM_SHA_256_MECHANISM);
        this.mechanismCombo.add("MONGODB-CR");
        this.mechanismCombo.add(MongoCredential.PLAIN_MECHANISM);
        this.mechanismCombo.add(MongoCredential.GSSAPI_MECHANISM);
        this.mechanismCombo.add(MongoCredential.MONGODB_X509_MECHANISM);
        this.mechanismCombo.setLayoutData((Object)new GridData(32));
        this.mechanismCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuthModelMongoDBConfigurator.this.enableAuthFields();
            }
        });
        this.userSourceText = UIUtils.createLabelText((Composite)parent, (String)MongoDBMessages.connection_page_label_text_source, (String)"", (int)2048);
        this.userSourceText.setToolTipText(MongoDBMessages.connection_page_tool_tip_text_user_source_database);
        super.createControl(parent, object, propertyChangeListener);
    }

    public void loadSettings(@NotNull DBPDataSourceContainer dataSource) {
        String authSource;
        String auth;
        super.loadSettings(dataSource);
        DBPConnectionConfiguration configuration = dataSource.getConnectionConfiguration();
        if (this.mechanismCombo != null) {
            String mechanism = configuration.getProviderProperty("authMechanism");
            if (mechanism == null) {
                mechanism = configuration.getProviderProperty("@dbeaver-mongo-cred-mechanism@");
            }
            if (mechanism == null) {
                mechanism = "NONE";
            }
            this.mechanismCombo.setText(mechanism);
        }
        if ((auth = configuration.getProviderProperty("@dbeaver-auth@0")) != null) {
            String[] authTokens = MGUtils.extractAuthInfo((String)auth);
            this.usernameText.setText(authTokens[0]);
            this.userSourceText.setText(authTokens[1]);
            this.passwordText.setText(authTokens[2]);
        }
        if ((authSource = configuration.getProviderProperty("authSource")) == null) {
            authSource = configuration.getProviderProperty("@dbeaver-auth-source@");
        }
        this.userSourceText.setText(Objects.requireNonNullElse(authSource, "admin"));
        this.enableAuthFields();
    }

    public void saveSettings(@NotNull DBPDataSourceContainer dataSource) {
        super.saveSettings(dataSource);
        DBPConnectionConfiguration configuration = dataSource.getConnectionConfiguration();
        configuration.setProviderProperty("authMechanism", this.mechanismCombo.getText());
        configuration.setProviderProperty("authSource", this.userSourceText.getText());
    }

    public void resetSettings(@NotNull DBPDataSourceContainer configuration) {
    }

    public boolean isComplete() {
        return this.mechanismCombo.getSelectionIndex() >= 0 && CommonUtils.isNotEmpty((String)this.userSourceText.getText());
    }

    private void enableAuthFields() {
        boolean authEnabled = this.mechanismCombo.getSelectionIndex() > 0;
        this.usernameText.setEnabled(authEnabled);
        this.userSourceText.setEnabled(authEnabled);
        this.passwordText.setEnabled(authEnabled);
    }
}

