/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import oracle.xml.parser.v2.XMLDOMConfiguration;
import oracle.xml.parser.v2.XMLDOMException;
import oracle.xml.parser.v2.XMLDOMImplementation;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLPrintDriver;
import oracle.xml.util.XMLError;
import oracle.xml.util.XMLUtil;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSException;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.w3c.dom.ls.LSSerializerFilter;

public class XMLLSSerializer
implements LSSerializer {
    private DOMConfiguration config = new XMLDOMConfiguration();
    private String newLine = null;
    private LSSerializerFilter filter = null;
    private static final XMLError xerr = new XMLError();

    @Override
    public DOMConfiguration getDomConfig() {
        return this.config;
    }

    public DOMConfiguration getConfig() {
        return this.config;
    }

    @Override
    public String getNewLine() {
        return this.newLine;
    }

    @Override
    public void setNewLine(String string) {
        if (string.equals("\n") || string.equals("\r") || string.equals("\r\n")) {
            this.newLine = string;
        }
    }

    @Override
    public LSSerializerFilter getFilter() {
        return this.filter;
    }

    @Override
    public void setFilter(LSSerializerFilter lSSerializerFilter) {
        this.filter = lSSerializerFilter;
    }

    @Override
    public boolean write(Node node, LSOutput lSOutput) throws LSException {
        XMLPrintDriver xMLPrintDriver;
        Writer writer = lSOutput.getCharacterStream();
        OutputStream outputStream = lSOutput.getByteStream();
        String string = lSOutput.getSystemId();
        String string2 = lSOutput.getEncoding();
        boolean bl = (Boolean)this.config.getParameter("xml-declaration");
        if (writer != null) {
            xMLPrintDriver = new XMLPrintDriver(writer);
        } else if (outputStream != null) {
            xMLPrintDriver = new XMLPrintDriver(outputStream);
        } else {
            if (string != null) {
                String string3 = xerr.getMessage0(21031);
                throw new XMLDOMException(9, string3);
            }
            return false;
        }
        if (node == null) {
            return true;
        }
        try {
            if (string2 != null) {
                xMLPrintDriver.setEncoding(string2);
            }
            if (this.newLine != null) {
                xMLPrintDriver.setEOLChars(this.newLine);
            }
            if (this.filter != null) {
                xMLPrintDriver.setFilter(this.filter);
            }
            xMLPrintDriver.setConfig(this.config);
            if (!(node instanceof XMLNode)) {
                node = XMLUtil.getXMLNodeFromNode(node);
            }
            if (node instanceof XMLDocument) {
                xMLPrintDriver.printDocument((XMLDocument)node);
            } else {
                xMLPrintDriver.printNode((XMLNode)node);
            }
            xMLPrintDriver.flush();
        }
        catch (IOException iOException) {
            String string4 = xerr.getMessage0(21032);
            throw new LSException(82, string4);
        }
        return true;
    }

    @Override
    public boolean writeToURI(Node node, String string) throws LSException {
        LSOutput lSOutput = new XMLDOMImplementation().createLSOutput();
        lSOutput.setSystemId(string);
        return this.write(node, lSOutput);
    }

    @Override
    public String writeToString(Node node) throws DOMException, LSException {
        LSOutput lSOutput = new XMLDOMImplementation().createLSOutput();
        lSOutput.setByteStream(new ByteArrayOutputStream());
        boolean bl = this.write(node, lSOutput);
        if (!bl) {
            String string = xerr.getMessage0(21033);
            throw new XMLDOMException(2, string);
        }
        return lSOutput.getByteStream().toString();
    }
}

