/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb2.model;

import com.dbeaver.ee.influxdb2.exec.Influx2ExecutionContext;
import com.dbeaver.ee.influxdb2.model.Influx2DataSource;
import com.dbeaver.ee.influxdb2.model.Influx2Measurement;
import com.dbeaver.ee.influxdb2.model.Influx2RetentionPolicy;
import com.influxdb.client.InfluxDBClient;
import com.influxdb.client.domain.BucketRetentionRules;
import com.influxdb.query.FluxRecord;
import com.influxdb.query.FluxTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.AbstractObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.utils.CommonUtils;

public class Influx2Database
implements DBSCatalog,
DBPSaveableObject,
DBPSystemObject,
DBPRefreshableObject {
    private static final Log log = Log.getLog(Influx2Database.class);
    private final Influx2DataSource dataSource;
    private final String dbName;
    private boolean persisted;
    private final MeasurementCache measurementCache = new MeasurementCache();
    private final RetentionPolicyCache retentionPolicyCache = new RetentionPolicyCache();

    public Influx2Database(Influx2DataSource dataSource, String dbName) {
        this.dataSource = dataSource;
        this.dbName = dbName;
        this.persisted = true;
    }

    @NotNull
    public Influx2DataSource getDataSource() {
        return this.dataSource;
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.dbName;
    }

    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.dataSource.getContainer();
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public List<Influx2Measurement> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getMeasurements(monitor);
    }

    public Influx2Measurement getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return (Influx2Measurement)DBUtils.findObject((Collection)this.getChildren(monitor), (String)childName);
    }

    @NotNull
    public Class<Influx2Measurement> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return Influx2Measurement.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
    }

    public String toString() {
        return this.getName();
    }

    public boolean isSystem() {
        return this.dbName.equals("_internal");
    }

    @Association
    public List<Influx2Measurement> getMeasurements(DBRProgressMonitor monitor) throws DBException {
        return this.measurementCache.getAllObjects(monitor, this);
    }

    @Association
    public List<Influx2RetentionPolicy> getRetentionPolicies(DBRProgressMonitor monitor) throws DBException {
        return this.retentionPolicyCache.getAllObjects(monitor, this);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.measurementCache.clearCache();
        this.retentionPolicyCache.clearCache();
        return this;
    }

    class MeasurementCache
    extends AbstractObjectCache<Influx2Database, Influx2Measurement> {
        MeasurementCache() {
        }

        @NotNull
        public List<Influx2Measurement> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable Influx2Database database) throws DBException {
            if (!this.isFullyCached()) {
                ArrayList<Influx2Measurement> measurements = new ArrayList<Influx2Measurement>();
                InfluxDBClient influxDB = ((Influx2ExecutionContext)Influx2Database.this.getDataSource().getDefaultContext(monitor, true)).getClient();
                List dbListResult = influxDB.getQueryApi().query("import \"influxdata/influxdb/schema\" schema.measurements(bucket: \"" + Influx2Database.this.getName() + "\")");
                for (FluxTable result : dbListResult) {
                    for (FluxRecord dbObj : CommonUtils.safeList((List)result.getRecords())) {
                        Object dbName = dbObj.getValue();
                        measurements.add(new Influx2Measurement(database, CommonUtils.toString((Object)dbName)));
                    }
                }
                measurements.sort(DBUtils.nameComparator());
                this.setCache(measurements);
            }
            return this.getCachedObjects();
        }

        public Influx2Measurement getObject(@NotNull DBRProgressMonitor monitor, @Nullable Influx2Database database, @NotNull String name) throws DBException {
            return (Influx2Measurement)DBUtils.findObject(this.getAllObjects(monitor, database), (String)name);
        }
    }

    class RetentionPolicyCache
    extends AbstractObjectCache<Influx2Database, Influx2RetentionPolicy> {
        RetentionPolicyCache() {
        }

        @NotNull
        public List<Influx2RetentionPolicy> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable Influx2Database database) throws DBException {
            if (!this.isFullyCached()) {
                ArrayList<Influx2RetentionPolicy> retentionPolicies = new ArrayList<Influx2RetentionPolicy>();
                InfluxDBClient influxDB = ((Influx2ExecutionContext)Influx2Database.this.getDataSource().getDefaultContext(monitor, true)).getClient();
                List dbListResult = influxDB.getBucketsApi().findBucketByName(Influx2Database.this.getName()).getRetentionRules();
                for (BucketRetentionRules result : dbListResult) {
                    String type = result.getType().getValue();
                    Integer rpDuration = result.getEverySeconds();
                    Long shardGroupDuration = result.getShardGroupDurationSeconds();
                    retentionPolicies.add(new Influx2RetentionPolicy(database, type, rpDuration, shardGroupDuration));
                }
                retentionPolicies.sort(DBUtils.nameComparator());
                this.setCache(retentionPolicies);
            }
            return this.getCachedObjects();
        }

        public Influx2RetentionPolicy getObject(@NotNull DBRProgressMonitor monitor, @Nullable Influx2Database database, @NotNull String name) throws DBException {
            return (Influx2RetentionPolicy)DBUtils.findObject(this.getAllObjects(monitor, database), (String)name);
        }
    }
}

