/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.influxdb2.exec;

import com.dbeaver.ee.influxdb2.exec.Influx2ResultSet;
import com.dbeaver.ee.influxdb2.exec.Influx2Session;
import com.dbeaver.ee.influxdb2.model.Influx2Database;
import com.influxdb.query.FluxTable;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRBlockingObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public abstract class Influx2BaseStatement
implements DBCStatement {
    private static final Log log = Log.getLog(Influx2BaseStatement.class);
    protected final Influx2Session session;
    protected final Influx2Database database;
    protected final String query;
    protected DBCExecutionSource source;
    protected List<FluxTable> queryResult;
    protected int curResultsIndex;
    protected int curSeriesIndex;
    protected Throwable executeError;
    protected int offset;
    protected int limit;
    private String tableName;

    protected Influx2BaseStatement(Influx2Session session, Influx2Database database, String query) {
        this.session = session;
        this.database = database;
        this.query = query;
        if (session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementOpen((DBCStatement)this);
        }
    }

    public Influx2Database getCurrentDatabase() {
        return this.database != null ? this.database : this.getSession().getExecutionContext().getDefaultCatalog();
    }

    @NotNull
    public Influx2Session getSession() {
        return this.session;
    }

    public String getQueryString() {
        return this.query;
    }

    public DBCExecutionSource getStatementSource() {
        return this.source;
    }

    public void setStatementSource(@Nullable DBCExecutionSource source) {
        this.source = source;
    }

    public void addToBatch() throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    public int[] executeStatementBatch() throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    public Influx2ResultSet openResultSet() throws DBCException {
        return new Influx2ResultSet(this, this.queryResult.get(this.curResultsIndex));
    }

    public DBCResultSet openGeneratedKeysResultSet() throws DBCException {
        throw new DBCFeatureNotSupportedException();
    }

    public long getUpdateRowCount() {
        return -1L;
    }

    public boolean nextResults() throws DBCException {
        FluxTable table;
        if (this.queryResult.size() - 1 > this.curResultsIndex && (table = this.queryResult.get(this.curResultsIndex)) != null) {
            ++this.curResultsIndex;
            return true;
        }
        return false;
    }

    public void close() {
        this.queryResult = null;
        if (this.session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementClose((DBCStatement)this, this.getUpdateRowCount());
        }
    }

    public void setLimit(long offset, long limit) throws DBCException {
        this.offset = (int)offset;
        this.limit = (int)limit;
    }

    @Nullable
    public Throwable[] getStatementWarnings() throws DBCException {
        return null;
    }

    public void setStatementTimeout(int timeout) throws DBCException {
    }

    public void setResultsFetchSize(int fetchSize) throws DBCException {
    }

    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) throws DBException {
        if (blockThread == null) {
            throw new DBCFeatureNotSupportedException();
        }
        blockThread.interrupt();
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLimit() {
        return this.limit;
    }

    protected DBCException handleExecuteError(Throwable ex) {
        this.executeError = ex;
        if (ex instanceof DBCException) {
            return (DBCException)ex;
        }
        return new DBCException(ex, (DBCExecutionContext)this.session.getExecutionContext());
    }

    protected void beforeExecute() {
        this.executeError = null;
        if (this.session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteBegin((DBCStatement)this);
        }
        this.startBlock();
    }

    protected void afterExecute() {
        this.endBlock();
        if (this.session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteEnd((DBCStatement)this, this.getUpdateRowCount(), this.executeError);
        }
    }

    protected void startBlock() {
        this.session.getProgressMonitor().startBlock((DBRBlockingObject)this, this.getClass().getSimpleName());
    }

    protected void endBlock() {
        this.session.getProgressMonitor().endBlock();
    }

    protected void setTableName(String tableName) {
        this.tableName = tableName;
    }

    protected void setQueryResult(List<FluxTable> queryResult) {
        this.queryResult = queryResult;
    }
}

