/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.lm;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Date;
import java.util.logging.Logger;
import org.jkiss.lm.LMEncryption;
import org.jkiss.lm.LMEnvironment;
import org.jkiss.lm.LMException;
import org.jkiss.lm.LMKeyProvider;
import org.jkiss.lm.LMLicense;
import org.jkiss.lm.LMLicenseManager;
import org.jkiss.lm.LMLicenseType;
import org.jkiss.lm.LMProduct;
import org.jkiss.lm.LMProductType;
import org.jkiss.lm.LMSubscription;
import org.jkiss.lm.LMSubscriptionPeriod;
import org.jkiss.lm.LMUtils;
import org.jkiss.utils.Base64;

public class LMMain {
    private static final Logger log = Logger.getLogger("LMMain");
    private static final LMProduct TEST_PRODUCT = new LMProduct("dbeaver-ee", "DB", "DBeaver Enterprise", "DBeaver Enterprise Edition", "4.1", LMProductType.DESKTOP, new Date(), new String[0]);

    public static void main(String[] args) throws Exception {
        System.out.println("LM 2.0");
        if (args.length > 0 && args[0].equals("gen-keys")) {
            System.out.println("Test key generation");
            LMMain.generateKeyPair();
        } else if (args.length > 0 && args[0].equals("encrypt-license")) {
            System.out.println("Encrypt license");
            LMMain.encryptLicense();
        } else if (args.length > 0 && args[0].equals("decrypt-license")) {
            System.out.println("Decrypt license");
            LMMain.decryptLicense();
        } else if (args.length > 0 && args[0].equals("import-license")) {
            System.out.println("Import license");
            LMMain.importLicense();
        } else {
            System.out.println("Test license generation");
            LMMain.generateLicense();
        }
    }

    private static void encryptLicense() throws Exception {
        PrivateKey privateKey = LMMain.readPrivateKey();
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        String licenseID = LMUtils.generateLicenseId(TEST_PRODUCT);
        System.out.println("License ID: " + licenseID);
        System.out.println("Product ID (" + TEST_PRODUCT.getId() + "):");
        String productID = in.readLine();
        if (productID.isEmpty()) {
            productID = TEST_PRODUCT.getId();
        }
        System.out.println("Product version (" + TEST_PRODUCT.getVersion() + "):");
        String productVersion = in.readLine();
        if (productVersion.isEmpty()) {
            productVersion = TEST_PRODUCT.getVersion();
        }
        System.out.println("Owner ID (1):");
        String ownerID = in.readLine();
        if (ownerID.isEmpty()) {
            ownerID = "1";
        }
        System.out.println("Owner company (JKISS):");
        String ownerCompany = in.readLine();
        if (ownerCompany.isEmpty()) {
            ownerCompany = "JKISS";
        }
        System.out.println("Owner name:");
        String ownerName = in.readLine();
        System.out.println("Owner email:");
        String ownerEmail = in.readLine();
        LMLicense license = new LMLicense(licenseID, LMLicenseType.YEAR_UPDATE, new Date(), new Date(), null, 0L, productID, productVersion, ownerID, ownerCompany, ownerName, ownerEmail);
        byte[] licenseData = license.getData();
        byte[] licenseEncrypted = LMEncryption.encrypt(licenseData, privateKey);
        System.out.println("--- LICENSE ---");
        System.out.println(Base64.splitLines((String)Base64.encode((byte[])licenseEncrypted), (int)76));
    }

    private static void decryptLicense() throws Exception {
        PublicKey publicKey = LMMain.readPublicKey();
        System.out.println("License:");
        byte[] encryptedLicense = LMUtils.readEncryptedString(System.in);
        LMLicense license = new LMLicense(encryptedLicense, publicKey);
        System.out.println(license);
    }

    private static void importLicense() throws Exception {
        LMEnvironment lmEnvironment = new LMEnvironment();
        lmEnvironment.setProductPurchaseURL("");
        lmEnvironment.setArchiveURL("");
        final PrivateKey privateKey = LMMain.readPrivateKey();
        final PublicKey publicKey = LMMain.readPublicKey();
        System.out.println("License:");
        byte[] encryptedLicense = LMUtils.readEncryptedString(System.in);
        LMLicenseManager lm = new LMLicenseManager(lmEnvironment, new LMKeyProvider(){

            @Override
            public Key getEncryptionKey(LMProduct product) {
                return privateKey;
            }

            @Override
            public Key getDecryptionKey(LMProduct product) {
                return publicKey;
            }
        }, null);
        lm.importLicense(TEST_PRODUCT, encryptedLicense);
    }

    private static void generateKeyPair() throws LMException {
        KeyPair keyPair = LMEncryption.generateKeyPair(2048);
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        System.out.println("--- PUBLIC KEY ---");
        System.out.println(Base64.splitLines((String)Base64.encode((byte[])publicKey.getEncoded()), (int)76));
        System.out.println("--- PRIVATE KEY ---");
        System.out.println(Base64.splitLines((String)Base64.encode((byte[])privateKey.getEncoded()), (int)76));
    }

    private static void generateLicense() throws LMException {
        System.out.println("Gen keys");
        KeyPair keyPair = LMEncryption.generateKeyPair(2048);
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        System.out.println("Gen Test license");
        LMLicense license = new LMLicense("JL-0FB16-000A2GC", LMLicenseType.YEAR_UPDATE, new Date(), new Date(), null, 0L, TEST_PRODUCT.getId(), TEST_PRODUCT.getVersion(), "123123", "JKISS", "Serge Rider", "serge@dbeaver.com");
        byte[] data = license.getData();
        byte[] encrypted = LMEncryption.encrypt(data, privateKey);
        String encodedBase64 = Base64.splitLines((String)Base64.encode((byte[])encrypted), (int)76);
        byte[] encodedBinary = Base64.decode((String)encodedBase64);
        LMLicense licenseCopy = new LMLicense(encodedBinary, publicKey);
        System.out.println(licenseCopy);
        System.out.println("Gen subscription");
        LMSubscription subscription = new LMSubscription("XXX-123", LMSubscriptionPeriod.MONTH, new Date(), new Date(), 1, true);
        byte[] subData = LMEncryption.encrypt(subscription.getData(), privateKey);
        String subBase64 = Base64.splitLines((String)Base64.encode((byte[])subData), (int)76);
        byte[] subBinary = Base64.decode((String)subBase64);
        LMSubscription subCopy = new LMSubscription(subBinary, publicKey);
        System.out.println(subCopy);
    }

    private static PrivateKey readPrivateKey() throws LMException {
        File keyFile = new File(new File(System.getProperty("user.home"), ".jkiss-lm"), "private-key.txt");
        if (!keyFile.exists()) {
            throw new LMException("Cannot find private key file (" + keyFile.getAbsolutePath() + ")");
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileInputStream keyStream = new FileInputStream(keyFile);){
                byte[] privateKeyData = LMUtils.readEncryptedString(keyStream);
                return LMEncryption.generatePrivateKey(privateKeyData);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new LMException(e);
        }
    }

    private static PublicKey readPublicKey() throws LMException {
        File keyFile = new File(new File(System.getProperty("user.home"), ".jkiss-lm"), "public-key.txt");
        if (!keyFile.exists()) {
            throw new LMException("Cannot find public key file (" + keyFile.getAbsolutePath() + ")");
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileInputStream keyStream = new FileInputStream(keyFile);){
                byte[] keyData = LMUtils.readEncryptedString(keyStream);
                return LMEncryption.generatePublicKey(keyData);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new LMException(e);
        }
    }
}

