/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.parser.common.grammar;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.parser.common.grammar.AlternativeExpression;
import org.jkiss.dbeaver.parser.common.grammar.CharactersExpression;
import org.jkiss.dbeaver.parser.common.grammar.NumberExpression;
import org.jkiss.dbeaver.parser.common.grammar.RegexExpression;
import org.jkiss.dbeaver.parser.common.grammar.RuleCallExpression;
import org.jkiss.dbeaver.parser.common.grammar.RuleExpression;
import org.jkiss.dbeaver.parser.common.grammar.SequenceExpression;

public class ExpressionFactory {
    private ExpressionFactory() {
    }

    @NotNull
    public static SequenceExpression seq(Object ... exprs) {
        return new SequenceExpression(ExpressionFactory.makeCollection(exprs));
    }

    @NotNull
    public static RuleExpression call(@NotNull String ruleName) {
        return new RuleCallExpression(ruleName);
    }

    @NotNull
    public static RuleExpression alt(Object ... exprs) {
        return new AlternativeExpression(ExpressionFactory.makeCollection(exprs));
    }

    @NotNull
    public static RuleExpression num(int min, int max, Object ... exprs) {
        return new NumberExpression(ExpressionFactory.seq(exprs), min, max);
    }

    @NotNull
    public static RuleExpression optional(Object ... exprs) {
        return ExpressionFactory.num(0, 1, exprs);
    }

    @NotNull
    public static RuleExpression zeroOrMore(Object ... exprs) {
        return ExpressionFactory.num(0, Integer.MAX_VALUE, exprs);
    }

    @NotNull
    public static RuleExpression oneOrMore(Object ... exprs) {
        return ExpressionFactory.num(1, Integer.MAX_VALUE, exprs);
    }

    @NotNull
    public static RegexExpression regex(@NotNull String regex) {
        return new RegexExpression(regex);
    }

    private static RuleExpression makeExpression(@NotNull Object expr) {
        if (expr instanceof String) {
            return new CharactersExpression((String)expr);
        }
        if (expr instanceof RuleExpression) {
            return (RuleExpression)expr;
        }
        throw new IllegalArgumentException("Unsupported expression: " + expr);
    }

    @NotNull
    private static List<RuleExpression> makeCollection(Object ... exprs) {
        return Arrays.stream(exprs).map(ExpressionFactory::makeExpression).collect(Collectors.toList());
    }

    public static class E
    extends ExpressionFactory {
        private E() {
        }
    }
}

