/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPAuthModelDescriptor;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.ui.dialogs.connection.AuthModelSelector;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.utils.CommonUtils;

public abstract class ConnectionPageWithAuth
extends ConnectionPageAbstract {
    private static final Log log = Log.getLog(DataSourceProviderRegistry.class);
    private AuthModelSelector authModelSelector;

    protected void createAuthPanel(Composite parent, int hSpan) {
        this.createAuthPanel(parent, hSpan, null);
    }

    protected void createAuthPanel(Composite parent, int hSpan, Runnable panelExtender) {
        Assert.isLegal((boolean)this.isAuthEnabled());
        this.authModelSelector = new AuthModelSelector(parent, panelExtender, () -> this.getSite().updateButtons());
        this.authModelSelector.setLayoutData(new GridData(768));
        ((GridData)this.authModelSelector.getLayoutData()).horizontalSpan = hSpan;
    }

    protected Composite getAuthPanelComposite() {
        Assert.isLegal((boolean)this.isAuthEnabled());
        return this.authModelSelector.getAuthPanelComposite();
    }

    @Override
    public void loadSettings() {
        DBPAuthModelDescriptor amReplace;
        DBPAuthModelDescriptor selectedAuthModel;
        super.loadSettings();
        if (!this.isAuthEnabled()) {
            return;
        }
        DBPDataSourceContainer activeDataSource = this.getSite().getActiveDataSource();
        DBPConnectionConfiguration configuration = activeDataSource.getConnectionConfiguration();
        if (this.site.isNew() && CommonUtils.isEmpty((String)configuration.getUserName())) {
            configuration.setUserName(activeDataSource.getDriver().getDefaultUser());
        }
        if ((selectedAuthModel = activeDataSource.getDriver().getDataSourceProvider().detectConnectionAuthModel(activeDataSource.getDriver(), configuration)) != null && (amReplace = selectedAuthModel.getReplacedBy(activeDataSource.getDriver())) != null) {
            log.debug((Object)("Auth model '" + selectedAuthModel.getId() + "' was replaced by '" + amReplace.getId() + "'"));
            selectedAuthModel = amReplace;
            configuration.setAuthModelId(selectedAuthModel.getId());
        }
        this.authModelSelector.loadSettings(this.getSite().getActiveDataSource(), selectedAuthModel, this.getDefaultAuthModelId(activeDataSource));
    }

    @NotNull
    protected String getDefaultAuthModelId(DBPDataSourceContainer dataSource) {
        return "native";
    }

    @Override
    public void saveSettings(DBPDataSourceContainer dataSource) {
        super.saveSettings(dataSource);
        if (!this.isAuthEnabled()) {
            return;
        }
        DBPAuthModelDescriptor selectedAuthModel = this.authModelSelector.getSelectedAuthModel();
        dataSource.getConnectionConfiguration().setAuthModelId(selectedAuthModel == null ? null : selectedAuthModel.getId());
        this.authModelSelector.saveSettings(dataSource);
    }

    public boolean isComplete() {
        return !this.isAuthEnabled() || this.authModelSelector.isComplete();
    }

    protected boolean isAuthEnabled() {
        return true;
    }
}

