/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.query.dsl.functions;

import com.influxdb.query.dsl.Flux;
import com.influxdb.query.dsl.functions.AbstractFluxWithUpstream;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractParametrizedFlux
extends AbstractFluxWithUpstream {
    protected AbstractParametrizedFlux() {
    }

    protected AbstractParametrizedFlux(@Nonnull Flux source) {
        super(source);
    }

    @Override
    public void appendActual(@Nonnull Map<String, Object> parameters, @Nonnull StringBuilder builder) {
        super.appendActual(parameters, builder);
        StringBuilder operator = new StringBuilder();
        this.beforeAppendOperatorName(operator, parameters);
        operator.append(this.operatorName()).append("(");
        boolean wasAppended = false;
        for (String name : this.functionsParameters.keys()) {
            String propertyValue = this.functionsParameters.get(name, parameters);
            wasAppended = this.appendParameterTo(name, propertyValue, operator, wasAppended);
        }
        operator.append(")");
        this.appendDelimiter(builder);
        builder.append((CharSequence)operator);
    }

    @Nonnull
    protected abstract String operatorName();

    protected void beforeAppendOperatorName(@Nonnull StringBuilder operator, @Nonnull Map<String, Object> parameters) {
    }

    private boolean appendParameterTo(@Nonnull String operatorName, @Nullable String propertyValue, @Nonnull StringBuilder operator, boolean wasAppendProperty) {
        if (propertyValue == null) {
            return wasAppendProperty;
        }
        if (wasAppendProperty) {
            operator.append(", ");
        }
        operator.append(operatorName).append(this.functionsParameters.getDelimiter(operatorName)).append(propertyValue);
        return true;
    }
}

