/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.sqlite.crypt;

import com.dbeaver.db.sqlite.crypt.SQLiteCipherType;
import com.dbeaver.db.sqlite.crypt.SQLiteCryptParam;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.ext.sqlite.model.SQLiteDataSource;
import org.jkiss.dbeaver.ext.sqlite.model.SQLiteMetaModel;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class SQLiteCryptDataSource
extends SQLiteDataSource {
    public SQLiteCryptDataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container, SQLiteMetaModel metaModel) throws DBException {
        super(monitor, container, (GenericMetaModel)metaModel);
    }

    protected void initializeRemoteInstance(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.initializeRemoteInstance(monitor);
        Throwable throwable = null;
        Object var3_4 = null;
        try (JDBCSession session = this.getDefaultInstance().getDefaultContext(monitor, true).openSession(monitor, DBCExecutionPurpose.META, "Init cipher properties");){
            try {
                JDBCUtils.executeQuery((Connection)session, (String)"select * from sqlite_master", (Object[])new Object[0]);
            }
            catch (SQLException e) {
                throw new DBCException((Throwable)e, (DBCExecutionContext)session.getExecutionContext());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void initializeContextState(@NotNull DBRProgressMonitor monitor, @NotNull JDBCExecutionContext context, JDBCExecutionContext initFrom) throws DBException {
        super.initializeContextState(monitor, context, initFrom);
    }

    protected Properties getAllConnectionProperties(@NotNull DBRProgressMonitor monitor, JDBCExecutionContext context, String purpose, DBPConnectionConfiguration connectionInfo) throws DBCException {
        Properties props = super.getAllConnectionProperties(monitor, context, purpose, connectionInfo);
        props.remove("password");
        return props;
    }

    protected Map<String, String> getInternalConnectionProperties(DBRProgressMonitor monitor, DBPDriver driver, JDBCExecutionContext context, String purpose, DBPConnectionConfiguration connectionInfo) throws DBCException {
        SQLiteCipherType cipherType;
        String cipherName;
        HashMap<String, String> connectionProperties = super.getInternalConnectionProperties(monitor, driver, context, purpose, connectionInfo);
        if (CommonUtils.isEmpty((Map)connectionProperties)) {
            connectionProperties = new HashMap<String, String>();
        }
        if (!CommonUtils.isEmpty((String)(cipherName = connectionInfo.getProviderProperty("cipher"))) && (cipherType = (SQLiteCipherType)CommonUtils.valueOf(SQLiteCipherType.class, (String)cipherName, (Enum)SQLiteCipherType.CHACHA20)) != SQLiteCipherType.CUSTOM) {
            connectionProperties.put("cipher", cipherType.getCipherId());
        }
        SQLiteCryptParam[] sQLiteCryptParamArray = SQLiteCryptParam.values();
        int n = sQLiteCryptParamArray.length;
        int n2 = 0;
        while (n2 < n) {
            SQLiteCryptParam param = sQLiteCryptParamArray[n2];
            String paramValue = connectionInfo.getProviderProperty(param.name());
            if (paramValue != null) {
                connectionProperties.put(param.name(), paramValue);
            }
            ++n2;
        }
        connectionProperties.put("key", connectionInfo.getUserPassword());
        return connectionProperties;
    }
}

