/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc.importExport;

import com.exasol.jdbc.importExport.QueryManipulator;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QueryPattern {
    public static String getRegexQueryKey = "QueryType";
    public static String regexMainKey = "FirstPart";
    public static String regexSecureKey = "Secure";
    public static String regexFileType = "FileType";
    public static String regexErrorKey = "ErrorPart";
    public static String regexSecondaryKey = "SecondPart";
    public static String regexSecondarySecureKey = "SecondSecure";
    public static String CommentPattern = "(/\\*(.*)\\*/)";
    public static String CommentAndSpacePattern = "((\\s+" + CommentPattern + "*\\s*)|(\\s*" + CommentPattern + "*\\s+)|(\\s+))";
    static final Pattern ImpExpCSVFBVPattern = Pattern.compile("^\\s*" + CommentPattern + "*\\s*(?<" + getRegexQueryKey + ">IMPORT|EXPORT)[\\s(]+.+(?<" + regexMainKey + ">(?<" + regexSecureKey + ">LOCAL" + CommentAndSpacePattern + "(SECURE" + CommentAndSpacePattern + ")*)(?<" + regexFileType + ">CSV|FBV)+(" + CommentAndSpacePattern + "FILE" + CommentAndSpacePattern + "'([^']+?)')+).*$", 42);
    static final Pattern ImpErrCSVPattern = Pattern.compile("^\\s*" + CommentPattern + "*\\s*(?<" + getRegexQueryKey + ">IMPORT)[\\s(]+.+(?<" + regexMainKey + ">(?<" + regexSecureKey + ">LOCAL" + CommentAndSpacePattern + "(SECURE" + CommentAndSpacePattern + ")*)(?<" + regexFileType + ">CSV)+(" + CommentAndSpacePattern + "FILE" + CommentAndSpacePattern + "'([^']+?)')+).*" + "(?<" + regexErrorKey + ">ERRORS" + CommentAndSpacePattern + "INTO" + CommentAndSpacePattern + "(?<" + regexSecondaryKey + ">(?<" + regexSecondarySecureKey + ">LOCAL" + CommentAndSpacePattern + "(SECURE" + CommentAndSpacePattern + ")*)CSV+(" + CommentAndSpacePattern + "FILE" + CommentAndSpacePattern + "'([^']+?)')+)).*$", 42);
    private String sql;
    private LinkedHashMap<SQLPatterns, Pattern> patterns;
    private boolean isMatching;
    private Matcher match;
    private String[] Files;
    private String[] ErrFiles;
    private boolean CSV;
    private boolean Secure;
    private SQLPatterns patternType;
    private LinkedHashMap<String, String> commentsMap;

    public QueryPattern() {
        this.InitializeParams();
        this.addPattern();
    }

    private void InitializeParams() {
        this.patterns = new LinkedHashMap();
        this.commentsMap = new LinkedHashMap();
        this.sql = null;
        this.isMatching = false;
        this.match = null;
        this.Files = null;
        this.ErrFiles = null;
        this.CSV = true;
        this.Secure = false;
        this.patternType = SQLPatterns.None;
    }

    public void addPattern() {
        this.patterns.put(SQLPatterns.IMPORT_ERROR, ImpErrCSVPattern);
        this.patterns.put(SQLPatterns.IMPORT_EXPORT_CSV_FBV, ImpExpCSVFBVPattern);
    }

    public void setParams() throws SQLException {
        this.Files = QueryPattern.GetFilesFromMatcher(this.getMatcher().group(regexMainKey));
        switch (this.patternType) {
            case EXPORT_CSV: 
            case EXPORT_SECURE_CSV: {
                QueryPattern.DummyFiles(this.Files);
                this.Secure = QueryPattern.isSecureQuery(this.getMatcher());
                this.CSV = true;
                break;
            }
            case IMPORT_CSV: 
            case IMPORT_SECURE_CSV: {
                this.Secure = QueryPattern.isSecureQuery(this.getMatcher());
                this.CSV = true;
                break;
            }
            case IMPORT_FBV: 
            case IMPORT_SECURE_FBV: {
                this.Secure = QueryPattern.isSecureQuery(this.getMatcher());
                this.CSV = false;
                break;
            }
            case EXPORT_FBV: 
            case EXPORT_SECURE_FBV: {
                this.Secure = QueryPattern.isSecureQuery(this.getMatcher());
                if (this.Files.length > 1) {
                    if (this.Secure) {
                        throw new SQLException("Only one secure FBV file can be specified in export.", "04505");
                    }
                    throw new SQLException("Only one FBV file can be specified in export.", "04503");
                }
                this.CSV = false;
                break;
            }
            case IMPORT_ERROR_CSV: 
            case IMPORT_SECURE_ERROR_CSV: {
                this.Secure = QueryPattern.isSecureQuery(this.getMatcher());
                this.CSV = true;
                this.ErrFiles = QueryPattern.GetFilesFromMatcher(this.match.group("SecondPart"));
            }
        }
    }

    public String getRandomString() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public String multiLineCommentReplacer(String string) {
        Matcher matcher = Pattern.compile("/\\*(.*?)\\*/", 34).matcher(string);
        while (matcher.find()) {
            for (int i = 0; i < matcher.groupCount(); ++i) {
                String string2 = matcher.group(i);
                String string3 = "/*" + this.getRandomString() + "*/";
                string = string.replace(string2, string3 + " ");
                this.commentsMap.put(string3, string2);
            }
        }
        return string;
    }

    public String singleLineCommentReplacer(String string) {
        Matcher matcher = Pattern.compile("--.*?(" + System.getProperty("line.separator") + "|\\n|$)", 34).matcher(string);
        while (matcher.find()) {
            for (int i = 0; i < matcher.groupCount(); ++i) {
                String string2 = matcher.group(i);
                String string3 = "/*" + this.getRandomString() + "*/";
                string = string.replace(string2, string3 + " ");
                this.commentsMap.put(string3, string2);
            }
        }
        return string;
    }

    public String replaceHashWithSingleLineComments(String string) {
        return this.replaceHashWithMultiLineComments(string);
    }

    public String replaceHashWithMultiLineComments(String string) {
        for (Map.Entry<String, String> entry : this.commentsMap.entrySet()) {
            if (!string.contains(entry.getKey())) continue;
            string = string.replace(entry.getKey() + " ", entry.getValue());
        }
        return string;
    }

    public String replaceHashWithComments(String string) {
        return this.replaceHashWithMultiLineComments(this.replaceHashWithSingleLineComments(string));
    }

    public String getCommentForHash(String string) {
        return this.commentsMap.getOrDefault(string, null);
    }

    private String replaceCommentsWithHash(String string) {
        return this.singleLineCommentReplacer(this.multiLineCommentReplacer(string));
    }

    public boolean Match(String string) throws SQLException {
        if (string == null) {
            throw new SQLException("[ERROR] SQL Query is not provided.");
        }
        if (this.getMatcher() == null) {
            string = this.replaceCommentsWithHash(string);
            for (Map.Entry<SQLPatterns, Pattern> entry : this.patterns.entrySet()) {
                Matcher matcher = entry.getValue().matcher(string);
                if (!matcher.matches()) continue;
                this.setMatcher(matcher);
                this.setPatternType(QueryPattern.identifyPatternType(matcher, entry.getKey()));
                this.setIsMatching(matcher.matches());
                this.setSql(string);
                this.setParams();
                break;
            }
        }
        return this.getIsMatching();
    }

    public static boolean isSecureQuery(Matcher matcher) {
        return QueryManipulator.RemoveComment(matcher.group(regexSecureKey)).trim().replaceAll("\\s+", " ").toUpperCase().startsWith("LOCAL SECURE");
    }

    public static boolean isImportQuery(Matcher matcher) {
        return QueryManipulator.RemoveComment(matcher.group(getRegexQueryKey)).trim().replaceAll("\\s+", " ").toUpperCase().startsWith("IMPORT");
    }

    public static boolean isCSVQuery(Matcher matcher) {
        return QueryManipulator.RemoveComment(matcher.group(regexFileType)).trim().replaceAll("\\s+", " ").toUpperCase().startsWith("CSV");
    }

    public static SQLPatterns identifyPatternType(Matcher matcher, SQLPatterns sQLPatterns) {
        boolean bl = QueryPattern.isSecureQuery(matcher);
        boolean bl2 = QueryPattern.isImportQuery(matcher);
        boolean bl3 = QueryPattern.isCSVQuery(matcher);
        SQLPatterns sQLPatterns2 = bl2 ? (sQLPatterns == SQLPatterns.IMPORT_EXPORT_CSV_FBV ? (bl3 ? (bl ? SQLPatterns.IMPORT_SECURE_CSV : SQLPatterns.IMPORT_CSV) : (bl ? SQLPatterns.IMPORT_SECURE_FBV : SQLPatterns.IMPORT_FBV)) : (bl ? SQLPatterns.IMPORT_SECURE_ERROR_CSV : SQLPatterns.IMPORT_ERROR_CSV)) : (bl3 ? (bl ? SQLPatterns.EXPORT_SECURE_CSV : SQLPatterns.EXPORT_CSV) : (bl ? SQLPatterns.EXPORT_SECURE_FBV : SQLPatterns.EXPORT_FBV));
        return sQLPatterns2;
    }

    public static String[] GetFilesFromMatcher(String string) throws SQLException {
        try {
            String string2 = "(/\\*((.|" + System.getProperty("line.separator") + ")*?)\\*/)";
            String string3 = String.join((CharSequence)" ", string.split(string2));
            Pattern pattern = Pattern.compile("File\\s+'(.*?)'+", 34);
            Matcher matcher = pattern.matcher(string3);
            ArrayList<String> arrayList = new ArrayList<String>();
            while (matcher.find()) {
                arrayList.add(matcher.group(1));
            }
            String[] stringArray = new String[arrayList.size()];
            return arrayList.toArray(stringArray);
        }
        catch (Exception exception) {
            throw new SQLException("[ERROR] Filenames cannot be parsed.");
        }
    }

    public static String CreateFilenameQueryComment(String[] stringArray) {
        if (stringArray.length <= 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length - 1; ++i) {
            stringBuilder.append(String.format("file '%s' ", stringArray[i]));
        }
        stringBuilder.append(String.format("file '%s'", stringArray[stringArray.length - 1]));
        return "/*" + stringBuilder + "*/";
    }

    private static void DummyFiles(String[] stringArray) {
        for (String string : stringArray) {
            File file = new File(string);
            if (file.exists() || file.isDirectory()) continue;
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void setPatternType(SQLPatterns sQLPatterns) {
        this.patternType = sQLPatterns;
    }

    public SQLPatterns getPatternType() {
        return this.patternType;
    }

    private void setIsMatching(boolean bl) {
        this.isMatching = bl;
    }

    public boolean getIsMatching() {
        return this.isMatching;
    }

    private void setSql(String string) {
        this.sql = string;
    }

    public String getSql() {
        return this.sql;
    }

    public Matcher getMatcher() {
        return this.match;
    }

    private void setMatcher(Matcher matcher) {
        this.match = matcher;
    }

    public String[] getFiles() {
        return this.Files;
    }

    public String[] getErrFiles() {
        return this.ErrFiles;
    }

    public boolean isCSV() {
        return this.CSV;
    }

    public boolean isSecure() {
        return this.Secure;
    }

    public void setSecure(boolean bl) {
        this.Secure = bl;
    }

    public static enum SQLPatterns {
        IMPORT_EXPORT,
        IMPORT_CSV,
        IMPORT_SECURE_CSV,
        IMPORT_ERROR_CSV,
        IMPORT_SECURE_ERROR_CSV,
        EXPORT_CSV,
        EXPORT_SECURE_CSV,
        IMPORT_FBV,
        IMPORT_SECURE_FBV,
        EXPORT_FBV,
        EXPORT_SECURE_FBV,
        IMPORT_EXPORT_CSV_FBV,
        IMPORT_ERROR,
        None;

    }
}

