/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc;

import com.exasol.jdbc.AbstractEXAStatement;
import com.exasol.jdbc.EXAConnection;
import com.exasol.jdbc.EXADriver;
import com.exasol.jdbc.EXAResultSet;
import com.exasol.jdbc.ExceptionFactory;
import com.exasol.jdbc.NotImplemented;
import com.exasol.jdbc.Translator;
import com.exasol.jdbc.importExport.HttpPushTool;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class EXAStatement
extends AbstractEXAStatement {
    List httpPushes = new ArrayList();
    boolean isCloseOnCompletion = false;

    public EXAStatement(EXAConnection eXAConnection, int n, int n2) {
        super(eXAConnection, n, n2);
    }

    public EXAStatement(EXAConnection eXAConnection) {
        super(eXAConnection);
    }

    private HttpPushTool preparePush(String string) throws SQLException {
        try {
            return HttpPushTool.transformCommand(string, this.connection.clusterNodes, this.connection.IsEncrypted(), this.debug);
        }
        catch (IOException iOException) {
            if (this.debug != null) {
                EXADriver.debugError("Error while perparing import / export. ", iOException, this.debug);
            }
            throw new SQLException(iOException.getMessage(), "04508");
        }
    }

    private void finishPush(HttpPushTool httpPushTool) throws SQLException {
        try {
            httpPushTool.checkForErrors();
        }
        catch (IOException iOException) {
            if (this.connection.debug != null) {
                this.log("Exception caught in import / export process:" + iOException.getMessage());
            }
            throw new SQLException(iOException.toString(), "04509");
        }
        finally {
            try {
                httpPushTool.close();
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.toString(), "04510");
            }
        }
    }

    private void convertPushSQLException(SQLException sQLException, HttpPushTool httpPushTool) throws SQLException {
        if (sQLException.getSQLState().compareTo("42000") >= 0 && sQLException.getSQLState().compareTo("43000") < 0) {
            String string = Translator.MESSAGE_while_executing_SQL(sQLException.getMessage(), httpPushTool.getSQL());
            try {
                throw (SQLException)sQLException.getClass().getConstructor(String.class, String.class).newInstance(string, sQLException.getSQLState());
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (SecurityException securityException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            throw new SQLException(string, sQLException.getSQLState());
        }
        throw sQLException;
    }

    @Override
    public synchronized void addBatch(String string) throws SQLException {
        this.log("EXAStatement.addBatch()");
        HttpPushTool httpPushTool = this.preparePush(string);
        if (httpPushTool == null) {
            super.addBatch(string);
            return;
        }
        this.httpPushes.add(httpPushTool);
        super.addBatch(httpPushTool.getSQL());
    }

    @Override
    public synchronized void clearBatch() throws SQLException {
        try {
            super.clearBatch();
        }
        finally {
            for (int i = 0; i < this.httpPushes.size(); ++i) {
                this.finishPush((HttpPushTool)this.httpPushes.get(i));
            }
            this.httpPushes.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int[] executeBatch() throws SQLException {
        this.log("EXAStatement.executeBatch()");
        this.connection.setSchemaMayHaveChanged();
        try {
            int[] nArray = super.executeBatch();
            return nArray;
        }
        finally {
            for (int i = 0; i < this.httpPushes.size(); ++i) {
                try {
                    this.finishPush((HttpPushTool)this.httpPushes.get(i));
                    continue;
                }
                catch (Exception exception) {}
            }
            this.httpPushes.clear();
        }
    }

    @Override
    public synchronized boolean execute(String string, int n) throws SQLException {
        this.log("EXAStatement.execute(" + n + ")");
        this.connection.setSchemaMayHaveChanged();
        if (n != 2) {
            throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName() + "(String sql,RETURN_GENERATED_KEYS)");
        }
        return this.execute(string);
    }

    @Override
    public synchronized boolean execute(String string, int[] nArray) throws SQLException {
        this.log("EXAStatement.execute(columnIndexes[])");
        this.connection.setSchemaMayHaveChanged();
        if (nArray != null && nArray.length > 0) {
            throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName() + "(String sql,int[] columnIndexes)");
        }
        return this.execute(string);
    }

    @Override
    public synchronized boolean execute(String string, String[] stringArray) throws SQLException {
        this.log("EXAStatement.execute(columnNames[])");
        this.connection.setSchemaMayHaveChanged();
        if (stringArray != null && stringArray.length > 0) {
            throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName() + "(String sql,String[] columnNames)");
        }
        return this.execute(string);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.log("closeOnCompletion()");
        this.isCloseOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        this.log("isCloseOnCompletion() - " + this.isCloseOnCompletion);
        return this.isCloseOnCompletion;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized boolean execute(String string) throws SQLException {
        this.log("EXAStatement.execute()");
        this.connection.setSchemaMayHaveChanged();
        HttpPushTool httpPushTool = this.preparePush(string);
        if (httpPushTool == null) {
            return super.execute(string);
        }
        SQLException sQLException = null;
        try {
            boolean bl = super.execute(httpPushTool.getSQL());
            return bl;
        }
        catch (SQLException sQLException2) {
            try {
                this.convertPushSQLException(sQLException2, httpPushTool);
                throw sQLException2;
            }
            catch (SQLException sQLException3) {
                httpPushTool.KillHttpPushToolThread();
                sQLException = sQLException3;
                throw sQLException3;
            }
        }
        finally {
            try {
                this.finishPush(httpPushTool);
                this.log("execution done.");
            }
            catch (SQLException sQLException4) {
                if (null == sQLException) throw sQLException4;
                throw ExceptionFactory.mergeSQLExceptions(sQLException, sQLException4);
            }
            finally {
                this.log("execution ended with exception.");
            }
        }
    }

    @Override
    public synchronized int executeUpdate(String string, int n) throws SQLException {
        if (n == 2) {
            this.log("EXAStatement.executeUpdate(autoGeneratedKeys: NO_GENERATED_KEYS (" + n + "))");
        } else if (n == 1) {
            this.log("EXAStatement.executeUpdate(autoGeneratedKeys: RETURN_GENERATED_KEYS (" + n + "))");
        } else {
            this.log("EXAStatement.executeUpdate(autoGeneratedKeys: " + n + ")");
        }
        this.connection.setSchemaMayHaveChanged();
        if (n != 2) {
            throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName() + "(String sql,RETURN_GENERATED_KEYS)");
        }
        return this.executeUpdate(string);
    }

    @Override
    public synchronized int executeUpdate(String string, int[] nArray) throws SQLException {
        if (nArray != null && nArray.length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < nArray.length - 1; ++i) {
                stringBuilder.append(nArray[i] + ", ");
            }
            stringBuilder.append(nArray[nArray.length - 1]);
            this.log("EXAStatement.executeUpdate(columnIndexes: {" + stringBuilder + "})");
        } else {
            this.log("EXAStatement.executeUpdate(columnIndexes: {})");
        }
        this.connection.setSchemaMayHaveChanged();
        if (nArray != null && nArray.length > 0) {
            throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName() + "(String sql,int columnIndexes[])");
        }
        return this.executeUpdate(string);
    }

    @Override
    public synchronized int executeUpdate(String string, String[] stringArray) throws SQLException {
        if (stringArray != null && stringArray.length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < stringArray.length - 1; ++i) {
                stringBuilder.append(stringArray[i] + ", ");
            }
            stringBuilder.append(stringArray[stringArray.length - 1]);
            this.log("EXAStatement.executeUpdate(columnNames: {" + stringBuilder + "})");
        } else {
            this.log("EXAStatement.executeUpdate(columnNames: {})");
        }
        this.connection.setSchemaMayHaveChanged();
        if (stringArray != null && stringArray.length > 0) {
            throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName() + "(String sql,String columnNames[])");
        }
        return this.executeUpdate(string);
    }

    @Override
    public synchronized long executeLargeUpdate(String string) throws SQLException {
        this.log("EXAStatement.executeLargeUpdate()");
        HttpPushTool httpPushTool = this.preparePush(string);
        this.connection.setSchemaMayHaveChanged();
        if (httpPushTool == null) {
            return super.exaExecuteLargeUpdate(string);
        }
        SQLException sQLException = null;
        try {
            long l = super.exaExecuteLargeUpdate(httpPushTool.getSQL());
            return l;
        }
        catch (SQLException sQLException2) {
            try {
                this.convertPushSQLException(sQLException2, httpPushTool);
            }
            catch (SQLException sQLException3) {
                httpPushTool.KillHttpPushToolThread();
                sQLException = sQLException3;
                throw sQLException3;
            }
            throw sQLException2;
        }
        finally {
            try {
                this.finishPush(httpPushTool);
            }
            catch (SQLException sQLException4) {
                if (null != sQLException) {
                    throw ExceptionFactory.mergeSQLExceptions(sQLException, sQLException4);
                }
                throw sQLException4;
            }
        }
    }

    @Override
    public synchronized long executeLargeUpdate(String string, int n) throws SQLException {
        if (n == 2) {
            this.log("EXAStatement.executeLargeUpdate(autoGeneratedKeys: NO_GENERATED_KEYS (" + n + "))");
        } else if (n == 1) {
            this.log("EXAStatement.executeLargeUpdate(autoGeneratedKeys: RETURN_GENERATED_KEYS (" + n + "))");
        } else {
            this.log("EXAStatement.executeLargeUpdate(autoGeneratedKeys: " + n + ")");
        }
        this.connection.setSchemaMayHaveChanged();
        if (n != 2) {
            throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName() + "(String sql, RETURN_GENERATED_KEYS)");
        }
        return this.executeLargeUpdate(string);
    }

    @Override
    public synchronized long executeLargeUpdate(String string, int[] nArray) throws SQLException {
        if (nArray != null && nArray.length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < nArray.length - 1; ++i) {
                stringBuilder.append(nArray[i] + ", ");
            }
            stringBuilder.append(nArray[nArray.length - 1]);
            this.log("EXAStatement.executeLargeUpdate(columnIndexes: {" + stringBuilder + "})");
        } else {
            this.log("EXAStatement.executeLargeUpdate(columnIndexes: {})");
        }
        this.connection.setSchemaMayHaveChanged();
        if (nArray != null && nArray.length > 0) {
            throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName() + "(String sql, int columnIndexes[])");
        }
        return this.executeLargeUpdate(string);
    }

    @Override
    public synchronized long executeLargeUpdate(String string, String[] stringArray) throws SQLException {
        if (stringArray != null && stringArray.length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < stringArray.length - 1; ++i) {
                stringBuilder.append(stringArray[i] + ", ");
            }
            stringBuilder.append(stringArray[stringArray.length - 1]);
            this.log("EXAStatement.executeLargeUpdate(columnNames: {" + stringBuilder + "})");
        } else {
            this.log("EXAStatement.executeLargeUpdate(columnNames: {})");
        }
        this.connection.setSchemaMayHaveChanged();
        if (stringArray != null && stringArray.length > 0) {
            throw new NotImplemented(this.debug, new Exception().getStackTrace()[0].getMethodName() + "(String sql, String columnNames[])");
        }
        return this.executeLargeUpdate(string);
    }

    @Override
    public synchronized long[] executeLargeBatch() throws SQLException {
        return super.exaExecuteLargeBatch();
    }

    @Override
    public synchronized int executeUpdate(String string) throws SQLException {
        return (int)this.executeLargeUpdate(string);
    }

    @Override
    public synchronized boolean getMoreResults(int n) throws SQLException {
        if (this.debug != null) {
            this.debug.log("getMoreResults(" + n + ")");
        }
        if (n == 1) {
            if (this.current_result >= 0 && this.current_result < this.results.length && this.results[this.current_result] instanceof EXAResultSet) {
                ((EXAResultSet)this.results[this.current_result]).close();
            }
        } else if (n == 3) {
            this.closeResultSets(this.results);
        }
        return this.getMoreResults();
    }

    @Override
    public String getSQLTypeName(int n) {
        switch (n) {
            case 16: {
                return "BOOLEAN";
            }
            case 70: {
                return "DATALINK";
            }
        }
        return super.getSQLTypeName(n);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + clazz.getName());
    }
}

