/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction.util;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.transaction.CoreTransactionGetResult;
import com.couchbase.client.core.transaction.util.LogDeferDocId;
import com.couchbase.client.core.transaction.util.LogDeferThrowable;

@Stability.Internal
public class DebugUtil {
    private DebugUtil() {
    }

    public static LogDeferThrowable dbg(Throwable err) {
        if (err == null) {
            return null;
        }
        return new LogDeferThrowable(err);
    }

    public static LogDeferDocId docId(CoreTransactionGetResult doc) {
        return new LogDeferDocId(doc.collection(), doc.id());
    }

    public static LogDeferDocId docId(CollectionIdentifier collection, String docId) {
        return new LogDeferDocId(collection, docId);
    }

    public static String createElidedStacktrace(Throwable err) {
        StackTraceElement[] st;
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement s : st = err.getStackTrace()) {
            String str = s.toString();
            if (str.startsWith("reactor.") || str.startsWith("java.") || str.startsWith("com.couchbase.client.core") || sb.length() <= 0) continue;
            sb.append((CharSequence)sb);
            sb.append("; ");
        }
        return sb.toString();
    }
}

