/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction.support;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.RequestTracer;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class SpanWrapper {
    private final long startTime = System.nanoTime();
    private final RequestSpan span;
    private final RequestTracer tracer;
    private boolean finished = false;

    public long elapsedMicros() {
        return (System.nanoTime() - this.startTime) * 1000L;
    }

    public long finish() {
        if (!this.finished) {
            this.finished = true;
            long elapsed = System.nanoTime() - this.startTime;
            this.span.end();
            return TimeUnit.NANOSECONDS.toMicros(elapsed);
        }
        return 0L;
    }

    public SpanWrapper(RequestTracer tracer, RequestSpan span) {
        this.tracer = Objects.requireNonNull(tracer);
        this.span = Objects.requireNonNull(span);
    }

    public static SpanWrapper create(RequestTracer tracer, String op, @Nullable SpanWrapper parent) {
        RequestSpan span = tracer.requestSpan(op, parent == null ? null : parent.span);
        return new SpanWrapper(tracer, span);
    }

    public <T> SpanWrapper attribute(String key, T value) {
        this.span.attribute(key, String.valueOf(value));
        return this;
    }

    public RequestSpan span() {
        return this.span;
    }

    public long failWith(Throwable err) {
        this.span.status(RequestSpan.StatusCode.ERROR);
        this.span.attribute("error.name", err.getClass().getName());
        this.span.attribute("error.message", err.getMessage());
        return this.finish();
    }
}

