/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.transaction;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.EventBus;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.RequestTracer;
import com.couchbase.client.core.transaction.cleanup.CoreTransactionsCleanup;
import com.couchbase.client.core.transaction.config.CoreMergedTransactionConfig;
import com.couchbase.client.core.transaction.log.CoreTransactionLogger;
import com.couchbase.client.core.transaction.support.SpanWrapper;
import com.couchbase.client.core.transaction.support.SpanWrapperUtil;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

@Stability.Internal
public class CoreTransactionContext {
    private final long startTimeClient;
    public final CoreTransactionLogger LOGGER;
    private final String transactionId;
    private final SpanWrapper transactionSpan;
    private final CoreMergedTransactionConfig config;
    private final CoreTransactionsCleanup cleanup;
    private int numAttempts = 0;

    public CoreTransactionContext(RequestTracer tracer, EventBus eventBus, String transactionId, CoreMergedTransactionConfig config, CoreTransactionsCleanup cleanup) {
        this.config = Objects.requireNonNull(config);
        this.cleanup = Objects.requireNonNull(cleanup);
        SpanWrapper pspan = config.parentSpan().map(sp -> new SpanWrapper(tracer, (RequestSpan)sp)).orElse(null);
        this.transactionSpan = SpanWrapperUtil.basic(SpanWrapper.create(tracer, "transaction", pspan), "transaction").attribute("db.couchbase.transactions.transaction_id", transactionId);
        this.transactionId = Objects.requireNonNull(transactionId);
        this.startTimeClient = System.nanoTime();
        this.LOGGER = new CoreTransactionLogger(Objects.requireNonNull(eventBus), transactionId);
    }

    public Duration expirationTime() {
        return this.config.expirationTime();
    }

    public long timeSinceStartOfTransactionsMillis(long now) {
        long expiredNanos = now - this.startTimeClient;
        return TimeUnit.NANOSECONDS.toMillis(expiredNanos);
    }

    public boolean hasExpiredClientSide() {
        boolean isExpired;
        long now = System.nanoTime();
        long expiredMillis = this.timeSinceStartOfTransactionsMillis(now);
        boolean bl = isExpired = expiredMillis > this.expirationTime().toMillis();
        if (isExpired) {
            this.LOGGER.info("Has expired client side (now=%dns start=%dns expired=%dmillis config=%dms)", now, this.startTimeClient, expiredMillis, this.expirationTime().toMillis());
        }
        return isExpired;
    }

    public String transactionId() {
        return this.transactionId;
    }

    public long startTimeClient() {
        return this.startTimeClient;
    }

    public SpanWrapper span() {
        return this.transactionSpan;
    }

    public int numAttempts() {
        return this.numAttempts;
    }

    public void incAttempts() {
        ++this.numAttempts;
    }

    public CoreTransactionsCleanup cleanup() {
        return this.cleanup;
    }
}

