/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream.exporter;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.tools.transfer.stream.IAppendableDataExporter;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataExporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.exporter.StreamExporterAbstract;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DataExporterTXT
extends StreamExporterAbstract
implements IAppendableDataExporter {
    private static final String PROP_BATCH_SIZE = "batchSize";
    private static final String PROP_MIN_COLUMN_LENGTH = "minColumnLength";
    private static final String PROP_MAX_COLUMN_LENGTH = "maxColumnLength";
    private static final String PROP_SHOW_NULLS = "showNulls";
    private static final String PROP_DELIM_LEADING = "delimLeading";
    private static final String PROP_DELIM_HEADER = "delimHeader";
    private static final String PROP_DELIM_TRAILING = "delimTrailing";
    private static final String PROP_DELIM_BETWEEN = "delimBetween";
    private static final String PROP_SHOW_HEADER = "showHeader";
    private int batchSize = 200;
    private int maxColumnSize = 0;
    private int minColumnSize = 1;
    private boolean showHeader;
    private boolean showNulls;
    private boolean delimLeading;
    private boolean delimHeader;
    private boolean delimTrailing;
    private boolean delimBetween;
    private Deque<String[]> batchQueue;
    private DBDAttributeBinding[] columns;
    private int[] colWidths;

    @Override
    public void init(IStreamDataExporterSite site) throws DBException {
        super.init(site);
        Map<String, Object> properties = site.getProperties();
        this.batchSize = Math.max(CommonUtils.toInt((Object)properties.get(PROP_BATCH_SIZE), (int)200), 200);
        this.minColumnSize = Math.max(CommonUtils.toInt((Object)properties.get(PROP_MIN_COLUMN_LENGTH), (int)1), 1);
        this.maxColumnSize = Math.max(CommonUtils.toInt((Object)properties.get(PROP_MAX_COLUMN_LENGTH), (int)0), 0);
        this.showNulls = CommonUtils.getBoolean((Object)properties.get(PROP_SHOW_NULLS), (boolean)false);
        this.delimLeading = CommonUtils.getBoolean((Object)properties.get(PROP_DELIM_LEADING), (boolean)true);
        this.delimHeader = CommonUtils.getBoolean((Object)properties.get(PROP_DELIM_HEADER), (boolean)true);
        this.delimTrailing = CommonUtils.getBoolean((Object)properties.get(PROP_DELIM_TRAILING), (boolean)true);
        this.delimBetween = CommonUtils.getBoolean((Object)properties.get(PROP_DELIM_BETWEEN), (boolean)true);
        this.showHeader = CommonUtils.getBoolean((Object)properties.get(PROP_SHOW_HEADER), (boolean)true);
        this.batchQueue = new ArrayDeque<String[]>(this.batchSize);
        if (this.maxColumnSize > 0) {
            this.maxColumnSize = Math.max(this.maxColumnSize, this.minColumnSize);
        }
    }

    @Override
    public void exportHeader(DBCSession session) throws DBException, IOException {
        this.columns = this.getSite().getAttributes();
        this.colWidths = new int[this.columns.length];
        Arrays.fill(this.colWidths, this.minColumnSize);
        if (this.showHeader) {
            String[] header = new String[this.columns.length];
            int index = 0;
            while (index < this.columns.length) {
                header[index] = DataExporterTXT.getAttributeName(this.columns[index]);
                ++index;
            }
            this.appendRow(header);
        }
    }

    @Override
    public void exportRow(DBCSession session, DBCResultSet resultSet, Object[] row) throws DBException, IOException {
        String[] values = new String[this.columns.length];
        int index = 0;
        while (index < this.columns.length) {
            values[index] = this.getCellString(this.columns[index], row[index]);
            ++index;
        }
        this.appendRow(values);
    }

    @Override
    public void exportFooter(DBRProgressMonitor monitor) throws DBException, IOException {
        this.writeQueue();
    }

    @Override
    public void importData(@NotNull IStreamDataExporterSite site) {
    }

    @Override
    public boolean shouldTruncateOutputFileBeforeExport() {
        return false;
    }

    private void appendRow(String[] row) {
        if (this.batchQueue.size() == this.batchSize) {
            this.writeQueue();
        }
        this.batchQueue.add(row);
    }

    private void writeQueue() {
        if (this.batchQueue.isEmpty()) {
            return;
        }
        for (String[] row : this.batchQueue) {
            int index = 0;
            while (index < this.columns.length) {
                String cell = row[index];
                if (this.maxColumnSize > 0 && cell.length() > this.maxColumnSize) {
                    this.colWidths[index] = this.maxColumnSize;
                } else if (cell.length() > this.colWidths[index]) {
                    this.colWidths[index] = cell.length();
                }
                ++index;
            }
        }
        while (!this.batchQueue.isEmpty()) {
            if (this.showHeader) {
                this.writeRow(this.batchQueue.poll(), ' ');
            }
            if (this.delimHeader) {
                this.delimHeader = false;
                this.writeRow(null, '-');
            }
            if (this.showHeader) continue;
            this.writeRow(this.batchQueue.poll(), ' ');
        }
        this.getWriter().flush();
    }

    private void writeRow(String[] values, char fill) {
        StringBuilder sb = new StringBuilder();
        if (this.delimLeading) {
            sb.append('|');
        }
        int index = 0;
        int length = this.columns.length;
        while (index < length) {
            String cell;
            String string = cell = ArrayUtils.isEmpty((Object[])values) ? "" : values[index];
            if (this.maxColumnSize > 0) {
                sb.append(CommonUtils.truncateString((String)cell, (int)this.maxColumnSize));
            } else {
                sb.append(cell);
            }
            if (index < length - 1 || this.delimTrailing || fill != ' ') {
                int width = cell.length();
                while (width < this.colWidths[index]) {
                    sb.append(fill);
                    ++width;
                }
            }
            if (index < length - 1) {
                sb.append(this.delimBetween ? (char)'|' : ' ');
            }
            ++index;
        }
        if (this.delimTrailing) {
            sb.append('|');
        }
        sb.append(CommonUtils.getLineSeparator());
        this.getWriter().write(sb.toString());
    }

    private String getCellString(DBDAttributeBinding attr, Object value) {
        String displayString = attr.getValueHandler().getValueDisplayString((DBSTypedObject)attr, value, this.getValueExportFormat(attr));
        if (DBUtils.isNullValue((Object)value)) {
            return this.showNulls ? "[NULL]" : "";
        }
        return CommonUtils.getSingleLineString((String)displayString);
    }

    private static String getAttributeName(DBDAttributeBinding attr) {
        if (CommonUtils.isEmpty((String)attr.getLabel())) {
            return attr.getName();
        }
        return attr.getLabel();
    }
}

