/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util.security;

import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.DataPartVariable;
import com.sap.dbtech.jdbc.packet.ReplyPacket;
import com.sap.dbtech.jdbc.packet.RequestPacket;
import com.sap.dbtech.powertoys.DBM;
import com.sap.dbtech.powertoys.DBMException;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.dbtech.util.StructuredMem;
import com.sap.dbtech.util.Tracer;
import com.sap.dbtech.util.security.AbstractAuthenticationMethod;
import com.sap.dbtech.util.security.AuthenticationManagerInterface;
import com.sap.dbtech.util.security.GSSAuthentication;
import com.sap.dbtech.util.security.ScrammMD5Authentication;
import com.sap.dbtech.util.security.ScrammMD5AuthenticationV1;
import java.sql.SQLException;
import java.util.ArrayList;

public class AuthenticationManager
implements AuthenticationManagerInterface {
    ArrayList m_authMethods = new ArrayList(2);
    AbstractAuthenticationMethod m_method;

    public AuthenticationManager(DBM conn, String user, String password) throws SQLException, RTEException, DBMException {
        if (password == null || password.length() == 0) {
            try {
                GSSAuthentication gss = new GSSAuthentication(conn.getTracer());
                this.m_authMethods.add(gss);
            }
            catch (Exception e) {
                conn.trace("Reject GSS Authentication");
                conn.traceException(e);
            }
        } else {
            conn.trace("Reject GSS Authentication - password is not empty");
        }
        ScrammMD5AuthenticationV1 scrammMD5v1 = new ScrammMD5AuthenticationV1();
        this.m_authMethods.add(scrammMD5v1);
        ScrammMD5Authentication scrammMD5 = new ScrammMD5Authentication();
        this.m_authMethods.add(scrammMD5);
        StringBuffer reqPckg = new StringBuffer();
        boolean errorOccured = false;
        do {
            int index = 0;
            char delimiter = ' ';
            reqPckg.append("USER_GETCHALLENGE " + user + " METHODS");
            errorOccured = false;
            for (index = 0; index < this.m_authMethods.size() && !errorOccured; ++index) {
                Object obj = this.m_authMethods.get(index);
                AbstractAuthenticationMethod method = (AbstractAuthenticationMethod)obj;
                try {
                    reqPckg.append(delimiter);
                    reqPckg.append(method.getMethodName());
                    reqPckg.append(" ");
                    reqPckg.append(Tracer.Hex2String(method.getInitialData()).toUpperCase());
                    reqPckg.append(" ");
                    continue;
                }
                catch (SQLException e) {
                    conn.trace("Reject authentication method " + method.getMethodName());
                    conn.traceException(e);
                    this.m_authMethods.remove(index);
                    reqPckg = new StringBuffer();
                    errorOccured = true;
                    if (this.m_authMethods.size() != 0) continue;
                    throw new SQLException(MessageTranslator.translate("error.connection.noauthenticationmethodavailable"), "08001", -11111);
                }
            }
        } while (errorOccured);
        byte[] data = null;
        do {
            String replPckg;
            int pos;
            if ((pos = (replPckg = conn.cmd(reqPckg.toString())).indexOf(32)) == -1 && (pos = replPckg.indexOf(10)) == -1) {
                throw SQLExceptionSapDB.generateSQLException("error.connection.noauthenticationmethodavailable");
            }
            String methodName = replPckg.substring(0, pos);
            while (replPckg.charAt(pos) == ' ' || replPckg.charAt(pos) == '\n') {
                ++pos;
            }
            if (replPckg.length() - pos < 8) {
                throw SQLExceptionSapDB.generateSQLException("error.packet.wrongpacketformat", replPckg);
            }
            replPckg = replPckg.substring(pos, replPckg.length() - 1);
            for (int index = 0; index < this.m_authMethods.size() && !errorOccured; ++index) {
                this.m_method = (AbstractAuthenticationMethod)this.m_authMethods.get(index);
                if (this.m_method.getMethodName().equals(methodName)) break;
            }
            byte[] prefix = new byte[]{0, 1, 0};
            byte[] tail = Tracer.String2Hex(replPckg);
            prefix[2] = (byte)tail.length;
            byte[] packet = new byte[prefix.length + tail.length];
            System.arraycopy(prefix, 0, packet, 0, prefix.length);
            System.arraycopy(tail, 0, packet, prefix.length, tail.length);
            DataPartVariable vData = new DataPartVariable((StructuredMem)new StructuredBytes(packet), 1);
            vData.nextField();
            data = this.m_method.evaluate(vData, conn.getTracer());
            if (data == null) continue;
            reqPckg = new StringBuffer();
            reqPckg.append("USER_GETCHALLENGE " + user + " METHODS ");
            reqPckg.append(methodName);
            reqPckg.append(" ");
            reqPckg.append(Tracer.Hex2String(data).toUpperCase());
        } while (data != null);
    }

    public AuthenticationManager(ConnectionSapDB conn, String user, String password, boolean isUserPasswdAscii) throws SQLException {
        if (password == null || password.length() == 0) {
            try {
                GSSAuthentication gss = new GSSAuthentication(conn.tracer);
                this.m_authMethods.add(gss);
            }
            catch (Exception e) {
                conn.tracer.println("Reject GSS Authentication");
                conn.tracer.traceException(e);
            }
        } else {
            conn.tracer.println("Reject GSS Authentication - password is not empty");
        }
        ScrammMD5AuthenticationV1 scrammMD5v1 = new ScrammMD5AuthenticationV1();
        this.m_authMethods.add(scrammMD5v1);
        ScrammMD5Authentication scrammMD5 = new ScrammMD5Authentication();
        this.m_authMethods.add(scrammMD5);
        RequestPacket reqPckg = conn.getRequestPacket(!isUserPasswdAscii);
        boolean errorOccured = false;
        do {
            int index = 0;
            DataPartVariable dataPart = reqPckg.initAuthenticationMethodRequest(user);
            dataPart.addArg(0, 0);
            dataPart.addRow(2 * this.m_authMethods.size());
            errorOccured = false;
            for (index = 0; index < this.m_authMethods.size() && !errorOccured; ++index) {
                Object obj = this.m_authMethods.get(index);
                AbstractAuthenticationMethod method = (AbstractAuthenticationMethod)obj;
                try {
                    dataPart.putBytes(method.getMethodName().getBytes(), dataPart.getCurrentOffset());
                    dataPart.putBytes(method.getInitialData(), dataPart.getCurrentOffset());
                    continue;
                }
                catch (SQLException e) {
                    conn.tracer.println("Reject authentication method " + method.getMethodName());
                    conn.tracer.traceException(e);
                    this.m_authMethods.remove(index);
                    errorOccured = true;
                    if (this.m_authMethods.size() != 0) continue;
                    conn.freeRequestPacket(reqPckg);
                    throw new SQLException(MessageTranslator.translate("error.connection.noauthenticationmethodavailable"), "08001", -11111);
                }
            }
            if (errorOccured) continue;
            dataPart.close();
        } while (errorOccured);
        byte[] data = null;
        do {
            ReplyPacket replPckg;
            DataPartVariable vData;
            if ((vData = (replPckg = conn.execute(reqPckg, this, 2)).getVarDataPart()) == null || !vData.nextField()) {
                throw SQLExceptionSapDB.generateSQLException("error.connection.noauthenticationmethodavailable");
            }
            String methodName = vData.getString(1, 0);
            if (!vData.nextField() || vData.getCurrentFieldLen() < 8) {
                throw SQLExceptionSapDB.generateSQLException("error.packet.wrongpacketformat", Tracer.Hex2String(vData.getBytes(0, vData.size())));
            }
            for (int index = 0; index < this.m_authMethods.size() && !errorOccured; ++index) {
                this.m_method = (AbstractAuthenticationMethod)this.m_authMethods.get(index);
                if (this.m_method.getMethodName().equals(methodName)) break;
            }
            if ((data = this.m_method.evaluate(vData, conn.tracer)) == null) continue;
            reqPckg = conn.getRequestPacket(!isUserPasswdAscii);
            DataPartVariable dpOutput = reqPckg.initAuthenticationMethodRequest(user);
            dpOutput.addArg(0, 0);
            dpOutput.addRow(2);
            dpOutput.putBytes(methodName.getBytes(), dpOutput.getCurrentOffset());
            dpOutput.putBytes(data, dpOutput.getCurrentOffset());
            dpOutput.close();
        } while (data != null);
    }

    public void addClientProofPart(RequestPacket requestPacket, String user, String pwd, boolean isUnicode) throws SQLException {
        DataPartVariable data = (DataPartVariable)requestPacket.newDataPart(true);
        data.addRow(3);
        if (isUnicode) {
            char[] userArray = user.toCharArray();
            data.putBigUnicode(userArray, data.getExtent(), userArray.length * 2);
        } else {
            data.putString(user, data.getExtent());
        }
        data.addArg(data.getExtent(), 0);
        data.putString(this.m_method.getMethodName(), data.getExtent());
        data.addArg(data.getExtent(), 0);
        data.putBytes(this.m_method.getFinalData(pwd, isUnicode), data.getExtent());
        data.addArg(data.getExtent(), 0);
        data.close();
    }

    public String getFinalDBMConnectCmd(String pwd, boolean isUnicode) throws SQLException {
        String cmd = "USER_RESPONSE " + this.m_method.getMethodName() + " " + Tracer.Hex2String(this.m_method.getFinalData(pwd, isUnicode)).toUpperCase();
        return cmd;
    }

    public int getMaxPasswordLength() {
        return this.m_method.getMaxPasswordLength();
    }
}

