/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbcext;

import com.sap.dbtech.jdbcext.DataSourceSapDBBase;
import com.sap.dbtech.jdbcext.XAConnectionSapDB;
import com.sap.dbtech.jdbcext.XATrace;
import com.sap.dbtech.jdbcext.XATransaction;
import com.sap.dbtech.util.ByteUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class XADataSourceSapDB
extends DataSourceSapDBBase
implements XADataSource,
Referenceable {
    private XATrace xatrace;
    private Hashtable transactions = new Hashtable();
    private GarbageCollector garbagecollector = null;
    private int connectionCount = 0;

    public XADataSourceSapDB() {
        this.xatrace = new XATrace();
    }

    public XAConnection getXAConnection() throws SQLException {
        Properties p = (Properties)this.connectProperties.clone();
        XAConnectionSapDB conn = new XAConnectionSapDB(p, this, this.xatrace);
        if (this.connectionCount == 0) {
            if (this.garbagecollector != null) {
                this.garbagecollector.stopIt();
            }
            this.garbagecollector = new GarbageCollector(1000);
            this.garbagecollector.start();
        }
        ++this.connectionCount;
        return conn;
    }

    public XAConnection getXAConnection(String user, String password) throws SQLException {
        Properties p = (Properties)this.connectProperties.clone();
        p.setProperty("user", user);
        p.setProperty("password", password);
        XAConnectionSapDB conn = new XAConnectionSapDB(p, this, this.xatrace);
        if (this.connectionCount == 0) {
            if (this.garbagecollector != null) {
                this.garbagecollector.stopIt();
            }
            this.garbagecollector = new GarbageCollector(1000);
            this.garbagecollector.start();
        }
        ++this.connectionCount;
        return conn;
    }

    public void releaseXAConnection(XAConnection conn) {
        if (--this.connectionCount <= 0) {
            this.garbagecollector.stopIt();
            this.garbagecollector = null;
        }
    }

    XATransaction getXATransaction(Xid xid) {
        return (XATransaction)this.transactions.get(new XiDHashKey(xid));
    }

    void addXATransaction(XATransaction xatrans) {
        this.transactions.put(new XiDHashKey(xatrans.xid), xatrans);
    }

    void removeXATransaction(Xid xid) {
        this.transactions.remove(new XiDHashKey(xid));
    }

    Xid[] getAllPrepared() {
        Vector<Xid> result = new Vector<Xid>();
        Enumeration e = this.transactions.elements();
        while (e.hasMoreElements()) {
            XATransaction tx = (XATransaction)e.nextElement();
            if (tx.getStatus() != 3) continue;
            result.add(tx.xid);
        }
        return result.toArray(new Xid[result.size()]);
    }

    private Object outer() {
        return this;
    }

    public Reference getReference() throws NamingException {
        return this.createReference(this.getClass().getName());
    }

    protected void finalize() throws Throwable {
        if (this.garbagecollector != null) {
            this.garbagecollector.stopIt();
        }
        super.finalize();
    }

    class GarbageCollector
    extends Thread {
        ArrayList toBeRolledBack;
        ArrayList toBeRemoved;
        int delay;
        private boolean stopped;

        GarbageCollector(int delay) {
            super("SAPDB XA Timeout Manager " + XADataSourceSapDB.this.outer().hashCode());
            this.stopped = false;
            this.toBeRolledBack = new ArrayList();
            this.toBeRemoved = new ArrayList();
            this.delay = delay;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.stopped) {
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                this.toBeRemoved.clear();
                this.toBeRolledBack.clear();
                Object ignore = XADataSourceSapDB.this.outer();
                synchronized (ignore) {
                    Enumeration e = XADataSourceSapDB.this.transactions.elements();
                    long t = System.currentTimeMillis();
                    while (e.hasMoreElements()) {
                        XATransaction tx = (XATransaction)e.nextElement();
                        int status = tx.getStatus();
                        if (status == 2) {
                            this.toBeRemoved.add(tx.xid);
                            continue;
                        }
                        if (status == 3 || tx.timeOutTime >= t) continue;
                        this.toBeRolledBack.add(tx.xid);
                    }
                }
                Iterator i = this.toBeRolledBack.iterator();
                while (i.hasNext()) {
                    Xid xid = (Xid)i.next();
                    if (XADataSourceSapDB.this.xatrace != null) {
                        XADataSourceSapDB.this.xatrace.trace(xid, "rollback (timeout)");
                    }
                    Object t = XADataSourceSapDB.this.outer();
                    synchronized (t) {
                        XATransaction tx = XADataSourceSapDB.this.getXATransaction(xid);
                        if (tx != null) {
                            try {
                                tx.xaResourceHandler.rollback(xid, tx);
                            }
                            catch (XAException e) {
                                // empty catch block
                            }
                        }
                    }
                }
                Iterator j = this.toBeRemoved.iterator();
                while (j.hasNext()) {
                    Xid xid = (Xid)j.next();
                    if (XADataSourceSapDB.this.xatrace != null) {
                        XADataSourceSapDB.this.xatrace.trace(xid, "forget (timeout)");
                    }
                    Object object = XADataSourceSapDB.this.outer();
                    synchronized (object) {
                        XADataSourceSapDB.this.removeXATransaction(xid);
                    }
                }
            }
        }

        public void stopIt() {
            this.stopped = true;
        }
    }

    private class XiDHashKey {
        byte[] m_trans;
        byte[] m_branch;

        public boolean equals(Object obj) {
            XiDHashKey id2 = (XiDHashKey)obj;
            int erg = ByteUtil.compare(this.m_trans, id2.m_trans);
            if (erg == 0) {
                erg = ByteUtil.compare(this.m_branch, id2.m_branch);
            }
            return erg == 0;
        }

        public int hashCode() {
            return ByteUtil.bytes2Hash(this.m_trans, this.m_branch);
        }

        public XiDHashKey(Xid id) {
            this.m_trans = id.getGlobalTransactionId();
            this.m_branch = id.getBranchQualifier();
        }
    }
}

