/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.DriverSapDB;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.exceptions.StreamIOException;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.AbstractGetval;
import com.sap.dbtech.jdbc.translators.AbstractProcedurePutval;
import com.sap.dbtech.jdbc.translators.AsciiProcedurePutval;
import com.sap.dbtech.jdbc.translators.BinaryProcedurePutval;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.jdbc.translators.Getval;
import com.sap.dbtech.jdbc.translators.GetvalLob;
import com.sap.dbtech.jdbc.translators.ReaderInputStream;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.util.RawByteReader;
import com.sap.dbtech.util.StringUtil;
import com.sap.dbtech.util.StructuredMem;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;

public class ProcedureStreamTranslator
extends DBTechTranslator {
    ProcedureStreamTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncre) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncre);
    }

    public int getColumnDisplaySize() {
        return Integer.MAX_VALUE;
    }

    public Object transBinaryStreamForInput(InputStream stream, long length) throws SQLException {
        if (this.isBinary()) {
            if (stream == null) {
                return null;
            }
            return new BinaryProcedurePutval(this, stream, length);
        }
        throw SQLExceptionSapDB.generateSQLException("error.stream.conversion.bytes");
    }

    public Object transStringForInput(String val) throws SQLException {
        if (val == null) {
            return null;
        }
        if (this.isAscii()) {
            return new AsciiProcedurePutval(this, StringUtil.bytes_iso8859_1(val));
        }
        throw SQLExceptionSapDB.generateSQLException("error.stream.conversion.string");
    }

    public Object transCharacterStreamForInput(Reader reader, long length) throws SQLException {
        if (this.isAscii()) {
            if (reader == null) {
                return null;
            }
            return new AsciiProcedurePutval(this, new ReaderInputStream(reader, false), length);
        }
        throw SQLExceptionSapDB.generateSQLException("error.stream.conversion.string");
    }

    public Object transBytesForInput(byte[] val) throws SQLException {
        if (val == null) {
            return this.transBinaryStreamForInput(null, -1L);
        }
        return this.transBinaryStreamForInput(new ByteArrayInputStream(val), -1L);
    }

    protected void putSpecific(DataPart dataPart, Object data) throws SQLException {
        AbstractProcedurePutval putval = (AbstractProcedurePutval)data;
        putval.putDescriptor(dataPart);
    }

    protected Object transSpecificForInput(Object obj) throws SQLException {
        Object result = null;
        if (obj instanceof InputStream) {
            result = this.transAsciiStreamForInput((InputStream)obj, -1L);
        }
        return result;
    }

    public Object transAsciiStreamForInput(InputStream stream, long length) throws SQLException {
        if (this.isAscii()) {
            if (stream == null) {
                return null;
            }
            return new AsciiProcedurePutval(this, stream, length);
        }
        throw SQLExceptionSapDB.generateSQLException("error.stream.conversion.string");
    }

    private boolean isAscii() {
        return this.dataType == 6 || this.dataType == 19;
    }

    private boolean isBinary() {
        return this.dataType == 8 || this.dataType == 21;
    }

    private InputStream getStream(SQLParamController controller, DataPart mem, StructuredMem longdata) throws SQLException {
        InputStream result = null;
        Getval getval = null;
        if (!this.isNull(controller, mem)) {
            byte[] descriptor = mem.getBytes(this.bufpos_output, this.logicalLength);
            if (this.descriptorIsNull(descriptor)) {
                return null;
            }
            getval = DriverSapDB.isJDBC20 ? new GetvalLob(controller.getConnectionSapDB(), descriptor, longdata, this.dataType, this.isPackectEncodingUnicode()) : new Getval(controller.getConnectionSapDB(), descriptor, longdata, this.dataType, this.isPackectEncodingUnicode());
            result = ((AbstractGetval)getval).getAsciiStream();
        }
        return result;
    }

    public InputStream getAsciiStream(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        return this.getStream(controller, mem, longData);
    }

    public InputStream getBinaryStream(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        if (this.isBinary()) {
            return this.getStream(controller, mem, longData);
        }
        throw SQLExceptionSapDB.generateSQLException("error.binaryreadfromlong");
    }

    private GetvalLob getLob(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        GetvalLob result = null;
        if (!this.isNull(controller, mem)) {
            byte[] descriptor = mem.getBytes(this.bufpos_output, this.logicalLength);
            if (this.descriptorIsNull(descriptor)) {
                return null;
            }
            result = new GetvalLob(controller.getConnectionSapDB(), descriptor, longData, this.dataType, this.isPackectEncodingUnicode());
        }
        return result;
    }

    public Blob getBlob(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        return this.getLob(controller, mem, longData);
    }

    public byte getByte(SQLParamController controller, DataPart mem) throws SQLException {
        byte[] result = null;
        if (this.isNull(controller, mem)) {
            return 0;
        }
        result = this.getBytes(controller, mem);
        return result[0];
    }

    public byte[] getBytes(SQLParamController controller, DataPart mem) throws SQLException {
        ByteArrayOutputStream tmpStream;
        InputStream blobStream = this.getBinaryStream(controller, mem, controller.getReplyData());
        if (blobStream == null) {
            return null;
        }
        try {
            int bufSizeC = 4096;
            byte[] buf = new byte[4096];
            tmpStream = new ByteArrayOutputStream();
            int readLen = blobStream.read(buf);
            while (readLen > 0) {
                tmpStream.write(buf, 0, readLen);
                if (readLen >= 4096) {
                    readLen = blobStream.read(buf);
                    continue;
                }
                break;
            }
        }
        catch (StreamIOException sqlExc) {
            throw sqlExc.getSqlException();
        }
        catch (IOException ioExc) {
            throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", ioExc.getMessage());
        }
        return tmpStream.toByteArray();
    }

    public Reader getCharacterStream(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        InputStream byteStream = this.getAsciiStream(controller, mem, longData);
        if (byteStream == null) {
            return null;
        }
        return new RawByteReader(byteStream);
    }

    public Clob getClob(SQLParamController controller, DataPart mem, StructuredMem longData) throws SQLException {
        return this.getLob(controller, mem, longData);
    }

    public String getString(SQLParamController controller, DataPart mem) throws SQLException {
        int bufSizeC = 4096;
        StringBuffer result = new StringBuffer();
        Reader reader = this.getCharacterStream(controller, mem, controller.getReplyData());
        if (reader == null) {
            return null;
        }
        try {
            int charsRead;
            char[] buf = new char[4096];
            while ((charsRead = reader.read(buf)) > 0) {
                result.append(new String(buf, 0, charsRead));
                if (charsRead >= 4096) continue;
                break;
            }
        }
        catch (StreamIOException streamExc) {
            throw streamExc.getSqlException();
        }
        catch (IOException ioExc) {
            throw SQLExceptionSapDB.generateSQLException("error.stream.ioexception", ioExc.getMessage());
        }
        return result.toString();
    }

    protected boolean descriptorIsNull(byte[] descriptor) {
        return descriptor[25] == 1;
    }

    boolean isPackectEncodingUnicode() {
        return false;
    }

    public int getPrecision() {
        return Integer.MAX_VALUE;
    }

    public Object getObject(SQLParamController controller, DataPart mem) throws SQLException {
        switch (this.dataType) {
            case 6: 
            case 7: 
            case 19: 
            case 20: 
            case 34: {
                return this.getString(controller, mem);
            }
            case 8: 
            case 21: {
                return this.getBytes(controller, mem);
            }
        }
        return super.getObject(controller, mem);
    }
}

