/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc;

import com.sap.dbtech.jdbc.ConnectionItem;
import com.sap.dbtech.jdbc.MemoryResultSetMetaDataSapDB;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.util.MessageTranslator;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class MemoryResultSetSapDB
extends ConnectionItem
implements ResultSet {
    private String[] colHeadings;
    private Object[][] rows;
    private int currentRow;
    private boolean isClosed = false;

    public MemoryResultSetSapDB(String[] colHeadings, Object[][] rows) {
        super(null);
        this.colHeadings = colHeadings;
        this.rows = rows;
        this.currentRow = -1;
    }

    public boolean absolute(int row) throws SQLException {
        this.throwNotSupportedMethod("absolute");
        return false;
    }

    public void afterLast() throws SQLException {
        this.throwNotSupportedMethod("afterLast");
    }

    public void beforeFirst() throws SQLException {
        this.throwNotSupportedMethod("beforeFirst");
    }

    public void cancelRowUpdates() throws SQLException {
        this.throwNotSupportedMethod("cancelRowUpdates");
    }

    public void close() throws SQLException {
        this.isClosed = true;
    }

    public void deleteRow() throws SQLException {
        this.throwNotSupportedMethod("deleteRow");
    }

    public int findColumn(String columnName) throws SQLException {
        for (int i = 0; i < this.colHeadings.length; ++i) {
            if (!this.colHeadings[i].equals(columnName)) continue;
            return i + 1;
        }
        throw SQLExceptionSapDB.generateSQLException("error.invalidcolumnindex", columnName);
    }

    public boolean first() throws SQLException {
        this.throwNotSupportedMethod("first");
        return false;
    }

    public Array getArray(int i) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "MemoryResultSetSapDB", "getArray");
    }

    public Array getArray(String colName) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "MemoryResultSetSapDB", "getArray");
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return null;
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        return null;
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.throwNotSupportedMethod("getBigDecimal");
        return null;
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return null;
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        this.throwNotSupportedMethod("getBigDecimal");
        return null;
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return null;
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return null;
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        return null;
    }

    public Blob getBlob(int i) throws SQLException {
        this.throwNotSupportedMethod("getBlob");
        return null;
    }

    public Blob getBlob(String colName) throws SQLException {
        this.throwNotSupportedMethod("getBlob");
        return null;
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        return false;
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return false;
    }

    public byte getByte(int columnIndex) throws SQLException {
        return 0;
    }

    public byte getByte(String columnName) throws SQLException {
        return 0;
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        return null;
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return null;
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.throwNotSupportedMethod("getCharacterStream");
        return null;
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        this.throwNotSupportedMethod("getCharacterStream");
        return null;
    }

    public Clob getClob(int i) throws SQLException {
        this.throwNotSupportedMethod("getClob");
        return null;
    }

    public Clob getClob(String colName) throws SQLException {
        this.throwNotSupportedMethod("getClob");
        return null;
    }

    public int getConcurrency() throws SQLException {
        this.throwNotSupportedMethod("getConcurrency");
        return 0;
    }

    public String getCursorName() throws SQLException {
        return "";
    }

    public Date getDate(int columnIndex) throws SQLException {
        return null;
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "MemoryResultSetSapDB", "getDate");
    }

    public Date getDate(String columnName) throws SQLException {
        return null;
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "MemoryResultSetSapDB", "getDate");
    }

    public double getDouble(int columnIndex) throws SQLException {
        return 0.0;
    }

    public double getDouble(String columnName) throws SQLException {
        return 0.0;
    }

    public int getFetchDirection() throws SQLException {
        this.throwNotSupportedMethod("getFetchDirection");
        return 0;
    }

    public int getFetchSize() throws SQLException {
        this.throwNotSupportedMethod("getFetchSize");
        return 0;
    }

    public float getFloat(int columnIndex) throws SQLException {
        return 0.0f;
    }

    public float getFloat(String columnName) throws SQLException {
        return 0.0f;
    }

    public int getInt(int columnIndex) throws SQLException {
        return 0;
    }

    public int getInt(String columnName) throws SQLException {
        return 0;
    }

    public long getLong(int columnIndex) throws SQLException {
        return 0L;
    }

    public long getLong(String columnName) throws SQLException {
        return 0L;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return new MemoryResultSetMetaDataSapDB(this.colHeadings);
    }

    public Object getObject(int columnIndex) throws SQLException {
        Object result;
        try {
            result = this.rows[this.currentRow][columnIndex - 1];
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            throw SQLExceptionSapDB.generateSQLException("error.invalidcolumnindex", Integer.toString(columnIndex));
        }
        return result;
    }

    public Object getObject(int i, Map map) throws SQLException {
        this.throwNotSupportedMethod("getObject");
        return null;
    }

    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    public Object getObject(String colName, Map map) throws SQLException {
        this.throwNotSupportedMethod("getObject");
        return null;
    }

    public Ref getRef(int i) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "MemoryResultSetSapDB", "getRef");
    }

    public Ref getRef(String colName) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "MemoryResultSetSapDB", "getRef");
    }

    public int getRow() throws SQLException {
        this.throwNotSupportedMethod("getRow");
        return 0;
    }

    public short getShort(int columnIndex) throws SQLException {
        return 0;
    }

    public short getShort(String columnName) throws SQLException {
        return 0;
    }

    public Statement getStatement() throws SQLException {
        this.throwNotSupportedMethod("getStatement");
        return null;
    }

    public String getString(int columnIndex) throws SQLException {
        Object value = this.getObject(columnIndex);
        String result = value == null ? null : value.toString();
        return result;
    }

    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    public Time getTime(int columnIndex) throws SQLException {
        return null;
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "MemoryResultSetSapDB", "getTime");
    }

    public Time getTime(String columnName) throws SQLException {
        return null;
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "MemoryResultSetSapDB", "getTime");
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return null;
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "MemoryResultSetSapDB", "getTimestamp");
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return null;
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "MemoryResultSetSapDB", "getTimestamp");
    }

    public int getType() throws SQLException {
        this.throwNotSupportedMethod("getType");
        return 0;
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return null;
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return null;
    }

    public void insertRow() throws SQLException {
        this.throwNotSupportedMethod("insertRow");
    }

    public boolean isAfterLast() throws SQLException {
        this.throwNotSupportedMethod("isAfterLast");
        return false;
    }

    public boolean isBeforeFirst() throws SQLException {
        this.throwNotSupportedMethod("isBeforeFirst");
        return false;
    }

    public boolean isFirst() throws SQLException {
        this.throwNotSupportedMethod("isFirst");
        return false;
    }

    public boolean isLast() throws SQLException {
        this.throwNotSupportedMethod("isLast");
        return false;
    }

    public boolean last() throws SQLException {
        this.throwNotSupportedMethod("last");
        return false;
    }

    public void moveToCurrentRow() throws SQLException {
        this.throwNotSupportedMethod("moveToCurrentRow");
    }

    public void moveToInsertRow() throws SQLException {
        this.throwNotSupportedMethod("moveToInsertRow");
    }

    public boolean next() throws SQLException {
        boolean result;
        if (this.currentRow < this.rows.length - 1) {
            ++this.currentRow;
            result = true;
        } else {
            result = false;
        }
        return result;
    }

    public boolean previous() throws SQLException {
        this.throwNotSupportedMethod("previous");
        return false;
    }

    public void refreshRow() throws SQLException {
        this.throwNotSupportedMethod("refreshRow");
    }

    public boolean relative(int rows) throws SQLException {
        this.throwNotSupportedMethod("relative");
        return false;
    }

    public boolean rowDeleted() throws SQLException {
        this.throwNotSupportedMethod("rowDeleted");
        return false;
    }

    public boolean rowInserted() throws SQLException {
        this.throwNotSupportedMethod("rowInserted");
        return false;
    }

    public boolean rowUpdated() throws SQLException {
        this.throwNotSupportedMethod("rowUpdated");
        return false;
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.throwNotSupportedMethod("setFetchDirection");
    }

    public void setFetchSize(int rows) throws SQLException {
        this.throwNotSupportedMethod("setFetchSize");
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.throwNotSupportedMethod("updateAsciiStream");
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        this.throwNotSupportedMethod("updateAsciiStream");
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.throwNotSupportedMethod("updateBigDecimal");
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        this.throwNotSupportedMethod("updateBigDecimal");
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.throwNotSupportedMethod("updateBinaryStream");
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        this.throwNotSupportedMethod("updateBinaryStream");
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.throwNotSupportedMethod("updateBoolean");
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        this.throwNotSupportedMethod("updateBoolean");
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.throwNotSupportedMethod("updateByte");
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        this.throwNotSupportedMethod("updateByte");
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.throwNotSupportedMethod("updateBytes");
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        this.throwNotSupportedMethod("updateBytes");
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.throwNotSupportedMethod("updateCharacterStream");
    }

    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.throwNotSupportedMethod("updateCharacterStream");
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.throwNotSupportedMethod("updateDate");
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        this.throwNotSupportedMethod("updateDate");
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.throwNotSupportedMethod("updateDouble");
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        this.throwNotSupportedMethod("updateDouble");
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.throwNotSupportedMethod("updateFloat");
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        this.throwNotSupportedMethod("updateFloat");
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        this.throwNotSupportedMethod("updateInt");
    }

    public void updateInt(String columnName, int x) throws SQLException {
        this.throwNotSupportedMethod("updateInt");
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        this.throwNotSupportedMethod("updateLong");
    }

    public void updateLong(String columnName, long x) throws SQLException {
        this.throwNotSupportedMethod("updateLong");
    }

    public void updateNull(int columnIndex) throws SQLException {
        this.throwNotSupportedMethod("updateNull");
    }

    public void updateNull(String columnName) throws SQLException {
        this.throwNotSupportedMethod("updateNull");
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.throwNotSupportedMethod("updateObject");
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        this.throwNotSupportedMethod("updateObject");
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        this.throwNotSupportedMethod("updateObject");
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        this.throwNotSupportedMethod("updateObject");
    }

    public void updateRow() throws SQLException {
        this.throwNotSupportedMethod("updateRow");
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        this.throwNotSupportedMethod("updateShort");
    }

    public void updateShort(String columnName, short x) throws SQLException {
        this.throwNotSupportedMethod("updateShort");
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        this.throwNotSupportedMethod("updateString");
    }

    public void updateString(String columnName, String x) throws SQLException {
        this.throwNotSupportedMethod("updateString");
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.throwNotSupportedMethod("updateTime");
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        this.throwNotSupportedMethod("updateTime");
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.throwNotSupportedMethod("updateTimestamp");
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        this.throwNotSupportedMethod("updateTimestamp");
    }

    public boolean wasNull() throws SQLException {
        return false;
    }

    public URL getURL(int parm1) throws SQLException {
        this.throwNotImplementedMethod("getURL");
        return null;
    }

    public URL getURL(String parm1) throws SQLException {
        this.throwNotImplementedMethod("getURL");
        return null;
    }

    public void updateRef(int parm1, Ref parm2) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateRef(String parm1, Ref parm2) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateBlob(int parm1, Blob parm2) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateBlob(String parm1, Blob parm2) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateClob(int parm1, Clob parm2) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateClob(String parm1, Clob parm2) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateArray(int parm1, Array parm2) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateArray(String parm1, Array parm2) throws SQLException {
        this.throwNotUpdatable();
    }

    private void throwNotImplementedMethod(String methodName) {
        throw new UnsupportedOperationException(MessageTranslator.translate("error.memoryresult.method.notimplemented", methodName));
    }

    private void throwNotUpdatable() throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.resultset.notupdatable");
    }

    private void throwNotSupportedMethod(String methodName) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "MemoryResultSetSapDB", methodName);
    }

    public int getHoldability() throws SQLException {
        return 1;
    }

    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "getNCharacterStream", "MemoryResultSetSapDB");
    }

    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "getNCharacterStream", "MemoryResultSetSapDB");
    }

    public NClob getNClob(int columnIndex) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "getNClob", "MemoryResultSetSapDB");
    }

    public NClob getNClob(String columnLabel) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "getNClob", "MemoryResultSetSapDB");
    }

    public String getNString(int columnIndex) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "getNString", "MemoryResultSetSapDB");
    }

    public String getNString(String columnLabel) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "getNString", "MemoryResultSetSapDB");
    }

    public RowId getRowId(int columnIndex) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "getRowId", "MemoryResultSetSapDB");
    }

    public RowId getRowId(String columnLabel) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "getRowId", "MemoryResultSetSapDB");
    }

    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "getSQLXML", "MemoryResultSetSapDB");
    }

    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "getSQLXML", "MemoryResultSetSapDB");
    }

    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateNClob(int columnIndex, NClob clob) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateNClob(String columnLabel, NClob clob) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateNString(int columnIndex, String string) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateNString(String columnLabel, String string) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.throwNotUpdatable();
    }

    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.throwNotUpdatable();
    }
}

